/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtils$;
import kafka.admin.AdministrationException;
import kafka.common.TopicAndPartition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class AddPartitionsCommand$
implements Logging {
    public static final AddPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new AddPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AddPartitionsCommand$ addPartitionsCommand$ = this;
        synchronized (addPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("topic", "REQUIRED: The topic for which partitions need to be added.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("partition", "REQUIRED: Number of partitions to add to the topic").withRequiredArg().describedAs("# of partitions").ofType(Integer.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("replica-assignment-list", "For manually assigning replicas to brokers for the new partitions").withRequiredArg().describedAs("broker_id_for_part1_replica1 : broker_id_for_part1_replica2, broker_id_for_part2_replica1 : broker_id_for_part2_replica2, ...").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        OptionSet optionSet = optionParser.parse(stringArray);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec, argumentAcceptingOptionSpec2, argumentAcceptingOptionSpec3})).foreach((Function1)new Serializable(optionParser, optionSet){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            public final void apply(ArgumentAcceptingOptionSpec<? extends Comparable<? extends Object>> argumentAcceptingOptionSpec) {
                if (!this.options$1.has(argumentAcceptingOptionSpec)) {
                    System.err.println(new StringBuilder().append((Object)"***Please note that this tool can only be used to add partitions when data for a topic does not use a key.***\nMissing required argument.  \"").append(argumentAcceptingOptionSpec).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec);
        String string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
        int n = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3);
        String string3 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(string2, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            this.addPartitions(zkClient, string, n, string3);
            Predef$.MODULE$.println((Object)"adding partitions succeeded!");
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"adding partitions failed because of ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    public void addPartitions(ZkClient zkClient, String string, int n, String string2) {
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> map = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string})));
        if (map.size() == 0) {
            throw new AdministrationException(new StringOps(Predef$.MODULE$.augmentString("The topic %s does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
        }
        Seq seq = (Seq)map.get((Object)new TopicAndPartition(string, 0)).get();
        Seq<Object> seq2 = ZkUtils$.MODULE$.getSortedBrokerList(zkClient);
        String string3 = string2;
        String string4 = "";
        Object object = !(string3 != null ? !string3.equals(string4) : string4 != null) ? AdminUtils$.MODULE$.assignReplicasToBrokers(seq2, n, seq.size(), BoxesRunTime.unboxToInt((Object)seq.head()), map.size()) : this.getManualReplicaAssignment(string2, (Set<Object>)seq2.toSet(), map.size());
        Iterable iterable = (Iterable)object.values().filter((Function1)new Serializable(seq){
            public static final long serialVersionUID = 0L;
            private final Seq existingReplicaList$1;

            public final boolean apply(Seq<Object> seq) {
                return seq.size() != this.existingReplicaList$1.size();
            }
            {
                this.existingReplicaList$1 = seq;
            }
        });
        if (iterable.size() != 0) {
            throw new AdministrationException(new StringBuilder().append((Object)"The replication factor in manual replication assignment  is not equal to the existing replication factor for the topic ").append((Object)BoxesRunTime.boxToInteger((int)seq.size())).toString());
        }
        this.info((Function0<String>)new Serializable(string, (Map)object){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Map newPartitionReplicaList$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Add partition list for %s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.newPartitionReplicaList$1}));
            }
            {
                this.topic$1 = string;
                this.newPartitionReplicaList$1 = map;
            }
        });
        scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)map.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((TopicAndPartition)tuple2._1()).partition())), tuple2._2());
            }
        }, Map$.MODULE$.canBuildFrom());
        map2.$plus$plus$eq(object);
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(string, (Map<Object, Seq<Object>>)map2, zkClient, true);
    }

    public int addPartitions$default$3() {
        return 1;
    }

    public String addPartitions$default$4() {
        return "";
    }

    public scala.collection.immutable.Map<Object, List<Object>> getManualReplicaAssignment(String string, Set<Object> set, int n) {
        String[] stringArray = string.split(",");
        HashMap hashMap = new HashMap();
        IntRef intRef = new IntRef(n);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])stringArray).size()).foreach$mVc$sp((Function1)new Serializable(set, n, stringArray, hashMap, intRef){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerList$1;
            private final int startPartitionId$1;
            private final String[] partitionList$1;
            private final HashMap ret$1;
            private final IntRef partitionId$1;

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                int[] nArray = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[n].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String string) {
                        return new StringOps(Predef$.MODULE$.augmentString(string.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                if (Predef$.MODULE$.intArrayOps(nArray).size() <= 0) {
                    throw new AdministrationException("replication factor must be larger than 0");
                }
                if (Predef$.MODULE$.intArrayOps(nArray).size() != Predef$.MODULE$.intArrayOps(nArray).toSet().size()) {
                    throw new AdministrationException(new StringBuilder().append((Object)"duplicate brokers in replica assignment: ").append((Object)nArray).toString());
                }
                if (Predef$.MODULE$.intArrayOps(nArray).toSet().subsetOf((GenSet)this.availableBrokerList$1)) {
                    this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1.elem), (Object)Predef$.MODULE$.intArrayOps(nArray).toList());
                    if (((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1.elem))).size() != ((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)this.startPartitionId$1))).size()) {
                        throw new AdministrationException(new StringBuilder().append((Object)"partition ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" has different replication factor: ").append((Object)nArray).toString());
                    }
                    ++this.partitionId$1.elem;
                    return;
                }
                throw new AdministrationException(new StringBuilder().append((Object)"some specified brokers not available. specified brokers: ").append((Object)nArray.toString()).append((Object)"available broker:").append((Object)this.availableBrokerList$1.toString()).toString());
            }
            {
                this.availableBrokerList$1 = set;
                this.startPartitionId$1 = n;
                this.partitionList$1 = stringArray;
                this.ret$1 = hashMap;
                this.partitionId$1 = intRef;
            }
        });
        return hashMap.toMap(Predef$.MODULE$.conforms());
    }

    private AddPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

