/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class TupleForwarder<K, V> {
    private final CachedStateStore cachedStateStore;
    private final ProcessorContext context;

    TupleForwarder(StateStore store, ProcessorContext context, ForwardingCacheFlushListener flushListener, boolean sendOldValues) {
        this.cachedStateStore = this.cachedStateStore(store);
        this.context = context;
        if (this.cachedStateStore != null) {
            this.cachedStateStore.setFlushListener(flushListener, sendOldValues);
        }
    }

    private CachedStateStore cachedStateStore(StateStore store) {
        if (store instanceof CachedStateStore) {
            return (CachedStateStore)((Object)store);
        }
        if (store instanceof WrappedStateStore) {
            Object wrapped = ((WrappedStateStore)store).wrapped();
            while (wrapped instanceof WrappedStateStore && !(wrapped instanceof CachedStateStore)) {
                wrapped = ((WrappedStateStore)wrapped).wrapped();
            }
            if (!(wrapped instanceof CachedStateStore)) {
                return null;
            }
            return (CachedStateStore)wrapped;
        }
        return null;
    }

    public void maybeForward(K key, V newValue, V oldValue) {
        if (this.cachedStateStore == null) {
            this.context.forward(key, new Change<V>(newValue, oldValue));
        }
    }
}

