/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.HashMap;
import java.util.NoSuchElementException;

public class QuickUnion<T> {
    private final HashMap<T, T> ids = new HashMap();

    public void add(T id) {
        this.ids.put(id, id);
    }

    public boolean exists(T id) {
        return this.ids.containsKey(id);
    }

    public T root(T id) {
        T current = id;
        T parent = this.ids.get(current);
        if (parent == null) {
            throw new NoSuchElementException("id: " + id.toString());
        }
        while (!parent.equals(current)) {
            T grandparent = this.ids.get(parent);
            this.ids.put(current, grandparent);
            current = parent;
            parent = grandparent;
        }
        return current;
    }

    public void unite(T id1, T ... idList) {
        for (T id2 : idList) {
            this.unitePair(id1, id2);
        }
    }

    private void unitePair(T id1, T id2) {
        T root2;
        T root1 = this.root(id1);
        if (!root1.equals(root2 = this.root(id2))) {
            this.ids.put(root1, root2);
        }
    }
}

