/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.SourceNode;

public class ProcessorTopology {
    private final List<ProcessorNode> processorNodes;
    private final Map<String, SourceNode> sourceByTopics;
    private final List<StateStoreSupplier> stateStoreSuppliers;

    public ProcessorTopology(List<ProcessorNode> processorNodes, Map<String, SourceNode> sourceByTopics, List<StateStoreSupplier> stateStoreSuppliers) {
        this.processorNodes = Collections.unmodifiableList(processorNodes);
        this.sourceByTopics = Collections.unmodifiableMap(sourceByTopics);
        this.stateStoreSuppliers = Collections.unmodifiableList(stateStoreSuppliers);
    }

    public Set<String> sourceTopics() {
        return this.sourceByTopics.keySet();
    }

    public SourceNode source(String topic) {
        return this.sourceByTopics.get(topic);
    }

    public Set<SourceNode> sources() {
        return new HashSet<SourceNode>(this.sourceByTopics.values());
    }

    public List<ProcessorNode> processors() {
        return this.processorNodes;
    }

    public List<StateStoreSupplier> stateStoreSuppliers() {
        return this.stateStoreSuppliers;
    }
}

