/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;

@InterfaceStability.Unstable
public interface KStream<K, V> {
    public KStream<K, V> filter(Predicate<K, V> var1);

    public KStream<K, V> filterNot(Predicate<K, V> var1);

    public <K1> KStream<K1, V> selectKey(KeyValueMapper<K, V, K1> var1);

    public <K1, V1> KStream<K1, V1> map(KeyValueMapper<K, V, KeyValue<K1, V1>> var1);

    public <V1> KStream<K, V1> mapValues(ValueMapper<V, V1> var1);

    public void print();

    public void print(Serde<K> var1, Serde<V> var2);

    public void writeAsText(String var1);

    public void writeAsText(String var1, Serde<K> var2, Serde<V> var3);

    public <K1, V1> KStream<K1, V1> flatMap(KeyValueMapper<K, V, Iterable<KeyValue<K1, V1>>> var1);

    public <V1> KStream<K, V1> flatMapValues(ValueMapper<V, Iterable<V1>> var1);

    public KStream<K, V>[] branch(Predicate<K, V> ... var1);

    public KStream<K, V> through(String var1);

    public void foreach(ForeachAction<K, V> var1);

    public KStream<K, V> through(StreamPartitioner<K, V> var1, String var2);

    public KStream<K, V> through(Serde<K> var1, Serde<V> var2, String var3);

    public KStream<K, V> through(Serde<K> var1, Serde<V> var2, StreamPartitioner<K, V> var3, String var4);

    public void to(String var1);

    public void to(StreamPartitioner<K, V> var1, String var2);

    public void to(Serde<K> var1, Serde<V> var2, String var3);

    public void to(Serde<K> var1, Serde<V> var2, StreamPartitioner<K, V> var3, String var4);

    public <K1, V1> KStream<K1, V1> transform(TransformerSupplier<K, V, KeyValue<K1, V1>> var1, String ... var2);

    public <R> KStream<K, R> transformValues(ValueTransformerSupplier<V, R> var1, String ... var2);

    public void process(ProcessorSupplier<K, V> var1, String ... var2);

    public <V1, R> KStream<K, R> join(KStream<K, V1> var1, ValueJoiner<V, V1, R> var2, JoinWindows var3, Serde<K> var4, Serde<V> var5, Serde<V1> var6);

    public <V1, R> KStream<K, R> join(KStream<K, V1> var1, ValueJoiner<V, V1, R> var2, JoinWindows var3);

    public <V1, R> KStream<K, R> outerJoin(KStream<K, V1> var1, ValueJoiner<V, V1, R> var2, JoinWindows var3, Serde<K> var4, Serde<V> var5, Serde<V1> var6);

    public <V1, R> KStream<K, R> outerJoin(KStream<K, V1> var1, ValueJoiner<V, V1, R> var2, JoinWindows var3);

    public <V1, R> KStream<K, R> leftJoin(KStream<K, V1> var1, ValueJoiner<V, V1, R> var2, JoinWindows var3, Serde<K> var4, Serde<V1> var5);

    public <V1, R> KStream<K, R> leftJoin(KStream<K, V1> var1, ValueJoiner<V, V1, R> var2, JoinWindows var3);

    public <V1, V2> KStream<K, V2> leftJoin(KTable<K, V1> var1, ValueJoiner<V, V1, V2> var2);

    public <W extends Window> KTable<Windowed<K>, V> reduceByKey(Reducer<V> var1, Windows<W> var2, Serde<K> var3, Serde<V> var4);

    public <W extends Window> KTable<Windowed<K>, V> reduceByKey(Reducer<V> var1, Windows<W> var2);

    public KTable<K, V> reduceByKey(Reducer<V> var1, Serde<K> var2, Serde<V> var3, String var4);

    public KTable<K, V> reduceByKey(Reducer<V> var1, String var2);

    public <T, W extends Window> KTable<Windowed<K>, T> aggregateByKey(Initializer<T> var1, Aggregator<K, V, T> var2, Windows<W> var3, Serde<K> var4, Serde<T> var5);

    public <T, W extends Window> KTable<Windowed<K>, T> aggregateByKey(Initializer<T> var1, Aggregator<K, V, T> var2, Windows<W> var3);

    public <T> KTable<K, T> aggregateByKey(Initializer<T> var1, Aggregator<K, V, T> var2, Serde<K> var3, Serde<T> var4, String var5);

    public <T> KTable<K, T> aggregateByKey(Initializer<T> var1, Aggregator<K, V, T> var2, String var3);

    public <W extends Window> KTable<Windowed<K>, Long> countByKey(Windows<W> var1, Serde<K> var2);

    public <W extends Window> KTable<Windowed<K>, Long> countByKey(Windows<W> var1);

    public KTable<K, Long> countByKey(Serde<K> var1, String var2);

    public KTable<K, Long> countByKey(String var1);
}

