/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.processor.ConsumerRecordTimestampExtractor;
import org.apache.kafka.streams.processor.DefaultPartitionGrouper;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.apache.kafka.streams.processor.internals.StreamThread;

public class StreamsConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("application.id", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "An identifier for the stream processing application. Must be unique within the Kafka cluster. It is used as 1) the default client-id prefix, 2) the group-id for membership management, 3) the changelog topic prefix.").define("bootstrap.servers", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("client.id", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.").define("zookeeper.connect", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Zookeeper connect string for Kafka topics management.").define("state.dir", ConfigDef.Type.STRING, (Object)"/tmp/kafka-streams", ConfigDef.Importance.MEDIUM, "Directory location for state store.").define("replication.factor", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, "The replication factor for change log topics and repartition topics created by the stream processing application.").define("timestamp.extractor", ConfigDef.Type.CLASS, (Object)ConsumerRecordTimestampExtractor.class.getName(), ConfigDef.Importance.MEDIUM, "Timestamp extractor class that implements the <code>TimestampExtractor</code> interface.").define("partition.grouper", ConfigDef.Type.CLASS, (Object)DefaultPartitionGrouper.class.getName(), ConfigDef.Importance.MEDIUM, "Partition grouper class that implements the <code>PartitionGrouper</code> interface.").define("key.serde", ConfigDef.Type.CLASS, (Object)Serdes.ByteArraySerde.class.getName(), ConfigDef.Importance.MEDIUM, "Serializer / deserializer class for key that implements the <code>Serde</code> interface.").define("value.serde", ConfigDef.Type.CLASS, (Object)Serdes.ByteArraySerde.class.getName(), ConfigDef.Importance.MEDIUM, "Serializer / deserializer class for value that implements the <code>Serde</code> interface.").define("commit.interval.ms", ConfigDef.Type.LONG, (Object)30000, ConfigDef.Importance.LOW, "The frequency with which to save the position of the processor.").define("poll.ms", ConfigDef.Type.LONG, (Object)100, ConfigDef.Importance.LOW, "The amount of time in milliseconds to block waiting for input.").define("num.stream.threads", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.LOW, "The number of threads to execute stream processing.").define("num.standby.replicas", ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.LOW, "The number of standby replicas for each task.").define("buffered.records.per.partition", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "The maximum number of records to buffer per partition.").define("state.cleanup.delay.ms", ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.LOW, "The amount of time in milliseconds to wait before deleting state when a partition has migrated.").define("metric.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>MetricReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define("metrics.sample.window.ms", ConfigDef.Type.LONG, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.").define("metrics.num.samples", ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.");
    public static final String STATE_DIR_CONFIG = "state.dir";
    private static final String STATE_DIR_DOC = "Directory location for state store.";
    public static final String ZOOKEEPER_CONNECT_CONFIG = "zookeeper.connect";
    private static final String ZOOKEEPER_CONNECT_DOC = "Zookeeper connect string for Kafka topics management.";
    public static final String COMMIT_INTERVAL_MS_CONFIG = "commit.interval.ms";
    private static final String COMMIT_INTERVAL_MS_DOC = "The frequency with which to save the position of the processor.";
    public static final String POLL_MS_CONFIG = "poll.ms";
    private static final String POLL_MS_DOC = "The amount of time in milliseconds to block waiting for input.";
    public static final String NUM_STREAM_THREADS_CONFIG = "num.stream.threads";
    private static final String NUM_STREAM_THREADS_DOC = "The number of threads to execute stream processing.";
    public static final String NUM_STANDBY_REPLICAS_CONFIG = "num.standby.replicas";
    private static final String NUM_STANDBY_REPLICAS_DOC = "The number of standby replicas for each task.";
    public static final String BUFFERED_RECORDS_PER_PARTITION_CONFIG = "buffered.records.per.partition";
    private static final String BUFFERED_RECORDS_PER_PARTITION_DOC = "The maximum number of records to buffer per partition.";
    public static final String STATE_CLEANUP_DELAY_MS_CONFIG = "state.cleanup.delay.ms";
    private static final String STATE_CLEANUP_DELAY_MS_DOC = "The amount of time in milliseconds to wait before deleting state when a partition has migrated.";
    public static final String TIMESTAMP_EXTRACTOR_CLASS_CONFIG = "timestamp.extractor";
    private static final String TIMESTAMP_EXTRACTOR_CLASS_DOC = "Timestamp extractor class that implements the <code>TimestampExtractor</code> interface.";
    public static final String PARTITION_GROUPER_CLASS_CONFIG = "partition.grouper";
    private static final String PARTITION_GROUPER_CLASS_DOC = "Partition grouper class that implements the <code>PartitionGrouper</code> interface.";
    public static final String APPLICATION_ID_CONFIG = "application.id";
    public static final String APPLICATION_ID_DOC = "An identifier for the stream processing application. Must be unique within the Kafka cluster. It is used as 1) the default client-id prefix, 2) the group-id for membership management, 3) the changelog topic prefix.";
    public static final String REPLICATION_FACTOR_CONFIG = "replication.factor";
    public static final String REPLICATION_FACTOR_DOC = "The replication factor for change log topics and repartition topics created by the stream processing application.";
    public static final String KEY_SERDE_CLASS_CONFIG = "key.serde";
    public static final String KEY_SERDE_CLASS_DOC = "Serializer / deserializer class for key that implements the <code>Serde</code> interface.";
    public static final String VALUE_SERDE_CLASS_CONFIG = "value.serde";
    public static final String VALUE_SERDE_CLASS_DOC = "Serializer / deserializer class for value that implements the <code>Serde</code> interface.";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String CLIENT_ID_CONFIG = "client.id";

    public StreamsConfig(Map<?, ?> props) {
        super(CONFIG, props);
    }

    public Map<String, Object> getConsumerConfigs(StreamThread streamThread, String groupId, String clientId) {
        Map<String, Object> props = this.getBaseConsumerConfigs();
        props.put("group.id", groupId);
        props.put(CLIENT_ID_CONFIG, clientId + "-consumer");
        props.put("__stream.thread.instance__", streamThread);
        props.put(REPLICATION_FACTOR_CONFIG, this.getInt(REPLICATION_FACTOR_CONFIG));
        props.put(NUM_STANDBY_REPLICAS_CONFIG, this.getInt(NUM_STANDBY_REPLICAS_CONFIG));
        props.put("partition.assignment.strategy", StreamPartitionAssignor.class.getName());
        if (!this.getString(ZOOKEEPER_CONNECT_CONFIG).equals("")) {
            props.put(ZOOKEEPER_CONNECT_CONFIG, this.getString(ZOOKEEPER_CONNECT_CONFIG));
        }
        return props;
    }

    public Map<String, Object> getRestoreConsumerConfigs(String clientId) {
        Map<String, Object> props = this.getBaseConsumerConfigs();
        props.remove("group.id");
        props.put(CLIENT_ID_CONFIG, clientId + "-restore-consumer");
        return props;
    }

    private Map<String, Object> getBaseConsumerConfigs() {
        Map props = this.originals();
        this.removeStreamsSpecificConfigs(props);
        props.put("enable.auto.commit", "false");
        return props;
    }

    public Map<String, Object> getProducerConfigs(String clientId) {
        Map props = this.originals();
        props.remove("auto.offset.reset");
        this.removeStreamsSpecificConfigs(props);
        props.put("linger.ms", "100");
        props.put(CLIENT_ID_CONFIG, clientId + "-producer");
        return props;
    }

    private void removeStreamsSpecificConfigs(Map<String, Object> props) {
        props.remove(POLL_MS_CONFIG);
        props.remove(STATE_DIR_CONFIG);
        props.remove(APPLICATION_ID_CONFIG);
        props.remove(KEY_SERDE_CLASS_CONFIG);
        props.remove(VALUE_SERDE_CLASS_CONFIG);
        props.remove(ZOOKEEPER_CONNECT_CONFIG);
        props.remove(REPLICATION_FACTOR_CONFIG);
        props.remove(COMMIT_INTERVAL_MS_CONFIG);
        props.remove(NUM_STREAM_THREADS_CONFIG);
        props.remove(NUM_STANDBY_REPLICAS_CONFIG);
        props.remove(STATE_CLEANUP_DELAY_MS_CONFIG);
        props.remove(PARTITION_GROUPER_CLASS_CONFIG);
        props.remove(TIMESTAMP_EXTRACTOR_CLASS_CONFIG);
        props.remove(BUFFERED_RECORDS_PER_PARTITION_CONFIG);
        props.remove("__stream.thread.instance__");
    }

    public Serde keySerde() {
        Serde serde = (Serde)this.getConfiguredInstance(KEY_SERDE_CLASS_CONFIG, Serde.class);
        serde.configure(this.originals(), true);
        return serde;
    }

    public Serde valueSerde() {
        Serde serde = (Serde)this.getConfiguredInstance(VALUE_SERDE_CLASS_CONFIG, Serde.class);
        serde.configure(this.originals(), false);
        return serde;
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtmlTable());
    }

    public static class InternalConfig {
        public static final String STREAM_THREAD_INSTANCE = "__stream.thread.instance__";
    }
}

