/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Timer;
import org.junit.Assert;
import org.junit.Test;

public class TimerTest {
    private final MockTime time = new MockTime();

    @Test
    public void testTimerUpdate() {
        Timer timer = this.time.timer(500L);
        Assert.assertEquals((long)500L, (long)timer.remainingMs());
        Assert.assertEquals((long)0L, (long)timer.elapsedMs());
        this.time.sleep(100L);
        timer.update();
        Assert.assertEquals((long)400L, (long)timer.remainingMs());
        Assert.assertEquals((long)100L, (long)timer.elapsedMs());
        this.time.sleep(400L);
        timer.update(this.time.milliseconds());
        Assert.assertEquals((long)0L, (long)timer.remainingMs());
        Assert.assertEquals((long)500L, (long)timer.elapsedMs());
        Assert.assertTrue((boolean)timer.isExpired());
        this.time.sleep(200L);
        timer.update(this.time.milliseconds());
        Assert.assertTrue((boolean)timer.isExpired());
        Assert.assertEquals((long)0L, (long)timer.remainingMs());
        Assert.assertEquals((long)700L, (long)timer.elapsedMs());
    }

    @Test
    public void testTimerUpdateAndReset() {
        Timer timer = this.time.timer(500L);
        timer.sleep(200L);
        Assert.assertEquals((long)300L, (long)timer.remainingMs());
        Assert.assertEquals((long)200L, (long)timer.elapsedMs());
        timer.updateAndReset(400L);
        Assert.assertEquals((long)400L, (long)timer.remainingMs());
        Assert.assertEquals((long)0L, (long)timer.elapsedMs());
        timer.sleep(400L);
        Assert.assertTrue((boolean)timer.isExpired());
        timer.updateAndReset(200L);
        Assert.assertEquals((long)200L, (long)timer.remainingMs());
        Assert.assertEquals((long)0L, (long)timer.elapsedMs());
        Assert.assertFalse((boolean)timer.isExpired());
    }

    @Test
    public void testTimerResetUsesCurrentTime() {
        Timer timer = this.time.timer(500L);
        timer.sleep(200L);
        Assert.assertEquals((long)300L, (long)timer.remainingMs());
        Assert.assertEquals((long)200L, (long)timer.elapsedMs());
        this.time.sleep(300L);
        timer.reset(500L);
        Assert.assertEquals((long)500L, (long)timer.remainingMs());
        timer.update();
        Assert.assertEquals((long)200L, (long)timer.remainingMs());
    }

    @Test
    public void testTimeoutOverflow() {
        Timer timer = this.time.timer(Long.MAX_VALUE);
        Assert.assertEquals((long)(Long.MAX_VALUE - timer.currentTimeMs()), (long)timer.remainingMs());
        Assert.assertEquals((long)0L, (long)timer.elapsedMs());
    }

    @Test
    public void testNonMonotonicUpdate() {
        Timer timer = this.time.timer(100L);
        long currentTimeMs = timer.currentTimeMs();
        timer.update(currentTimeMs - 1L);
        Assert.assertEquals((long)currentTimeMs, (long)timer.currentTimeMs());
        Assert.assertEquals((long)100L, (long)timer.remainingMs());
        Assert.assertEquals((long)0L, (long)timer.elapsedMs());
    }

    @Test
    public void testTimerSleep() {
        Timer timer = this.time.timer(500L);
        long currentTimeMs = timer.currentTimeMs();
        timer.sleep(200L);
        Assert.assertEquals((long)this.time.milliseconds(), (long)timer.currentTimeMs());
        Assert.assertEquals((long)(currentTimeMs + 200L), (long)timer.currentTimeMs());
        timer.sleep(1000L);
        Assert.assertEquals((long)this.time.milliseconds(), (long)timer.currentTimeMs());
        Assert.assertEquals((long)(currentTimeMs + 500L), (long)timer.currentTimeMs());
        Assert.assertTrue((boolean)timer.isExpired());
    }
}

