/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceRequest;
import org.junit.Assert;
import org.junit.Test;

public class ProduceRequestTest {
    private final SimpleRecord simpleRecord = new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());

    @Test
    public void shouldBeFlaggedAsTransactionalWhenTransactionalRecords() throws Exception {
        MemoryRecords memoryRecords = MemoryRecords.withTransactionalRecords((long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)new ProduceRequest.Builder(2, -1, 10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
        Assert.assertTrue((boolean)request.isTransactional());
    }

    @Test
    public void shouldNotBeFlaggedAsTransactionalWhenNoRecords() throws Exception {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assert.assertFalse((boolean)request.isTransactional());
    }

    @Test
    public void shouldNotBeFlaggedAsIdempotentWhenRecordsNotIdempotent() throws Exception {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assert.assertFalse((boolean)request.isTransactional());
    }

    @Test
    public void shouldBeFlaggedAsIdempotentWhenIdempotentRecords() throws Exception {
        MemoryRecords memoryRecords = MemoryRecords.withIdempotentRecords((long)1L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)new ProduceRequest.Builder(2, -1, 10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
        Assert.assertTrue((boolean)request.isIdempotent());
    }

    private ProduceRequest createNonIdempotentNonTransactionalRecords() {
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        return (ProduceRequest)new ProduceRequest.Builder(2, -1, 10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
    }
}

