/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.junit.Assert;
import org.junit.Test;

public class SaslChannelBuilderTest {
    @Test
    public void testCloseBeforeConfigureIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT);
        builder.close();
        Assert.assertNull((Object)builder.loginManager());
        builder.close();
        Assert.assertNull((Object)builder.loginManager());
    }

    @Test
    public void testCloseAfterConfigIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT);
        builder.configure(new HashMap());
        Assert.assertNotNull((Object)builder.loginManager());
        builder.close();
        Assert.assertNull((Object)builder.loginManager());
        builder.close();
        Assert.assertNull((Object)builder.loginManager());
    }

    @Test
    public void testLoginManagerReleasedIfConfigureThrowsException() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_SSL);
        try {
            builder.configure(Collections.singletonMap("ssl.enabled.protocols", "1"));
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (KafkaException e) {
            Assert.assertNull((Object)builder.loginManager());
        }
        builder.close();
        Assert.assertNull((Object)builder.loginManager());
    }

    private SaslChannelBuilder createChannelBuilder(SecurityProtocol securityProtocol) {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig);
        return new SaslChannelBuilder(Mode.CLIENT, jaasContext, securityProtocol, "PLAIN", true, null);
    }
}

