/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProducerBatch;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;

public class ProducerBatchTest {
    private final long now = 1488748346917L;
    private final MemoryRecordsBuilder memoryRecordsBuilder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(128), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)128L);

    @Test
    public void testChecksumNullForMagicV2() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346917L);
        Assert.assertNotNull((Object)future);
        Assert.assertNull((Object)future.checksumOrNull());
    }

    @Test
    public void testBatchAbort() throws Exception {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346917L);
        KafkaException exception = new KafkaException();
        batch.abort((RuntimeException)((Object)exception));
        Assert.assertTrue((boolean)future.isDone());
        batch.done(500L, 2342342341L, null);
        batch.done(-1L, -1L, (RuntimeException)((Object)new KafkaException()));
        Assert.assertTrue((boolean)future.isDone());
        try {
            future.get();
            Assert.fail((String)"Future should have thrown");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)((Object)exception), (Object)e.getCause());
        }
    }

    @Test
    public void testBatchCannotAbortTwice() throws Exception {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346917L);
        KafkaException exception = new KafkaException();
        batch.abort((RuntimeException)((Object)exception));
        try {
            batch.abort((RuntimeException)((Object)new KafkaException()));
            Assert.fail((String)"Expected exception from abort");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)future.isDone());
        try {
            future.get();
            Assert.fail((String)"Future should have thrown");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)((Object)exception), (Object)e.getCause());
        }
    }

    @Test
    public void testBatchCannotCompleteTwice() throws Exception {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        FutureRecordMetadata future = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346917L);
        batch.done(500L, 10L, null);
        try {
            batch.done(1000L, 20L, null);
            Assert.fail((String)"Expected exception from done");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        RecordMetadata recordMetadata = future.get();
        Assert.assertEquals((long)500L, (long)recordMetadata.offset());
        Assert.assertEquals((long)10L, (long)recordMetadata.timestamp());
    }

    @Test
    public void testAppendedChecksumMagicV0AndV1() {
        for (byte magic : Arrays.asList((byte)0, (byte)1)) {
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(128), (byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), builder, 1488748346917L);
            byte[] key = "hi".getBytes();
            byte[] value = "there".getBytes();
            FutureRecordMetadata future = batch.tryAppend(1488748346917L, key, value, Record.EMPTY_HEADERS, null, 1488748346917L);
            Assert.assertNotNull((Object)future);
            byte attributes = LegacyRecord.computeAttributes((byte)magic, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
            long expectedChecksum = LegacyRecord.computeChecksum((byte)magic, (byte)attributes, (long)1488748346917L, (byte[])key, (byte[])value);
            Assert.assertEquals((long)expectedChecksum, (long)future.checksumOrNull());
        }
    }

    @Test
    public void testSplitPreservesHeaders() {
        for (CompressionType compressionType : CompressionType.values()) {
            FutureRecordMetadata future;
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), builder, 1488748346917L);
            RecordHeader header = new RecordHeader("header-key", "header-value".getBytes());
            while ((future = batch.tryAppend(1488748346917L, "hi".getBytes(), "there".getBytes(), new Header[]{header}, null, 1488748346917L)) != null) {
            }
            Deque batches = batch.split(200);
            Assert.assertTrue((String)"This batch should be split to multiple small batches.", (batches.size() >= 2 ? 1 : 0) != 0);
            for (ProducerBatch splitProducerBatch : batches) {
                for (RecordBatch splitBatch : splitProducerBatch.records().batches()) {
                    for (Record record : splitBatch) {
                        Assert.assertTrue((String)"Header size should be 1.", (record.headers().length == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)"Header key should be 'header-key'.", (boolean)record.headers()[0].key().equals("header-key"));
                        Assert.assertTrue((String)"Header value should be 'header-value'.", (boolean)new String(record.headers()[0].value()).equals("header-value"));
                    }
                }
            }
        }
    }

    @Test
    public void testSplitPreservesMagicAndCompressionType() {
        for (byte magic : Arrays.asList((byte)0, (byte)1, (byte)2)) {
            for (CompressionType compressionType : CompressionType.values()) {
                FutureRecordMetadata future;
                if (compressionType == CompressionType.NONE && magic < 2) continue;
                MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magic, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
                ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), builder, 1488748346917L);
                while ((future = batch.tryAppend(1488748346917L, "hi".getBytes(), "there".getBytes(), Record.EMPTY_HEADERS, null, 1488748346917L)) != null) {
                }
                Deque batches = batch.split(512);
                Assert.assertTrue((batches.size() >= 2 ? 1 : 0) != 0);
                for (ProducerBatch splitProducerBatch : batches) {
                    Assert.assertEquals((long)magic, (long)splitProducerBatch.magic());
                    Assert.assertTrue((boolean)splitProducerBatch.isSplitBatch());
                    for (RecordBatch splitBatch : splitProducerBatch.records().batches()) {
                        Assert.assertEquals((long)magic, (long)splitBatch.magic());
                        Assert.assertEquals((long)0L, (long)splitBatch.baseOffset());
                        Assert.assertEquals((Object)compressionType, (Object)splitBatch.compressionType());
                    }
                }
            }
        }
    }

    @Test
    public void testLargeLingerOldNowExpire() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        Assert.assertFalse((boolean)batch.maybeExpire(10240, 100L, 1488748346915L, Long.MAX_VALUE, false));
    }

    @Test
    public void testLargeRetryBackoffOldNowExpire() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        batch.reenqueued(1488748346917L);
        Assert.assertFalse((boolean)batch.maybeExpire(10240, Long.MAX_VALUE, 1488748346915L, 10240L, false));
    }

    @Test
    public void testLargeFullOldNowExpire() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        Assert.assertFalse((boolean)batch.maybeExpire(10240, 10240L, 1488748346915L, 10240L, true));
    }

    @Test
    public void testShouldNotAttemptAppendOnceRecordsBuilderIsClosedForAppends() {
        ProducerBatch batch = new ProducerBatch(new TopicPartition("topic", 1), this.memoryRecordsBuilder, 1488748346917L);
        FutureRecordMetadata result0 = batch.tryAppend(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346917L);
        Assert.assertNotNull((Object)result0);
        Assert.assertTrue((boolean)this.memoryRecordsBuilder.hasRoomFor(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS));
        this.memoryRecordsBuilder.closeForRecordAppends();
        Assert.assertFalse((boolean)this.memoryRecordsBuilder.hasRoomFor(1488748346917L, null, new byte[10], Record.EMPTY_HEADERS));
        Assert.assertEquals(null, (Object)batch.tryAppend(1488748346918L, null, new byte[10], Record.EMPTY_HEADERS, null, 1488748346918L));
    }
}

