/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.applib.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;

public class Util {
    private Util() {
    }

    public static Bookmark bookmarkFor(String str) {
        return str != null ? new Bookmark(str) : null;
    }

    public static String asString(Bookmark bookmark) {
        return bookmark != null ? bookmark.toString() : null;
    }

    public static Object lookupBookmark(Bookmark bookmark, BookmarkService bookmarkService, DomainObjectContainer container) {
        try {
            return bookmarkService != null ? bookmarkService.lookup(bookmark) : null;
        }
        catch (RuntimeException ex) {
            if (ex.getClass().getName().contains("ObjectNotFoundException")) {
                container.warnUser("Object not found - has it since been deleted?");
                return null;
            }
            throw ex;
        }
    }

    public static String abbreviated(String str, int maxLength) {
        return str != null ? (str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...") : null;
    }

    public static BigDecimal durationBetween(Timestamp startedAt, Timestamp completedAt) {
        if (completedAt == null) {
            return null;
        }
        long millis = completedAt.getTime() - startedAt.getTime();
        return new BigDecimal(millis).divide(new BigDecimal(1000)).setScale(3, RoundingMode.HALF_EVEN);
    }
}

