/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import org.apache.isis.applib.Defaults;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.value.Magnitude;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

@Value(semanticsProviderName="org.apache.isis.core.metamodel.facets.value.date.DateValueSemanticsProvider")
public class Date
extends Magnitude<Date> {
    private static final long serialVersionUID = 1L;
    private final DateTime date;

    public Date() {
        DateTime time = Clock.getTimeAsDateTime().withTime(0, 0, 0, 0);
        this.date = new DateTime((Object)time, Defaults.getTimeZone());
    }

    public Date(int year, int month, int day) {
        this.checkDate(year, month, day);
        this.date = this.newDateTime(year, month, day);
    }

    public Date(java.util.Date date) {
        this.date = new DateTime(date.getTime(), Defaults.getTimeZone());
    }

    public Date(long millisSinceEpoch) {
        this.date = new DateTime(millisSinceEpoch);
    }

    public Date(DateTime date) {
        this.date = new DateTime((Object)date);
    }

    private DateTime newDateTime(int year, int month, int day) {
        return new DateTime(year, month, day, 0, 0, 0, 0, Defaults.getTimeZone());
    }

    protected Date createDate(DateTime date) {
        Date newDate = new Date(date);
        return newDate;
    }

    public Date add(int years, int months, int days) {
        Period add = new Period(years, months, 0, days, 0, 0, 0, 0);
        DateTime newDate = this.date.plus((ReadablePeriod)add);
        return new Date(newDate);
    }

    private void checkDate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be in the range 1 - 12 inclusive");
        }
        DateTime newDate = this.newDateTime(year, month, 1);
        int lastDayOfMonth = newDate.dayOfMonth().getMaximumValue();
        if (day < 1 || day > lastDayOfMonth) {
            throw new IllegalArgumentException("Day must be in the range 1 - " + lastDayOfMonth + " inclusive: " + day);
        }
    }

    public java.util.Date dateValue() {
        java.util.Date javaDate = this.date.toDate();
        return javaDate;
    }

    public long getMillisSinceEpoch() {
        return this.date.getMillis();
    }

    public Date endOfMonth() {
        return new Date(this.date.dayOfMonth().withMaximumValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Date)) {
            return false;
        }
        Date date1 = (Date)o;
        return this.date.equals((Object)date1.date);
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfWeek() {
        return this.date.getDayOfWeek() - 1;
    }

    public int getMonth() {
        return this.date.getMonthOfYear();
    }

    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public boolean isEqualTo(Date date) {
        return this.date.equals((Object)date.date);
    }

    @Override
    public boolean isLessThan(Date date) {
        return this.date.isBefore((ReadableInstant)date.date);
    }

    private boolean sameAs(Date as, DateTimeFieldType field) {
        return this.date.get(field) == as.date.get(field);
    }

    public boolean sameDayOfMonthAs(Date as) {
        return this.sameAs(as, DateTimeFieldType.dayOfMonth());
    }

    public boolean sameDayOfWeekAs(Date as) {
        return this.sameAs(as, DateTimeFieldType.dayOfWeek());
    }

    public boolean sameDayOfYearAs(Date as) {
        return this.sameAs(as, DateTimeFieldType.dayOfYear());
    }

    public boolean sameMonthAs(Date as) {
        return this.sameAs(as, DateTimeFieldType.monthOfYear());
    }

    public boolean sameWeekAs(Date as) {
        return this.sameAs(as, DateTimeFieldType.weekOfWeekyear());
    }

    public boolean sameYearAs(Date as) {
        return this.sameAs(as, DateTimeFieldType.year());
    }

    public Date startOfMonth() {
        return new Date(this.date.dayOfMonth().withMinimumValue());
    }

    public Date startOfWeek() {
        return new Date(this.date.dayOfWeek().withMinimumValue());
    }

    public Date startOfYear() {
        return new Date(this.date.dayOfYear().withMinimumValue());
    }

    public String title() {
        return DateTimeFormat.mediumDate().print((ReadableInstant)this.date);
    }

    public String toString() {
        return String.format("%04d-%02d-%02d", this.getYear(), this.getMonth(), this.getDay());
    }
}

