/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public final class Enums {
    private static Function<String, String> LOWER_CASE_THEN_CAPITALIZE = new Function<String, String>(){

        public String apply(String input) {
            return Enums.capitalize(input.toLowerCase());
        }
    };
    private static Function<String, String> UPPER_CASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toUpperCase();
        }
    };

    private Enums() {
    }

    public static String getFriendlyNameOf(Enum<?> anEnum) {
        return Enums.getFriendlyNameOf(anEnum.name());
    }

    public static String getFriendlyNameOf(String anEnumName) {
        return Joiner.on((String)" ").join(Iterables.transform((Iterable)Splitter.on((String)"_").split((CharSequence)anEnumName), LOWER_CASE_THEN_CAPITALIZE));
    }

    public static String getEnumNameFromFriendly(String anEnumFriendlyName) {
        return Joiner.on((String)"_").join(Iterables.transform((Iterable)Splitter.on((String)" ").split((CharSequence)anEnumFriendlyName), UPPER_CASE));
    }

    public static String enumToHttpHeader(Enum<?> anEnum) {
        return Enums.enumNameToHttpHeader(anEnum.name());
    }

    public static String enumNameToHttpHeader(String name) {
        StringBuilder builder = new StringBuilder();
        boolean nextUpper = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                nextUpper = true;
                builder.append("-");
                continue;
            }
            builder.append(nextUpper ? c : Character.toLowerCase(c));
            nextUpper = false;
        }
        return builder.toString();
    }

    public static String enumToCamelCase(Enum<?> anEnum) {
        return Enums.enumNameToCamelCase(anEnum.name());
    }

    private static String enumNameToCamelCase(String name) {
        StringBuilder builder = new StringBuilder();
        boolean nextUpper = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                nextUpper = true;
                continue;
            }
            builder.append(nextUpper ? c : Character.toLowerCase(c));
            nextUpper = false;
        }
        return builder.toString();
    }

    private static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

