/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publish;

import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.publish.EventType;

public class EventMetadata {
    private final UUID transactionId;
    private final int sequence;
    private final String user;
    private final Timestamp javaSqlTimestamp;
    private final String title;
    private final EventType eventType;
    private final String targetClass;
    private final String targetAction;
    private final Bookmark target;
    private final String actionIdentifier;
    private final List<String> actionParameterNames;
    private final List<Class<?>> actionParameterTypes;
    private final Class<?> actionReturnType;

    @Deprecated
    public EventMetadata(UUID transactionId, int sequence, EventType eventType, String user, long timestamp, String title) {
        this(transactionId, sequence, eventType, user, new Timestamp(timestamp), title, null, null, null, null);
    }

    @Deprecated
    public EventMetadata(UUID transactionId, int sequence, EventType eventType, String user, Timestamp javaSqlTimestamp, String title, String targetClass, String targetAction, Bookmark target, String actionIdentifier) {
        this(transactionId, sequence, eventType, user, javaSqlTimestamp, title, targetClass, targetAction, target, actionIdentifier, null, null, null);
    }

    public EventMetadata(UUID transactionId, int sequence, EventType eventType, String user, Timestamp javaSqlTimestamp, String title, String targetClass, String targetAction, Bookmark target, String actionIdentifier, List<String> actionParameterNames, List<Class<?>> actionParameterTypes, Class<?> actionReturnType) {
        this.transactionId = transactionId;
        this.sequence = sequence;
        this.user = user;
        this.javaSqlTimestamp = javaSqlTimestamp;
        this.title = title;
        this.eventType = eventType;
        this.targetClass = targetClass;
        this.targetAction = targetAction;
        this.target = target;
        this.actionIdentifier = actionIdentifier;
        this.actionParameterNames = actionParameterNames;
        this.actionParameterTypes = actionParameterTypes;
        this.actionReturnType = actionReturnType;
    }

    public UUID getTransactionId() {
        return this.transactionId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getUser() {
        return this.user;
    }

    public Timestamp getJavaSqlTimestamp() {
        return this.javaSqlTimestamp;
    }

    @Deprecated
    public long getTimestamp() {
        return this.getJavaSqlTimestamp().getTime();
    }

    public String getId() {
        return this.getTransactionId() + "." + this.getSequence();
    }

    public String getTitle() {
        return this.title;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public Bookmark getTarget() {
        return this.target;
    }

    public String getTargetAction() {
        return this.targetAction;
    }

    public String getActionIdentifier() {
        return this.actionIdentifier;
    }

    public List<String> getActionParameterNames() {
        return this.actionParameterNames;
    }

    public List<Class<?>> getActionParameterTypes() {
        return this.actionParameterTypes;
    }

    public Class<?> getActionReturnType() {
        return this.actionReturnType;
    }

    public String toString() {
        return this.getId();
    }
}

