/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.fixturespec;

import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScripts;

public class FixtureScriptsSpecification {
    private final String packagePrefix;
    private final FixtureScripts.NonPersistedObjectsStrategy nonPersistedObjectsStrategy;
    private final FixtureScripts.MultipleExecutionStrategy multipleExecutionStrategy;
    private final Class<? extends FixtureScript> recreateScriptClass;
    private final Class<? extends FixtureScript> runScriptDefaultScriptClass;
    private final DropDownPolicy dropDownPolicy;

    public FixtureScriptsSpecification(String packagePrefix, FixtureScripts.NonPersistedObjectsStrategy nonPersistedObjectsStrategy, FixtureScripts.MultipleExecutionStrategy multipleExecutionStrategy, Class<? extends FixtureScript> runScriptDefaultScriptClass, DropDownPolicy runScriptDropDownPolicy, Class<? extends FixtureScript> recreateScriptClass) {
        this.packagePrefix = packagePrefix;
        this.nonPersistedObjectsStrategy = nonPersistedObjectsStrategy;
        this.multipleExecutionStrategy = multipleExecutionStrategy;
        this.recreateScriptClass = recreateScriptClass;
        this.runScriptDefaultScriptClass = runScriptDefaultScriptClass;
        this.dropDownPolicy = runScriptDropDownPolicy;
    }

    @Programmatic
    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    @Programmatic
    public FixtureScripts.NonPersistedObjectsStrategy getNonPersistedObjectsStrategy() {
        return this.nonPersistedObjectsStrategy;
    }

    @Programmatic
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.multipleExecutionStrategy;
    }

    @Programmatic
    public Class<? extends FixtureScript> getRunScriptDefaultScriptClass() {
        return this.runScriptDefaultScriptClass;
    }

    @Programmatic
    public DropDownPolicy getRunScriptDropDownPolicy() {
        return this.dropDownPolicy;
    }

    @Programmatic
    public Class<? extends FixtureScript> getRecreateScriptClass() {
        return this.recreateScriptClass;
    }

    public static Builder builder(Class<?> contextClass) {
        return new Builder(contextClass);
    }

    public static Builder builder(String packagePrefix) {
        return new Builder(packagePrefix);
    }

    public static class Builder {
        private final String packagePrefix;
        private FixtureScripts.NonPersistedObjectsStrategy nonPersistedObjectsStrategy = FixtureScripts.NonPersistedObjectsStrategy.PERSIST;
        private FixtureScripts.MultipleExecutionStrategy multipleExecutionStrategy = FixtureScripts.MultipleExecutionStrategy.IGNORE;
        private Class<? extends FixtureScript> recreateScriptClass = null;
        private Class<? extends FixtureScript> defaultScriptClass = null;
        private DropDownPolicy dropDownPolicy = DropDownPolicy.CHOICES;

        public Builder(Class<?> contextClass) {
            this(contextClass.getPackage().getName());
        }

        public Builder(String packagePrefix) {
            this.packagePrefix = packagePrefix;
        }

        public Builder with(FixtureScripts.NonPersistedObjectsStrategy nonPersistedObjectsStrategy) {
            this.nonPersistedObjectsStrategy = nonPersistedObjectsStrategy;
            return this;
        }

        public Builder with(FixtureScripts.MultipleExecutionStrategy multipleExecutionStrategy) {
            this.multipleExecutionStrategy = multipleExecutionStrategy;
            return this;
        }

        public Builder withRecreate(Class<? extends FixtureScript> recreateScriptClass) {
            this.recreateScriptClass = recreateScriptClass;
            return this;
        }

        public Builder withRunScriptDefault(Class<? extends FixtureScript> defaultScriptClass) {
            this.defaultScriptClass = defaultScriptClass;
            return this;
        }

        public Builder withRunScriptDropDown(DropDownPolicy dropDownPolicy) {
            this.dropDownPolicy = dropDownPolicy;
            return this;
        }

        public FixtureScriptsSpecification build() {
            return new FixtureScriptsSpecification(this.packagePrefix, this.nonPersistedObjectsStrategy, this.multipleExecutionStrategy, this.defaultScriptClass, this.dropDownPolicy, this.recreateScriptClass);
        }
    }

    public static enum DropDownPolicy {
        AUTO_COMPLETE,
        CHOICES;


        public boolean isAutoComplete() {
            return this == AUTO_COMPLETE;
        }

        public boolean isChoices() {
            return this == CHOICES;
        }
    }
}

