/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.fixturespec;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.MinLength;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.fixturescripts.FixtureResult;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.services.fixturespec.FixtureScriptsSpecification;
import org.apache.isis.applib.services.fixturespec.FixtureScriptsSpecificationProvider;

@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.10")
public class FixtureScriptsDefault
extends FixtureScripts {
    public static final String PACKAGE_PREFIX = FixtureScriptsDefault.class.getPackage().getName();
    @Inject
    private FixtureScriptsSpecificationProvider fixtureScriptsSpecificationProvider;

    public FixtureScriptsDefault() {
        super(PACKAGE_PREFIX);
    }

    @Override
    @PostConstruct
    public void init() {
        if (this.fixtureScriptsSpecificationProvider == null) {
            return;
        }
        this.setSpecification(this.fixtureScriptsSpecificationProvider.getSpecification());
    }

    @Override
    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @MemberOrder(sequence="10")
    public List<FixtureResult> runFixtureScript(FixtureScript fixtureScript, @ParameterLayout(named="Parameters", describedAs="Script-specific parameters (if any).  The format depends on the script implementation (eg key=value, CSV, JSON, XML etc)", multiLine=10) @Parameter(optionality=Optionality.OPTIONAL) String parameters) {
        return super.runFixtureScript(fixtureScript, parameters);
    }

    public boolean hideRunFixtureScript() {
        return this.hideIfPolicyNot(FixtureScriptsSpecification.DropDownPolicy.CHOICES);
    }

    @Override
    public String disableRunFixtureScript(FixtureScript fixtureScript, String parameters) {
        return super.disableRunFixtureScript(fixtureScript, parameters);
    }

    @Override
    public FixtureScript default0RunFixtureScript() {
        Class<? extends FixtureScript> defaultScript = this.getSpecification().getRunScriptDefaultScriptClass();
        if (defaultScript == null) {
            return null;
        }
        return this.findFixtureScriptFor(defaultScript);
    }

    @Override
    public List<FixtureScript> choices0RunFixtureScript() {
        return super.choices0RunFixtureScript();
    }

    @Override
    public String validateRunFixtureScript(FixtureScript fixtureScript, String parameters) {
        return super.validateRunFixtureScript(fixtureScript, parameters);
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(named="Run Fixture Script")
    @MemberOrder(sequence="10")
    public List<FixtureResult> runFixtureScriptWithAutoComplete(FixtureScript fixtureScript, @ParameterLayout(named="Parameters", describedAs="Script-specific parameters (if any).  The format depends on the script implementation (eg key=value, CSV, JSON, XML etc)", multiLine=10) @Parameter(optionality=Optionality.OPTIONAL) String parameters) {
        return this.runFixtureScript(fixtureScript, parameters);
    }

    public boolean hideRunFixtureScriptWithAutoComplete() {
        return this.hideIfPolicyNot(FixtureScriptsSpecification.DropDownPolicy.AUTO_COMPLETE);
    }

    public String disableRunFixtureScriptWithAutoComplete(FixtureScript fixtureScript, String parameters) {
        return this.disableRunFixtureScript(fixtureScript, parameters);
    }

    public FixtureScript default0RunFixtureScriptWithAutoComplete() {
        return this.default0RunFixtureScript();
    }

    public List<FixtureScript> autoComplete0RunFixtureScriptWithAutoComplete(@MinLength(value=1) String arg) {
        return this.autoComplete0RunFixtureScript(arg);
    }

    public String validateRunFixtureScriptWithAutoComplete(FixtureScript fixtureScript, String parameters) {
        return super.validateRunFixtureScript(fixtureScript, parameters);
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa fa-refresh")
    @MemberOrder(sequence="20")
    public Object recreateObjectsAndReturnFirst() {
        Class<? extends FixtureScript> recreateScriptClass = this.getSpecification().getRecreateScriptClass();
        FixtureScript recreateScript = this.findFixtureScriptFor(recreateScriptClass);
        if (recreateScript == null) {
            return null;
        }
        List<FixtureResult> results = recreateScript.run(null);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0).getObject();
    }

    public boolean hideRecreateObjectsAndReturnFirst() {
        return this.getSpecification().getRecreateScriptClass() == null;
    }

    private boolean hideIfPolicyNot(FixtureScriptsSpecification.DropDownPolicy requiredPolicy) {
        return this.fixtureScriptsSpecificationProvider == null || this.getSpecification().getRunScriptDropDownPolicy() != requiredPolicy;
    }
}

