/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import java.util.List;
import javax.jdo.JDODataStoreException;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer2;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerAbstract;

public class ExceptionRecognizerForType
extends ExceptionRecognizerAbstract {
    protected static final Predicate<Throwable> ofTypeExcluding(Class<? extends Throwable> exceptionType, String ... messages) {
        return Predicates.and(ExceptionRecognizerForType.ofType(exceptionType), ExceptionRecognizerForType.excluding(messages));
    }

    protected static final Predicate<Throwable> ofTypeIncluding(Class<? extends Throwable> exceptionType, String ... messages) {
        return Predicates.and(ExceptionRecognizerForType.ofType(exceptionType), ExceptionRecognizerForType.including(messages));
    }

    protected static final Predicate<Throwable> ofType(final Class<? extends Throwable> exceptionType) {
        return new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                return exceptionType.isAssignableFrom(input.getClass());
            }
        };
    }

    protected static final Predicate<Throwable> excluding(final String ... messages) {
        return new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                List causalChain = Throwables.getCausalChain((Throwable)input);
                for (String message : messages) {
                    for (Throwable throwable : causalChain) {
                        Throwable[] nestedExceptions;
                        String throwableMessage = throwable.getMessage();
                        if (throwableMessage != null && throwableMessage.contains(message)) {
                            return false;
                        }
                        if (!(throwable instanceof JDODataStoreException)) continue;
                        JDODataStoreException jdoDataStoreException = (JDODataStoreException)throwable;
                        for (Throwable nestedException : nestedExceptions = jdoDataStoreException.getNestedExceptions()) {
                            String nestedThrowableMessage = nestedException.getMessage();
                            if (nestedThrowableMessage == null || !nestedThrowableMessage.contains(message)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        };
    }

    protected static final Predicate<Throwable> including(final String ... messages) {
        return new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                List causalChain = Throwables.getCausalChain((Throwable)input);
                for (String message : messages) {
                    for (Throwable throwable : causalChain) {
                        String throwableMessage = throwable.getMessage();
                        if (throwableMessage == null || !throwableMessage.contains(message)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public ExceptionRecognizerForType(ExceptionRecognizer2.Category category, Class<? extends Exception> exceptionType, Function<String, String> messageParser) {
        this(category, ExceptionRecognizerForType.ofType(exceptionType), messageParser);
    }

    public ExceptionRecognizerForType(ExceptionRecognizer2.Category category, Predicate<Throwable> predicate, Function<String, String> messageParser) {
        super(category, predicate, messageParser);
    }

    public ExceptionRecognizerForType(ExceptionRecognizer2.Category category, Class<? extends Exception> exceptionType) {
        this(category, exceptionType, null);
    }

    public ExceptionRecognizerForType(Class<? extends Exception> exceptionType, Function<String, String> messageParser) {
        this(ExceptionRecognizer2.Category.OTHER, exceptionType, messageParser);
    }

    public ExceptionRecognizerForType(Predicate<Throwable> predicate, Function<String, String> messageParser) {
        this(ExceptionRecognizer2.Category.OTHER, predicate, messageParser);
    }

    public ExceptionRecognizerForType(Class<? extends Exception> exceptionType) {
        this(ExceptionRecognizer2.Category.OTHER, exceptionType);
    }
}

