/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer2;
import org.apache.isis.applib.services.i18n.TranslationService;

public class ExceptionRecognizerComposite
implements ExceptionRecognizer2 {
    private final List<ExceptionRecognizer> exceptionRecognizers = Lists.newArrayList();
    @Inject
    DomainObjectContainer container;
    @Inject
    TranslationService translationService;

    public ExceptionRecognizerComposite(ExceptionRecognizer ... exceptionRecognizers) {
        this(Arrays.asList(exceptionRecognizers));
    }

    public ExceptionRecognizerComposite(List<ExceptionRecognizer> exceptionRecognizers) {
        for (ExceptionRecognizer er : exceptionRecognizers) {
            this.add(er);
        }
    }

    @Programmatic
    public final void add(ExceptionRecognizer ers) {
        this.exceptionRecognizers.add(ers);
    }

    @Override
    @Programmatic
    public final String recognize(Throwable ex) {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            String message = ers.recognize(ex);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    @Override
    @Programmatic
    public final ExceptionRecognizer2.Recognition recognize2(Throwable ex) {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            ExceptionRecognizer2 recognizer2;
            ExceptionRecognizer2.Recognition recognition;
            if (!(ers instanceof ExceptionRecognizer2) || (recognition = (recognizer2 = (ExceptionRecognizer2)ers).recognize2(ex)) == null) continue;
            return recognition;
        }
        return ExceptionRecognizer2.Recognition.of(ExceptionRecognizer2.Category.OTHER, this.recognize(ex));
    }

    @Override
    @PostConstruct
    @Programmatic
    public void init(Map<String, String> properties) {
        this.injectServices();
        this.initRecognizers(properties);
    }

    protected void injectServices() {
        if (this.container != null) {
            for (ExceptionRecognizer ers : this.exceptionRecognizers) {
                this.container.injectServicesInto(ers);
            }
        }
    }

    protected void initRecognizers(Map<String, String> properties) {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            ers.init(properties);
        }
    }

    @Override
    @PreDestroy
    @Programmatic
    public void shutdown() {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            ers.shutdown();
        }
    }
}

