/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.classdiscovery;

import java.util.List;
import java.util.Set;
import org.apache.isis.applib.AbstractService;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryService2;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.vfs.Vfs;

@DomainService(nature=NatureOfService.DOMAIN)
public class ClassDiscoveryServiceUsingReflections
extends AbstractService
implements ClassDiscoveryService2 {
    @Override
    @Programmatic
    public <T> Set<Class<? extends T>> findSubTypesOfClasses(Class<T> type) {
        Vfs.setDefaultURLTypes(ClassDiscoveryServiceUsingReflections.getUrlTypes());
        Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()}), ClasspathHelper.forClass(Object.class, (ClassLoader[])new ClassLoader[0]), new SubTypesScanner(false)});
        return reflections.getSubTypesOf(type);
    }

    @Override
    @Programmatic
    public <T> Set<Class<? extends T>> findSubTypesOfClasses(Class<T> type, String packagePrefix) {
        if (type == FixtureScript.class) {
            Set<Class<? extends T>> fixtureScriptTypes = AppManifest.Registry.instance().getFixtureScriptTypes();
            return fixtureScriptTypes;
        }
        Vfs.setDefaultURLTypes(ClassDiscoveryServiceUsingReflections.getUrlTypes());
        Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()}), ClasspathHelper.forClass(Object.class, (ClassLoader[])new ClassLoader[0]), ClasspathHelper.forPackage((String)packagePrefix, (ClassLoader[])new ClassLoader[0]), new SubTypesScanner(false)});
        return reflections.getSubTypesOf(type);
    }

    public static List<Vfs.UrlType> getUrlTypes() {
        return AppManifest.Registry.instance().getUrlTypes();
    }
}

