/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.query;

import org.apache.isis.applib.query.Query;

public abstract class QueryAbstract<T>
implements Query<T> {
    protected long start;
    protected long count;
    private static final long serialVersionUID = 1L;
    private final String resultTypeName;
    private transient Class<T> resultType;

    public QueryAbstract(Class<T> type, long ... range) {
        this.resultTypeName = type.getName();
        this.start = range.length > 0 ? range[0] : 0L;
        this.count = range.length > 1 ? range[1] : 0L;
    }

    public QueryAbstract(String typeName, long ... range) {
        this.resultTypeName = typeName;
        this.start = range.length > 0 ? range[0] : 0L;
        this.count = range.length > 1 ? range[1] : 0L;
    }

    @Override
    public Class<T> getResultType() {
        if (this.resultType == null) {
            try {
                this.resultType = Thread.currentThread().getContextClassLoader().loadClass(this.resultTypeName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

