/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class ExecutionParameters {
    private static final Pattern keyEqualsValuePattern = Pattern.compile("([^=]*)=(.*)");
    private final String parameters;
    private final Map<String, String> parameterMap;

    public ExecutionParameters(String parameters) {
        this.parameters = parameters;
        this.parameterMap = ExecutionParameters.asKeyValueMap(parameters);
    }

    static Map<String, String> asKeyValueMap(String parameters) {
        LinkedHashMap keyValues = Maps.newLinkedHashMap();
        if (parameters != null) {
            try {
                ImmutableList lines = CharSource.wrap((CharSequence)parameters).readLines();
                for (String line : lines) {
                    Matcher matcher;
                    if (line == null || !(matcher = keyEqualsValuePattern.matcher(line)).matches()) continue;
                    keyValues.put(matcher.group(1).trim(), matcher.group(2).trim());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return keyValues;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getParameter(String parameterName) {
        return this.parameterMap.get(parameterName);
    }

    public <T> T getParameterAsT(String parameterName, Class<T> cls) {
        Object value = null;
        if (Enum.class.isAssignableFrom(cls)) {
            Class<T> enumClass = cls;
            value = this.getParameterAsEnum(parameterName, enumClass);
        } else if (cls == Boolean.class) {
            value = this.getParameterAsBoolean(parameterName);
        } else if (cls == Byte.class) {
            value = this.getParameterAsByte(parameterName);
        } else if (cls == Short.class) {
            value = this.getParameterAsShort(parameterName);
        } else if (cls == Integer.class) {
            value = this.getParameterAsInteger(parameterName);
        } else if (cls == Long.class) {
            value = this.getParameterAsLong(parameterName);
        } else if (cls == Float.class) {
            value = this.getParameterAsFloat(parameterName);
        } else if (cls == Double.class) {
            value = this.getParameterAsDouble(parameterName);
        } else if (cls == Character.class) {
            value = this.getParameterAsCharacter(parameterName);
        } else if (cls == BigDecimal.class) {
            value = this.getParameterAsBigDecimal(parameterName);
        } else if (cls == BigInteger.class) {
            value = this.getParameterAsBigInteger(parameterName);
        } else if (cls == LocalDate.class) {
            value = this.getParameterAsLocalDate(parameterName);
        } else if (cls == LocalDateTime.class) {
            value = this.getParameterAsLocalDateTime(parameterName);
        } else if (cls == String.class) {
            value = this.getParameter(parameterName);
        }
        return (T)value;
    }

    public Boolean getParameterAsBoolean(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public Byte getParameterAsByte(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Byte.valueOf(value);
    }

    public Short getParameterAsShort(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Short.valueOf(value);
    }

    public Integer getParameterAsInteger(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Long getParameterAsLong(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    public Float getParameterAsFloat(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Float.valueOf(value);
    }

    public Double getParameterAsDouble(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Double.valueOf(value);
    }

    public Character getParameterAsCharacter(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public BigInteger getParameterAsBigInteger(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return new BigInteger(value);
    }

    public BigDecimal getParameterAsBigDecimal(String parameterName) {
        String value = this.getParameter(parameterName);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return new BigDecimal(value);
    }

    public LocalDate getParameterAsLocalDate(String parameterName) {
        String value = this.getParameter(parameterName);
        if (value == null) {
            return null;
        }
        return LocalDate.parse((String)value);
    }

    public LocalDateTime getParameterAsLocalDateTime(String parameterName) {
        String value = this.getParameter(parameterName);
        if (value == null) {
            return null;
        }
        return LocalDateTime.parse((String)value);
    }

    public <T extends Enum<T>> T getParameterAsEnum(String parameterName, Class<T> enumClass) {
        String value = this.getParameter(parameterName);
        return ExecutionParameters.valueOfElseNull(enumClass, value);
    }

    private static <T extends Enum<T>> T valueOfElseNull(Class<T> enumClass, String value) {
        Enum[] enumConstants;
        if (value == null) {
            return null;
        }
        for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().equals(value)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    public Map<String, String> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public void setParameterIfNotPresent(String parameterName, String parameterValue) {
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName required");
        }
        if (parameterValue == null) {
            return;
        }
        if (this.parameterMap.containsKey(parameterName)) {
            return;
        }
        this.parameterMap.put(parameterName, parameterValue);
    }

    public void setParameter(String parameterName, Boolean parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Byte parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Short parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Integer parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Long parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Float parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Double parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Character parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, BigInteger parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, java.util.Date parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Date parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, LocalDate parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, LocalDateTime parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, DateTime parameterValue) {
        StringBuffer buf = new StringBuffer();
        ISODateTimeFormat.dateTimeParser().printTo(buf, (ReadableInstant)parameterValue);
        this.setParameter(parameterName, parameterValue != null ? buf.toString() : null);
    }

    public void setParameter(String parameterName, BigDecimal parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    public void setParameter(String parameterName, Enum<?> parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.name() : null);
    }

    public void setParameter(String parameterName, String parameterValue) {
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName required");
        }
        if (parameterValue == null) {
            return;
        }
        this.parameterMap.put(parameterName, parameterValue);
    }
}

