/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.applib.services.i18n.TranslatableString;

public interface DomainObjectContainer {
    @Programmatic
    public String titleOf(Object var1);

    @Programmatic
    @Deprecated
    public void resolve(Object var1);

    @Programmatic
    @Deprecated
    public void resolve(Object var1, Object var2);

    @Programmatic
    @Deprecated
    public void objectChanged(Object var1);

    @Programmatic
    public boolean flush();

    @Programmatic
    @Deprecated
    public void commit();

    @Programmatic
    public <T> T newTransientInstance(Class<T> var1);

    @Programmatic
    public <T> T newViewModelInstance(Class<T> var1, String var2);

    @Programmatic
    public <T> T newAggregatedInstance(Object var1, Class<T> var2);

    @Programmatic
    @Deprecated
    public <T> T newPersistentInstance(Class<T> var1);

    @Programmatic
    @Deprecated
    public <T> T newInstance(Class<T> var1, Object var2);

    @Programmatic
    public <T> T injectServicesInto(T var1);

    @Programmatic
    public <T> T lookupService(Class<T> var1);

    @Programmatic
    public <T> Iterable<T> lookupServices(Class<T> var1);

    @Programmatic
    public boolean isValid(Object var1);

    @Programmatic
    public String validate(Object var1);

    @Programmatic
    public boolean isViewModel(Object var1);

    @Programmatic
    public boolean isPersistent(Object var1);

    @Programmatic
    public void persist(Object var1);

    @Programmatic
    public void persistIfNotAlready(Object var1);

    @Programmatic
    public void remove(Object var1);

    @Programmatic
    public void removeIfNotAlready(Object var1);

    @Programmatic
    public void informUser(String var1);

    @Programmatic
    public String informUser(TranslatableString var1, Class<?> var2, String var3);

    @Programmatic
    public void warnUser(String var1);

    @Programmatic
    public String warnUser(TranslatableString var1, Class<?> var2, String var3);

    @Programmatic
    public void raiseError(String var1);

    @Programmatic
    public String raiseError(TranslatableString var1, Class<?> var2, String var3);

    @Programmatic
    public String getProperty(String var1);

    @Programmatic
    public String getProperty(String var1, String var2);

    @Programmatic
    public List<String> getPropertyNames();

    @Programmatic
    public UserMemento getUser();

    @Programmatic
    public <T> List<T> allInstances(Class<T> var1, long ... var2);

    @Programmatic
    public <T> List<T> allMatches(Class<T> var1, Predicate<? super T> var2, long ... var3);

    @Programmatic
    @Deprecated
    public <T> List<T> allMatches(Class<T> var1, Filter<? super T> var2, long ... var3);

    @Programmatic
    public <T> List<T> allMatches(Class<T> var1, String var2, long ... var3);

    @Programmatic
    public <T> List<T> allMatches(Class<T> var1, T var2, long ... var3);

    @Programmatic
    public <T> List<T> allMatches(Query<T> var1);

    @Programmatic
    public <T> T firstMatch(Class<T> var1, Predicate<T> var2);

    @Programmatic
    @Deprecated
    public <T> T firstMatch(Class<T> var1, Filter<T> var2);

    @Programmatic
    public <T> T firstMatch(Class<T> var1, String var2);

    @Programmatic
    public <T> T firstMatch(Class<T> var1, T var2);

    @Programmatic
    public <T> T firstMatch(Query<T> var1);

    @Programmatic
    public <T> T uniqueMatch(Class<T> var1, Predicate<T> var2);

    @Programmatic
    @Deprecated
    public <T> T uniqueMatch(Class<T> var1, Filter<T> var2);

    @Programmatic
    public <T> T uniqueMatch(Class<T> var1, String var2);

    @Programmatic
    public <T> T uniqueMatch(Class<T> var1, T var2);

    @Programmatic
    public <T> T uniqueMatch(Query<T> var1);

    public static class Functions {
        public static <T> Function<T, String> titleOfUsing(final DomainObjectContainer container) {
            return new Function<T, String>(){

                public String apply(T input) {
                    return container.titleOf(input);
                }
            };
        }
    }
}

