/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOffheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridSearchRowPointer;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.offheap.unsafe.GridOffHeapSmartPointerFactory;
import org.apache.ignite.internal.util.offheap.unsafe.GridOffHeapSnapTreeMap;
import org.apache.ignite.internal.util.snaptree.SnapTreeMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2TreeIndex
extends GridH2IndexBase
implements Comparator<GridSearchRowPointer> {
    private final ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> tree;
    private final boolean snapshotEnabled;

    public GridH2TreeIndex(String name, GridH2Table tbl, boolean pk, List<IndexColumn> colsList) {
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.initBaseIndex((Table)tbl, 0, name, cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        final GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc == null || desc.memory() == null) {
            boolean bl = this.snapshotEnabled = desc == null || desc.snapshotableIndex();
            this.tree = this.snapshotEnabled ? new SnapTreeMap<GridSearchRowPointer, GridH2Row>((Comparator)this){

                protected void afterNodeUpdate_nl(SnapTreeMap.Node<GridSearchRowPointer, GridH2Row> node, Object val) {
                    if (val != null) {
                        node.key = (GridSearchRowPointer)val;
                    }
                }

                protected Comparable<? super GridSearchRowPointer> comparable(Object key) {
                    if (key instanceof ComparableRow) {
                        return (Comparable)key;
                    }
                    return super.comparable(key);
                }
            } : new ConcurrentSkipListMap<GridSearchRowPointer, GridH2Row>(new Comparator<GridSearchRowPointer>(){

                @Override
                public int compare(GridSearchRowPointer o1, GridSearchRowPointer o2) {
                    if (o1 instanceof ComparableRow) {
                        return ((ComparableRow)o1).compareTo(o2);
                    }
                    if (o2 instanceof ComparableRow) {
                        return -((ComparableRow)o2).compareTo(o1);
                    }
                    return GridH2TreeIndex.this.compareRows(o1, o2);
                }
            });
        } else {
            assert (desc.snapshotableIndex()) : desc;
            this.snapshotEnabled = true;
            this.tree = new GridOffHeapSnapTreeMap<GridSearchRowPointer, GridH2Row>((GridOffHeapSmartPointerFactory)desc, (GridOffHeapSmartPointerFactory)desc, desc.memory(), desc.guard(), (Comparator)this){

                protected void afterNodeUpdate_nl(long node, GridH2Row val) {
                    final long oldKey = this.keyPtr(node);
                    if (val != null) {
                        this.key(node, val);
                        this.guard.finalizeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((GridH2KeyValueRowOffheap)desc.createPointer(oldKey)).decrementRefCount();
                            }
                        });
                    }
                }

                protected Comparable<? super GridSearchRowPointer> comparable(Object key) {
                    if (key instanceof ComparableRow) {
                        return (Comparable)key;
                    }
                    return super.comparable(key);
                }
            };
        }
        this.initDistributedJoinMessaging(tbl);
    }

    @Override
    protected Object doTakeSnapshot() {
        assert (this.snapshotEnabled);
        return this.tree instanceof SnapTreeMap ? ((SnapTreeMap)this.tree).clone() : ((GridOffHeapSnapTreeMap)this.tree).clone();
    }

    @Override
    protected final ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> treeForRead() {
        if (!this.snapshotEnabled) {
            return this.tree;
        }
        ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> res = (ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row>)this.threadLocalSnapshot();
        if (res == null) {
            res = this.tree;
        }
        return res;
    }

    @Override
    public void destroy() {
        assert (this.threadLocalSnapshot() == null);
        if (this.tree instanceof AutoCloseable) {
            U.closeQuiet((AutoCloseable)((AutoCloseable)((Object)this.tree)));
        }
        super.destroy();
    }

    public long getRowCount(@Nullable Session ses) {
        IndexingQueryFilter f = GridH2TreeIndex.threadLocalFilter();
        if (f == null || f.forSpace(this.getTable().spaceName()) == null) {
            return this.treeForRead().size();
        }
        Iterator<GridH2Row> iter = this.doFind(null, false, null);
        long size = 0L;
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        return size;
    }

    public long getRowCountApproximation() {
        return this.table.getRowCountApproximation();
    }

    @Override
    public int compare(GridSearchRowPointer r1, GridSearchRowPointer r2) {
        return -this.compareRows(r2, r1);
    }

    public String toString() {
        SB sb = new SB((this.indexType.isUnique() ? "Unique index '" : "Index '") + this.getName() + "' [");
        boolean first = true;
        for (IndexColumn col : this.getIndexColumns()) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            sb.a(col.getSQL());
        }
        sb.a(" ]");
        return sb.toString();
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter, sortOrder, false);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public boolean canFindNext() {
        return false;
    }

    public Cursor find(Session ses, @Nullable SearchRow first, @Nullable SearchRow last) {
        return new GridH2Cursor(this.doFind(first, true, last));
    }

    public Cursor findNext(Session ses, SearchRow higherThan, SearchRow last) {
        return new GridH2Cursor(this.doFind(higherThan, false, last));
    }

    public GridH2Row findOne(GridSearchRowPointer row) {
        return (GridH2Row)this.tree.get(row);
    }

    private Iterator<GridH2Row> doFind(@Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last) {
        ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> t = this.treeForRead();
        return this.doFind0(t, first, includeFirst, last, GridH2TreeIndex.threadLocalFilter());
    }

    @Override
    protected final Iterator<GridH2Row> doFind0(ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> t, @Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last, IndexingQueryFilter filter) {
        NavigableMap<GridSearchRowPointer, GridH2Row> range = this.subTree(t, this.comparable(first, (includeFirst &= first != null) ? -1 : 1), this.comparable(last, 1));
        if (range == null) {
            return new GridEmptyIterator();
        }
        return this.filter(range.values().iterator(), filter);
    }

    private GridSearchRowPointer comparable(SearchRow row, int bias) {
        if (row == null) {
            return null;
        }
        if (bias == 0 && row instanceof GridH2Row) {
            return (GridSearchRowPointer)row;
        }
        return new ComparableRow(row, bias);
    }

    private NavigableMap<GridSearchRowPointer, GridH2Row> subTree(NavigableMap<GridSearchRowPointer, GridH2Row> map, @Nullable GridSearchRowPointer first, @Nullable GridSearchRowPointer last) {
        if (first == null) {
            if (last == null) {
                return map;
            }
            return map.headMap(last, false);
        }
        if (last == null) {
            return map.tailMap(first, false);
        }
        if (this.compare(first, last) > 0) {
            return null;
        }
        return map.subMap(first, false, last, false);
    }

    Iterator<GridH2Row> rows() {
        return this.doFind(null, false, null);
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.throwInternalError();
    }

    @Override
    public GridH2Row put(GridH2Row row) {
        return this.tree.put(row, row);
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        return (GridH2Row)this.tree.remove(this.comparable(row, 0));
    }

    @Override
    public GridH2TreeIndex rebuild() throws InterruptedException {
        Object[] cols = this.getIndexColumns();
        GridH2TreeIndex idx = new GridH2TreeIndex(this.getName(), this.getTable(), this.getIndexType().isUnique(), F.asList((Object[])cols));
        Thread thread = Thread.currentThread();
        long i = 0L;
        for (GridH2Row row : this.tree.values()) {
            if (++i % 1000L == 0L && thread.isInterrupted()) {
                throw new InterruptedException();
            }
            idx.tree.put(row, row);
        }
        return idx;
    }

    private final class ComparableRow
    implements GridSearchRowPointer,
    Comparable<SearchRow> {
        private final SearchRow row;
        private final int bias;

        private ComparableRow(SearchRow row, int bias) {
            this.row = row;
            this.bias = bias;
        }

        @Override
        public int compareTo(SearchRow o) {
            int res = GridH2TreeIndex.this.compareRows(o, this.row);
            if (res == 0) {
                return this.bias;
            }
            return -res;
        }

        public boolean equals(Object obj) {
            throw new IllegalStateException("Should never be called.");
        }

        public int getColumnCount() {
            return this.row.getColumnCount();
        }

        public Value getValue(int idx) {
            return this.row.getValue(idx);
        }

        public void setValue(int idx, Value v) {
            this.row.setValue(idx, v);
        }

        public void setKeyAndVersion(SearchRow old) {
            this.row.setKeyAndVersion(old);
        }

        public int getVersion() {
            return this.row.getVersion();
        }

        public void setKey(long key) {
            this.row.setKey(key);
        }

        public long getKey() {
            return this.row.getKey();
        }

        public int getMemory() {
            return this.row.getMemory();
        }

        public long pointer() {
            throw new IllegalStateException();
        }

        public void incrementRefCount() {
            throw new IllegalStateException();
        }

        public void decrementRefCount() {
            throw new IllegalStateException();
        }
    }
}

