/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2AbstractKeyValueRow
extends GridH2Row {
    private static final int DEFAULT_COLUMNS_COUNT = 2;
    public static final int KEY_COL = 0;
    public static final int VAL_COL = 1;
    protected final GridH2RowDescriptor desc;
    protected long expirationTime;
    private Value key;
    private volatile Value val;
    private Value[] valCache;

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc, Object key, int keyType, @Nullable Object val, int valType, long expirationTime) throws IgniteCheckedException {
        this.setValue(0, desc.wrap(key, keyType));
        if (val != null) {
            this.setValue(1, desc.wrap(val, valType));
        }
        this.desc = desc;
        this.expirationTime = expirationTime;
    }

    @Override
    public Value[] getValueList() {
        throw new UnsupportedOperationException();
    }

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc) {
        this.desc = desc;
    }

    public long expirationTime() {
        return this.expirationTime;
    }

    public int getColumnCount() {
        return 2 + this.desc.fieldsCount();
    }

    public synchronized void onSwap() throws IgniteCheckedException {
        this.setValue(1, null);
    }

    public synchronized void onUnswap(Object val, boolean beforeRmv) throws IgniteCheckedException {
        Value val0 = this.peekValue(1);
        if (val0 != null && !(val0 instanceof WeakValue)) {
            return;
        }
        this.setValue(1, this.desc.wrap(val, this.desc.valueType()));
        this.notifyAll();
    }

    protected synchronized Value updateWeakValue(Object valObj) throws IgniteCheckedException {
        Value res = this.peekValue(1);
        if (res != null && !(res instanceof WeakValue)) {
            return res;
        }
        Value upd = this.desc.wrap(valObj, this.desc.valueType());
        this.setValue(1, new WeakValue(upd));
        this.notifyAll();
        return upd;
    }

    protected synchronized Value syncValue(long waitTime) {
        Value v = this.peekValue(1);
        while (v == null && waitTime > 0L) {
            long start = System.nanoTime();
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedException(e);
            }
            long t = System.nanoTime() - start;
            if (t > 0L) {
                waitTime -= TimeUnit.NANOSECONDS.toMillis(t);
            }
            v = this.peekValue(1);
        }
        return v;
    }

    protected final Value peekValue(int col) {
        return col == 0 ? this.key : this.val;
    }

    public Value getValue(int col) {
        ValueNull v;
        Value v2;
        Value[] vCache = this.valCache;
        if (vCache != null && (v2 = vCache[col]) != null) {
            return v2;
        }
        if (col < 2) {
            if (col == 1) {
                v2 = this.peekValue(1);
                long start = 0L;
                int attempt = 0;
                while ((v2 = WeakValue.unwrap(v2)) == null) {
                    if (!this.desc.preferSwapValue() && (v2 = this.getOffheapValue(1)) != null) {
                        this.setValue(1, v2);
                        if (this.peekValue(0) == null) {
                            this.cache();
                        }
                        return v2;
                    }
                    Object k = this.getValue(0).getObject();
                    try {
                        Object valObj = this.desc.readFromSwap(k);
                        if (valObj != null) {
                            v2 = this.getOffheapValue(1);
                            if (v2 == null) {
                                return this.updateWeakValue(valObj);
                            }
                        } else {
                            if (this.desc.preferSwapValue() && (v2 = this.getOffheapValue(1)) != null) {
                                this.setValue(1, v2);
                                if (this.peekValue(0) == null) {
                                    this.cache();
                                }
                                return v2;
                            }
                            v2 = this.syncValue(attempt);
                        }
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                    ++attempt;
                    if (start == 0L) {
                        start = U.currentTimeMillis();
                        continue;
                    }
                    if (U.currentTimeMillis() - start <= 60000L) continue;
                    throw new IgniteException("Failed to get value for key: " + k + ". This can happen due to a long GC pause.");
                }
            } else {
                assert (col == 0) : col;
                v2 = this.peekValue(0);
                if (v2 == null) {
                    v2 = this.getOffheapValue(0);
                    assert (v2 != null);
                    this.setValue(0, v2);
                    if (this.peekValue(1) == null) {
                        this.cache();
                    }
                }
            }
            assert (!(v2 instanceof WeakValue)) : v2;
            return v2;
        }
        assert ((col -= 2) >= 0);
        Value key = this.getValue(0);
        Value val = this.getValue(1);
        assert (key != null);
        assert (val != null);
        Object res = this.desc.columnValue(key.getObject(), val.getObject(), col);
        if (res == null) {
            v = ValueNull.INSTANCE;
        } else {
            try {
                v = this.desc.wrap(res, this.desc.fieldType(col));
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }
        if (vCache != null) {
            vCache[col + 2] = v;
        }
        return v;
    }

    public void valuesCache(Value[] valCache) {
        if (valCache != null) {
            valCache[0] = this.key;
            valCache[1] = this.val;
        }
        this.valCache = valCache;
    }

    protected abstract void cache();

    protected abstract Value getOffheapValue(int var1);

    protected void addOffheapRowId(SB sb) {
    }

    public String toString() {
        SB sb = new SB("Row@");
        sb.a(Integer.toHexString(System.identityHashCode(this)));
        this.addOffheapRowId(sb);
        Value v = this.peekValue(0);
        sb.a("[ key: ").a(v == null ? "nil" : v.getString());
        v = WeakValue.unwrap(this.peekValue(1));
        sb.a(", val: ").a(v == null ? "nil" : v.getString());
        sb.a(" ][ ");
        if (v != null) {
            int cnt = this.getColumnCount();
            for (int i = 2; i < cnt; ++i) {
                v = this.getValue(i);
                if (i != 2) {
                    sb.a(", ");
                }
                sb.a(v == null ? "nil" : v.getString());
            }
        }
        sb.a(" ]");
        return sb.toString();
    }

    @Override
    public void setKeyAndVersion(SearchRow old) {
        throw new IllegalStateException();
    }

    @Override
    public void setKey(long key) {
        throw new IllegalStateException();
    }

    @Override
    public Row getCopy() {
        throw new IllegalStateException();
    }

    @Override
    public void setDeleted(boolean deleted) {
        throw new IllegalStateException();
    }

    @Override
    public long getKey() {
        throw new IllegalStateException();
    }

    @Override
    public void setSessionId(int sesId) {
        throw new IllegalStateException();
    }

    @Override
    public void setVersion(int ver) {
        throw new IllegalStateException();
    }

    public void setValue(int idx, Value v) {
        if (idx == 1) {
            this.val = v;
        } else {
            assert (idx == 0) : idx + " " + v;
            this.key = v;
        }
    }

    public final int hashCode() {
        throw new IllegalStateException();
    }

    private static class WeakValue
    extends Value {
        private final WeakReference<Value> ref;

        static Value unwrap(Value v) {
            return v instanceof WeakValue ? ((WeakValue)v).get() : v;
        }

        private WeakValue(Value v) {
            this.ref = new WeakReference<Value>(v);
        }

        public Value get() {
            return (Value)this.ref.get();
        }

        public String getSQL() {
            throw new IllegalStateException();
        }

        public int getType() {
            throw new IllegalStateException();
        }

        public long getPrecision() {
            throw new IllegalStateException();
        }

        public int getDisplaySize() {
            throw new IllegalStateException();
        }

        public String getString() {
            throw new IllegalStateException();
        }

        public Object getObject() {
            throw new IllegalStateException();
        }

        public void set(PreparedStatement preparedStatement, int i) throws SQLException {
            throw new IllegalStateException();
        }

        protected int compareSecure(Value val, CompareMode compareMode) {
            throw new IllegalStateException();
        }

        public int hashCode() {
            throw new IllegalStateException();
        }

        public boolean equals(Object o) {
            throw new IllegalStateException();
        }
    }
}

