/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheTwoStepQuery {
    public static final int DFLT_PAGE_SIZE = 1000;
    @GridToStringInclude
    private List<GridCacheSqlQuery> mapQrys = new ArrayList<GridCacheSqlQuery>();
    @GridToStringInclude
    private GridCacheSqlQuery rdc;
    private int pageSize = 1000;
    private boolean explain;
    private Collection<String> spaces;
    private Set<String> schemas;
    private Set<String> tbls;
    private boolean distributedJoins;
    private boolean skipMergeTbl;
    private List<Integer> caches;
    private List<Integer> extraCaches;

    public GridCacheTwoStepQuery(Set<String> schemas, Set<String> tbls) {
        this.schemas = schemas;
        this.tbls = tbls;
    }

    public void distributedJoins(boolean distributedJoins) {
        this.distributedJoins = distributedJoins;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public boolean skipMergeTable() {
        return this.skipMergeTbl;
    }

    public void skipMergeTable(boolean skipMergeTbl) {
        this.skipMergeTbl = skipMergeTbl;
    }

    public boolean explain() {
        return this.explain;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public void pageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public GridCacheTwoStepQuery addMapQuery(GridCacheSqlQuery qry) {
        this.mapQrys.add(qry);
        return this;
    }

    public GridCacheSqlQuery reduceQuery() {
        return this.rdc;
    }

    public void reduceQuery(GridCacheSqlQuery rdc) {
        this.rdc = rdc;
    }

    public List<GridCacheSqlQuery> mapQueries() {
        return this.mapQrys;
    }

    public List<Integer> caches() {
        return this.caches;
    }

    public void caches(List<Integer> caches) {
        this.caches = caches;
    }

    public List<Integer> extraCaches() {
        return this.extraCaches;
    }

    public void extraCaches(List<Integer> extraCaches) {
        this.extraCaches = extraCaches;
    }

    public Collection<String> spaces() {
        return this.spaces;
    }

    public void spaces(Collection<String> spaces) {
        this.spaces = spaces;
    }

    public Set<String> schemas() {
        return this.schemas;
    }

    public GridCacheTwoStepQuery copy(Object[] args) {
        assert (!this.explain);
        GridCacheTwoStepQuery cp = new GridCacheTwoStepQuery(this.schemas, this.tbls);
        cp.caches = this.caches;
        cp.extraCaches = this.extraCaches;
        cp.spaces = this.spaces;
        cp.rdc = this.rdc.copy(args);
        cp.skipMergeTbl = this.skipMergeTbl;
        cp.pageSize = this.pageSize;
        cp.distributedJoins = this.distributedJoins;
        for (int i = 0; i < this.mapQrys.size(); ++i) {
            cp.mapQrys.add(this.mapQrys.get(i).copy(args));
        }
        return cp;
    }

    public Set<String> tables() {
        return this.tbls;
    }

    public String toString() {
        return S.toString(GridCacheTwoStepQuery.class, (Object)this);
    }
}

