/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coordination.ZKSplitLogManagerCoordination;
import org.apache.hadoop.hbase.exceptions.OperationConflictException;
import org.apache.hadoop.hbase.exceptions.RegionInRecoveryException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.master.TestSplitLogManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestDistributedLogSplitting {
    private static final Log LOG = LogFactory.getLog(TestSplitLogManager.class);
    static final int NUM_MASTERS = 2;
    static final int NUM_RS = 6;
    MiniHBaseCluster cluster;
    HMaster master;
    Configuration conf;
    static Configuration originalConf;
    static HBaseTestingUtility TEST_UTIL;
    static MiniDFSCluster dfsCluster;
    static MiniZooKeeperCluster zkCluster;

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility(HBaseConfiguration.create());
        dfsCluster = TEST_UTIL.startMiniDFSCluster(1);
        zkCluster = TEST_UTIL.startMiniZKCluster();
        originalConf = TEST_UTIL.getConfiguration();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        TEST_UTIL.shutdownMiniZKCluster();
        TEST_UTIL.shutdownMiniDFSCluster();
        TEST_UTIL.shutdownMiniHBaseCluster();
    }

    private void startCluster(int num_rs) throws Exception {
        SplitLogCounters.resetCounters();
        LOG.info((Object)"Starting cluster");
        this.conf.getLong("hbase.splitlog.max.resubmit", 0L);
        this.conf.setInt("zookeeper.recovery.retry", 0);
        this.conf.setInt("hbase.regionserver.info.port", -1);
        this.conf.setFloat("hbase.regions.slop", 100.0f);
        this.conf.setInt("hbase.regionserver.wal.max.splitters", 3);
        this.conf.setInt("hbase.master.maximum.ping.server.attempts", 3);
        this.conf.setInt("hbase.regionserver.metahandler.count", 40);
        TEST_UTIL.shutdownMiniHBaseCluster();
        TEST_UTIL = new HBaseTestingUtility(this.conf);
        TEST_UTIL.setDFSCluster(dfsCluster);
        TEST_UTIL.setZkCluster(zkCluster);
        TEST_UTIL.startMiniHBaseCluster(2, num_rs);
        this.cluster = TEST_UTIL.getHBaseCluster();
        LOG.info((Object)"Waiting for active/ready master");
        this.cluster.waitForActiveAndReadyMaster();
        this.master = this.cluster.getMaster();
        while (this.cluster.getLiveRegionServerThreads().size() < num_rs) {
            Threads.sleep((long)1L);
        }
    }

    @Before
    public void before() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)originalConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() throws Exception {
        try {
            if (TEST_UTIL.getHBaseCluster() != null) {
                for (JVMClusterUtil.MasterThread mt : TEST_UTIL.getHBaseCluster().getLiveMasterThreads()) {
                    mt.getMaster().abort("closing...", null);
                }
            }
            TEST_UTIL.shutdownMiniHBaseCluster();
        }
        finally {
            TEST_UTIL.getTestFileSystem().delete(FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), true);
            ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)"/hbase");
        }
    }

    @Test(timeout=300000L)
    public void testRecoveredEdits() throws Exception {
        LOG.info((Object)"testRecoveredEdits");
        this.conf.setLong("hbase.regionserver.hlog.blocksize", 30720L);
        this.conf.setBoolean("hbase.master.distributed.log.replay", false);
        this.startCluster(6);
        int NUM_LOG_LINES = 1000;
        SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        this.master.balanceSwitch(false);
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Path rootdir = FSUtils.getRootDir((Configuration)this.conf);
        this.installTable(new ZooKeeperWatcher(this.conf, "table-creation", null), "table", "family", 40);
        TableName table = TableName.valueOf((String)"table");
        List regions = null;
        HRegionServer hrs = null;
        for (int i = 0; i < 6; ++i) {
            boolean foundRs = false;
            hrs = rsts.get(i).getRegionServer();
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (HRegionInfo region : regions) {
                if (!region.getTable().getNameAsString().equalsIgnoreCase("table")) continue;
                foundRs = true;
                break;
            }
            if (foundRs) break;
        }
        Path logDir = new Path(rootdir, DefaultWALProvider.getWALDirectoryName((String)hrs.getServerName().toString()));
        LOG.info((Object)("#regions = " + regions.size()));
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            HRegionInfo region = (HRegionInfo)it.next();
            if (!region.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR)) continue;
            it.remove();
        }
        this.makeWAL(hrs, regions, "table", "family", 1000, 100);
        slm.splitLogDistributed(logDir);
        int count = 0;
        for (HRegionInfo hri : regions) {
            Path tdir = FSUtils.getTableDir((Path)rootdir, (TableName)table);
            Path editsdir = WALSplitter.getRegionDirRecoveredEditsDir((Path)HRegion.getRegionDir((Path)tdir, (String)hri.getEncodedName()));
            LOG.debug((Object)("checking edits dir " + editsdir));
            FileStatus[] files = fs.listStatus(editsdir, new PathFilter(){

                public boolean accept(Path p) {
                    return !WALSplitter.isSequenceIdFile((Path)p);
                }
            });
            Assert.assertTrue((String)("edits dir should have more than a single file in it. instead has " + files.length), (files.length > 1 ? 1 : 0) != 0);
            for (int i = 0; i < files.length; ++i) {
                int c = this.countWAL(files[i].getPath(), fs, this.conf);
                count += c;
            }
            LOG.info((Object)(count + " edits in " + files.length + " recovered edits files."));
        }
        Assert.assertFalse((boolean)fs.exists(logDir));
        Assert.assertEquals((long)1000L, (long)count);
    }

    @Test(timeout=300000L)
    public void testLogReplayWithNonMetaRSDown() throws Exception {
        LOG.info((Object)"testLogReplayWithNonMetaRSDown");
        this.conf.setLong("hbase.regionserver.hlog.blocksize", 30720L);
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 1000;
        this.master.balanceSwitch(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        HRegionServer hrs = this.findRSToKill(false, "table");
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        this.makeWAL(hrs, regions, "table", "family", 1000, 100);
        this.abortRSAndVerifyRecovery(hrs, (Table)ht, zkw, 40, 1000);
        ht.close();
        zkw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testNonceRecovery() throws Exception {
        LOG.info((Object)"testNonceRecovery");
        String TABLE_NAME = "table";
        String FAMILY_NAME = "family";
        int NUM_REGIONS_TO_CREATE = 40;
        this.conf.setLong("hbase.regionserver.hlog.blocksize", 102400L);
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        this.master.balanceSwitch(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        NonceGeneratorWithDups ng = new NonceGeneratorWithDups();
        NonceGenerator oldNg = ConnectionUtils.injectNonceGeneratorForTesting((ClusterConnection)((ClusterConnection)ht.getConnection()), (NonceGenerator)ng);
        try {
            ArrayList<Increment> reqs = new ArrayList<Increment>();
            for (JVMClusterUtil.RegionServerThread rst : this.cluster.getLiveRegionServerThreads()) {
                HRegionServer hrs = rst.getRegionServer();
                List hris = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
                for (HRegionInfo hri : hris) {
                    if (!"table".equalsIgnoreCase(hri.getTable().getNameAsString())) continue;
                    byte[] key = hri.getStartKey();
                    if (key == null || key.length == 0) {
                        key = Bytes.copy((byte[])hri.getEndKey());
                        int n = key.length - 1;
                        key[n] = (byte)(key[n] - 1);
                    }
                    Increment incr = new Increment(key);
                    incr.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"q"), 1L);
                    ht.increment(incr);
                    reqs.add(incr);
                }
            }
            HRegionServer hrs = this.findRSToKill(false, "table");
            this.abortRSAndWaitForRecovery(hrs, zkw, 40);
            ng.startDups();
            for (Increment incr : reqs) {
                try {
                    ht.increment(incr);
                    Assert.fail((String)"should have thrown");
                }
                catch (OperationConflictException ope) {
                    LOG.debug((Object)("Caught as expected: " + ope.getMessage()));
                }
            }
        }
        finally {
            ConnectionUtils.injectNonceGeneratorForTesting((ClusterConnection)((ClusterConnection)ht.getConnection()), (NonceGenerator)oldNg);
            ht.close();
            zkw.close();
        }
    }

    @Test(timeout=300000L)
    public void testLogReplayWithMetaRSDown() throws Exception {
        LOG.info((Object)"testRecoveredEditsReplayWithMetaRSDown");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 1000;
        this.master.balanceSwitch(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        HRegionServer hrs = this.findRSToKill(true, "table");
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        this.makeWAL(hrs, regions, "table", "family", 1000, 100);
        this.abortRSAndVerifyRecovery(hrs, (Table)ht, zkw, 40, 1000);
        ht.close();
        zkw.close();
    }

    private void abortRSAndVerifyRecovery(HRegionServer hrs, Table ht, ZooKeeperWatcher zkw, int numRegions, int numofLines) throws Exception {
        this.abortRSAndWaitForRecovery(hrs, zkw, numRegions);
        Assert.assertEquals((long)numofLines, (long)TEST_UTIL.countRows(ht));
    }

    private void abortRSAndWaitForRecovery(HRegionServer hrs, final ZooKeeperWatcher zkw, final int numRegions) throws Exception {
        final MiniHBaseCluster tmpCluster = this.cluster;
        LOG.info((Object)("Aborting region server: " + hrs.getServerName()));
        hrs.abort("testing");
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return tmpCluster.getLiveRegionServerThreads().size() <= 5;
            }
        });
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return HBaseTestingUtility.getAllOnlineRegions(tmpCluster).size() >= numRegions + 1;
            }
        });
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List recoveringRegions = zkw.getRecoverableZooKeeper().getChildren(zkw.recoveringRegionsZNode, false);
                return recoveringRegions != null && recoveringRegions.size() == 0;
            }
        });
    }

    @Test(timeout=300000L)
    public void testMasterStartsUpWithLogSplittingWork() throws Exception {
        LOG.info((Object)"testMasterStartsUpWithLogSplittingWork");
        this.conf.setBoolean("hbase.master.distributed.log.replay", false);
        this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", 5);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 1000;
        this.master.balanceSwitch(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        HRegionServer hrs = this.findRSToKill(false, "table");
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        this.makeWAL(hrs, regions, "table", "family", 1000, 100);
        this.abortMaster(this.cluster);
        LOG.info((Object)("Aborting region server: " + hrs.getServerName()));
        hrs.abort("testing");
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestDistributedLogSplitting.this.cluster.getLiveRegionServerThreads().size() <= 5;
            }
        });
        Thread.sleep(2000L);
        LOG.info((Object)("Current Open Regions:" + HBaseTestingUtility.getAllOnlineRegions(this.cluster).size()));
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return HBaseTestingUtility.getAllOnlineRegions(TestDistributedLogSplitting.this.cluster).size() >= 41;
            }
        });
        LOG.info((Object)("Current Open Regions After Master Node Starts Up:" + HBaseTestingUtility.getAllOnlineRegions(this.cluster).size()));
        Assert.assertEquals((long)1000L, (long)TEST_UTIL.countRows((Table)ht));
        ht.close();
        zkw.close();
    }

    @Test(timeout=300000L)
    public void testMasterStartsUpWithLogReplayWork() throws Exception {
        LOG.info((Object)"testMasterStartsUpWithLogReplayWork");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", 5);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 1000;
        this.master.balanceSwitch(false);
        final ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        HRegionServer hrs = this.findRSToKill(false, "table");
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        this.makeWAL(hrs, regions, "table", "family", 1000, 100);
        this.abortMaster(this.cluster);
        LOG.info((Object)("Aborting region server: " + hrs.getServerName()));
        hrs.abort("testing");
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestDistributedLogSplitting.this.cluster.getLiveRegionServerThreads().size() <= 5;
            }
        });
        Thread.sleep(2000L);
        LOG.info((Object)("Current Open Regions:" + HBaseTestingUtility.getAllOnlineRegions(this.cluster).size()));
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                boolean done;
                List recoveringRegions = zkw.getRecoverableZooKeeper().getChildren(zkw.recoveringRegionsZNode, false);
                boolean bl = done = recoveringRegions != null && recoveringRegions.size() == 0;
                if (!done) {
                    LOG.info((Object)("Recovering regions: " + recoveringRegions));
                }
                return done;
            }
        });
        LOG.info((Object)("Current Open Regions After Master Node Starts Up:" + HBaseTestingUtility.getAllOnlineRegions(this.cluster).size()));
        Assert.assertEquals((long)1000L, (long)TEST_UTIL.countRows((Table)ht));
        ht.close();
        zkw.close();
    }

    @Test(timeout=300000L)
    public void testLogReplayTwoSequentialRSDown() throws Exception {
        LOG.info((Object)"testRecoveredEditsReplayTwoSequentialRSDown");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 1000;
        this.master.balanceSwitch(false);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        final ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        List regions = null;
        HRegionServer hrs1 = this.findRSToKill(false, "table");
        regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs1.getRSRpcServices());
        this.makeWAL(hrs1, regions, "table", "family", 1000, 100);
        LOG.info((Object)("Aborting region server: " + hrs1.getServerName()));
        hrs1.abort("testing");
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestDistributedLogSplitting.this.cluster.getLiveRegionServerThreads().size() <= 5;
            }
        });
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return HBaseTestingUtility.getAllOnlineRegions(TestDistributedLogSplitting.this.cluster).size() >= 41;
            }
        });
        Thread.sleep(300L);
        rsts = this.cluster.getLiveRegionServerThreads();
        HRegionServer hrs2 = rsts.get(0).getRegionServer();
        LOG.info((Object)("Aborting one more region server: " + hrs2.getServerName()));
        hrs2.abort("testing");
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestDistributedLogSplitting.this.cluster.getLiveRegionServerThreads().size() <= 4;
            }
        });
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return HBaseTestingUtility.getAllOnlineRegions(TestDistributedLogSplitting.this.cluster).size() >= 41;
            }
        });
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List recoveringRegions = zkw.getRecoverableZooKeeper().getChildren(zkw.recoveringRegionsZNode, false);
                return recoveringRegions != null && recoveringRegions.size() == 0;
            }
        });
        Assert.assertEquals((long)1000L, (long)TEST_UTIL.countRows((Table)ht));
        ht.close();
        zkw.close();
    }

    @Test(timeout=300000L)
    public void testMarkRegionsRecoveringInZK() throws Exception {
        LOG.info((Object)"testMarkRegionsRecoveringInZK");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        this.master.balanceSwitch(false);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        ZooKeeperWatcher zkw = this.master.getZooKeeper();
        HTable ht = this.installTable(zkw, "table", "family", 40);
        SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        HashSet<HRegionInfo> regionSet = new HashSet<HRegionInfo>();
        HRegionInfo region = null;
        HRegionServer hrs = null;
        ServerName firstFailedServer = null;
        ServerName secondFailedServer = null;
        for (int i = 0; i < 6; ++i) {
            hrs = rsts.get(i).getRegionServer();
            List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            if (regions.isEmpty()) continue;
            region = (HRegionInfo)regions.get(0);
            regionSet.add(region);
            firstFailedServer = hrs.getServerName();
            secondFailedServer = rsts.get((i + 1) % 6).getRegionServer().getServerName();
            break;
        }
        slm.markRegionsRecovering(firstFailedServer, regionSet);
        slm.markRegionsRecovering(secondFailedServer, regionSet);
        List recoveringRegions = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)ZKUtil.joinZNode((String)zkw.recoveringRegionsZNode, (String)region.getEncodedName()));
        Assert.assertEquals((long)recoveringRegions.size(), (long)2L);
        final HRegionServer tmphrs = hrs;
        TEST_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return tmphrs.getRecoveringRegions().size() == 0;
            }
        });
        ht.close();
    }

    @Test(timeout=300000L)
    public void testReplayCmd() throws Exception {
        LOG.info((Object)"testReplayCmd");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        this.master.balanceSwitch(false);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        List regions = null;
        HRegionServer hrs = null;
        for (int i = 0; i < 6; ++i) {
            boolean isCarryingMeta = false;
            hrs = rsts.get(i).getRegionServer();
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (HRegionInfo region : regions) {
                if (!region.isMetaRegion()) continue;
                isCarryingMeta = true;
                break;
            }
            if (!isCarryingMeta && regions.size() > 0) break;
        }
        this.prepareData((Table)ht, Bytes.toBytes((String)"family"), Bytes.toBytes((String)"c1"));
        String originalCheckSum = TEST_UTIL.checksumRows((Table)ht);
        this.abortRSAndWaitForRecovery(hrs, zkw, 40);
        Assert.assertEquals((String)"Data should remain after reopening of regions", (Object)originalCheckSum, (Object)TEST_UTIL.checksumRows((Table)ht));
        ht.close();
        zkw.close();
    }

    @Test(timeout=300000L)
    public void testLogReplayForDisablingTable() throws Exception {
        Path editsdir;
        LOG.info((Object)"testLogReplayForDisablingTable");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 1000;
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        final ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable disablingHT = this.installTable(zkw, "disableTable", "family", 40);
        HTable ht = this.installTable(zkw, "table", "family", 40, 40);
        this.master.balanceSwitch(false);
        List regions = null;
        HRegionServer hrs = null;
        boolean hasRegionsForBothTables = false;
        String tableName = null;
        for (int i = 0; i < 6; ++i) {
            tableName = null;
            hasRegionsForBothTables = false;
            boolean isCarryingSystem = false;
            hrs = rsts.get(i).getRegionServer();
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (HRegionInfo region : regions) {
                if (region.getTable().isSystemTable()) {
                    isCarryingSystem = true;
                    break;
                }
                if (tableName != null && !tableName.equalsIgnoreCase(region.getTable().getNameAsString())) {
                    hasRegionsForBothTables = true;
                    break;
                }
                if (tableName != null) continue;
                tableName = region.getTable().getNameAsString();
            }
            if (!isCarryingSystem && hasRegionsForBothTables) break;
        }
        Assert.assertTrue((boolean)hasRegionsForBothTables);
        LOG.info((Object)("#regions = " + regions.size()));
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            HRegionInfo region = (HRegionInfo)it.next();
            if (!region.isMetaTable()) continue;
            it.remove();
        }
        this.makeWAL(hrs, regions, "disableTable", "family", 1000, 100, false);
        this.makeWAL(hrs, regions, "table", "family", 1000, 100);
        LOG.info((Object)"Disabling table\n");
        TEST_UTIL.getHBaseAdmin().disableTable(TableName.valueOf((String)"disableTable"));
        LOG.info((Object)("Aborting region server: " + hrs.getServerName()));
        hrs.abort("testing");
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestDistributedLogSplitting.this.cluster.getLiveRegionServerThreads().size() <= 5;
            }
        });
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return HBaseTestingUtility.getAllOnlineRegions(TestDistributedLogSplitting.this.cluster).size() >= 41;
            }
        });
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List recoveringRegions = zkw.getRecoverableZooKeeper().getChildren(zkw.recoveringRegionsZNode, false);
                ServerManager serverManager = TestDistributedLogSplitting.this.master.getServerManager();
                return !serverManager.areDeadServersInProgress() && recoveringRegions != null && recoveringRegions.size() == 0;
            }
        });
        int count = 0;
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path rootdir = FSUtils.getRootDir((Configuration)this.conf);
        Path tdir = FSUtils.getTableDir((Path)rootdir, (TableName)TableName.valueOf((String)"disableTable"));
        for (HRegionInfo hri : regions) {
            FileStatus[] files;
            editsdir = WALSplitter.getRegionDirRecoveredEditsDir((Path)HRegion.getRegionDir((Path)tdir, (String)hri.getEncodedName()));
            LOG.debug((Object)("checking edits dir " + editsdir));
            if (!fs.exists(editsdir) || (files = fs.listStatus(editsdir, new PathFilter(){

                public boolean accept(Path p) {
                    return !WALSplitter.isSequenceIdFile((Path)p);
                }
            })) == null) continue;
            for (FileStatus file : files) {
                int c = this.countWAL(file.getPath(), fs, this.conf);
                count += c;
                LOG.info((Object)(c + " edits in " + file.getPath()));
            }
        }
        LOG.info((Object)"Verify edits in recovered.edits files");
        Assert.assertEquals((long)1000L, (long)count);
        LOG.info((Object)"Verify replayed edits");
        Assert.assertEquals((long)1000L, (long)TEST_UTIL.countRows((Table)ht));
        for (HRegionInfo hri : regions) {
            editsdir = WALSplitter.getRegionDirRecoveredEditsDir((Path)HRegion.getRegionDir((Path)tdir, (String)hri.getEncodedName()));
            fs.delete(editsdir, true);
        }
        disablingHT.close();
        ht.close();
        zkw.close();
    }

    @Test(timeout=300000L)
    public void testDisallowWritesInRecovering() throws Exception {
        LOG.info((Object)"testDisallowWritesInRecovering");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.conf.setInt("hbase.client.retries.number", 3);
        this.conf.setBoolean("hbase.regionserver.disallow.writes.when.recovering", true);
        this.startCluster(6);
        int NUM_REGIONS_TO_CREATE = 40;
        this.master.balanceSwitch(false);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        HashSet<HRegionInfo> regionSet = new HashSet<HRegionInfo>();
        HRegionInfo region = null;
        HRegionServer hrs = null;
        HRegionServer dstRS = null;
        for (int i = 0; i < 6; ++i) {
            hrs = rsts.get(i).getRegionServer();
            List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            if (regions.isEmpty() || (region = (HRegionInfo)regions.get(0)).isMetaRegion()) continue;
            regionSet.add(region);
            dstRS = rsts.get((i + 1) % 6).getRegionServer();
            break;
        }
        slm.markRegionsRecovering(hrs.getServerName(), regionSet);
        final HRegionInfo hri = region;
        final HRegionServer tmpRS = dstRS;
        TEST_UTIL.getHBaseAdmin().move(region.getEncodedNameAsBytes(), Bytes.toBytes((String)dstRS.getServerName().getServerName()));
        final RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
        TEST_UTIL.waitFor(45000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ServerName sn = regionStates.getRegionServerOfRegion(hri);
                return sn != null && sn.equals((Object)tmpRS.getServerName());
            }
        });
        try {
            byte[] key = region.getStartKey();
            if (key == null || key.length == 0) {
                key = new byte[]{0, 0, 0, 0, 1};
            }
            Put put = new Put(key);
            put.add(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"c1"), new byte[]{98});
            ht.put(put);
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof RetriesExhaustedWithDetailsException));
            RetriesExhaustedWithDetailsException re = (RetriesExhaustedWithDetailsException)((Object)ioe);
            boolean foundRegionInRecoveryException = false;
            for (Throwable t : re.getCauses()) {
                if (!(t instanceof RegionInRecoveryException)) continue;
                foundRegionInRecoveryException = true;
                break;
            }
            Assert.assertTrue((String)("No RegionInRecoveryException. Following exceptions returned=" + re.getCauses()), (boolean)foundRegionInRecoveryException);
        }
        ht.close();
        zkw.close();
    }

    @Test(timeout=300000L)
    public void testWorkerAbort() throws Exception {
        LOG.info((Object)"testWorkerAbort");
        this.startCluster(3);
        int NUM_LOG_LINES = 10000;
        SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        final List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        HRegionServer hrs = this.findRSToKill(false, "table");
        Path rootdir = FSUtils.getRootDir((Configuration)this.conf);
        Path logDir = new Path(rootdir, DefaultWALProvider.getWALDirectoryName((String)hrs.getServerName().toString()));
        this.installTable(new ZooKeeperWatcher(this.conf, "table-creation", null), "table", "family", 40);
        this.makeWAL(hrs, ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices()), "table", "family", 10000, 100);
        new Thread(){

            @Override
            public void run() {
                block0: {
                    TestDistributedLogSplitting.this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 1L, 1000L);
                    Iterator i$ = rsts.iterator();
                    if (!i$.hasNext()) break block0;
                    JVMClusterUtil.RegionServerThread rst = (JVMClusterUtil.RegionServerThread)i$.next();
                    rst.getRegionServer().abort("testing");
                }
            }
        }.start();
        FileStatus[] logfiles = fs.listStatus(logDir);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        slm.enqueueSplitTask(logfiles[0].getPath().toString(), batch);
        long curt = System.currentTimeMillis();
        long waitTime = 80000L;
        long endt = curt + waitTime;
        while (curt < endt) {
            if (SplitLogCounters.tot_wkr_task_resigned.get() + SplitLogCounters.tot_wkr_task_err.get() + SplitLogCounters.tot_wkr_final_transition_failed.get() + SplitLogCounters.tot_wkr_task_done.get() + SplitLogCounters.tot_wkr_preempt_task.get() == 0L) {
                Thread.yield();
                curt = System.currentTimeMillis();
                continue;
            }
            Assert.assertTrue((1L <= SplitLogCounters.tot_wkr_task_resigned.get() + SplitLogCounters.tot_wkr_task_err.get() + SplitLogCounters.tot_wkr_final_transition_failed.get() + SplitLogCounters.tot_wkr_task_done.get() + SplitLogCounters.tot_wkr_preempt_task.get() ? 1 : 0) != 0);
            return;
        }
        Assert.fail((String)("none of the following counters went up in " + waitTime + " milliseconds - " + "tot_wkr_task_resigned, tot_wkr_task_err, " + "tot_wkr_final_transition_failed, tot_wkr_task_done, " + "tot_wkr_preempt_task"));
    }

    @Test(timeout=300000L)
    public void testThreeRSAbort() throws Exception {
        LOG.info((Object)"testThreeRSAbort");
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_ROWS_PER_REGION = 100;
        this.startCluster(6);
        final ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "distributed log splitting test", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        this.populateDataInTable(100, "family");
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)6L, (long)rsts.size());
        rsts.get(0).getRegionServer().abort("testing");
        rsts.get(1).getRegionServer().abort("testing");
        rsts.get(2).getRegionServer().abort("testing");
        long start = EnvironmentEdgeManager.currentTime();
        while (this.cluster.getLiveRegionServerThreads().size() > 3) {
            if (EnvironmentEdgeManager.currentTime() - start > 60000L) {
                Assert.assertTrue((boolean)false);
            }
            Thread.sleep(200L);
        }
        start = EnvironmentEdgeManager.currentTime();
        while (HBaseTestingUtility.getAllOnlineRegions(this.cluster).size() < 41) {
            if (EnvironmentEdgeManager.currentTime() - start > 60000L) {
                Assert.assertTrue((String)"Timedout", (boolean)false);
            }
            Thread.sleep(200L);
        }
        TEST_UTIL.waitFor(180000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List recoveringRegions = zkw.getRecoverableZooKeeper().getChildren(zkw.recoveringRegionsZNode, false);
                return recoveringRegions != null && recoveringRegions.size() == 0;
            }
        });
        Assert.assertEquals((long)4000L, (long)TEST_UTIL.countRows((Table)ht));
        ht.close();
        zkw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDelayedDeleteOnFailure() throws Exception {
        LOG.info((Object)"testDelayedDeleteOnFailure");
        this.startCluster(1);
        final SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        final FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        final Path logDir = new Path(FSUtils.getRootDir((Configuration)this.conf), "x");
        fs.mkdirs(logDir);
        ExecutorService executor = null;
        try {
            final Path corruptedLogFile = new Path(logDir, "x");
            FSDataOutputStream out = fs.create(corruptedLogFile);
            out.write(0);
            out.write(Bytes.toBytes((String)"corrupted bytes"));
            out.close();
            ZKSplitLogManagerCoordination coordination = (ZKSplitLogManagerCoordination)this.master.getCoordinatedStateManager().getSplitLogManagerCoordination();
            coordination.setIgnoreDeleteForTesting(true);
            executor = Executors.newSingleThreadExecutor();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        slm.splitLogDistributed(logDir);
                    }
                    catch (IOException ioe) {
                        try {
                            Assert.assertTrue((boolean)fs.exists(corruptedLogFile));
                            slm.splitLogDistributed(logDir);
                        }
                        catch (IOException e) {
                            Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                            return;
                        }
                        Assert.fail((String)"did not get the expected IOException from the 2nd call");
                    }
                    Assert.fail((String)"did not get the expected IOException from the 1st call");
                }
            };
            Future<?> result = executor.submit(runnable);
            try {
                result.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                // empty catch block
            }
            this.waitForCounter(SplitLogCounters.tot_mgr_wait_for_zk_delete, 0L, 1L, 10000L);
            executor.shutdownNow();
            executor = null;
            result.get();
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            fs.delete(logDir, true);
        }
    }

    @Test(timeout=300000L)
    public void testMetaRecoveryInZK() throws Exception {
        LOG.info((Object)"testMetaRecoveryInZK");
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        this.master.balanceSwitch(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HRegionServer hrs = this.findRSToKill(true, null);
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        LOG.info((Object)("#regions = " + regions.size()));
        HashSet<HRegionInfo> tmpRegions = new HashSet<HRegionInfo>();
        tmpRegions.add(HRegionInfo.FIRST_META_REGIONINFO);
        this.master.getMasterFileSystem().prepareLogReplay(hrs.getServerName(), tmpRegions);
        HashSet userRegionSet = new HashSet();
        userRegionSet.addAll(regions);
        this.master.getMasterFileSystem().prepareLogReplay(hrs.getServerName(), userRegionSet);
        boolean isMetaRegionInRecovery = false;
        List recoveringRegions = zkw.getRecoverableZooKeeper().getChildren(zkw.recoveringRegionsZNode, false);
        for (String curEncodedRegionName : recoveringRegions) {
            if (!curEncodedRegionName.equals(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName())) continue;
            isMetaRegionInRecovery = true;
            break;
        }
        Assert.assertTrue((boolean)isMetaRegionInRecovery);
        this.master.getMasterFileSystem().splitMetaLog(hrs.getServerName());
        isMetaRegionInRecovery = false;
        recoveringRegions = zkw.getRecoverableZooKeeper().getChildren(zkw.recoveringRegionsZNode, false);
        for (String curEncodedRegionName : recoveringRegions) {
            if (!curEncodedRegionName.equals(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName())) continue;
            isMetaRegionInRecovery = true;
            break;
        }
        Assert.assertFalse((boolean)isMetaRegionInRecovery);
        zkw.close();
    }

    @Test(timeout=300000L)
    public void testSameVersionUpdatesRecovery() throws Exception {
        LOG.info((Object)"testSameVersionUpdatesRecovery");
        this.conf.setLong("hbase.regionserver.hlog.blocksize", 15360L);
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.startCluster(6);
        AtomicLong sequenceId = new AtomicLong(100L);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 1000;
        this.master.balanceSwitch(false);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        List regions = null;
        HRegionServer hrs = null;
        for (int i = 0; i < 6; ++i) {
            boolean isCarryingMeta = false;
            hrs = rsts.get(i).getRegionServer();
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (HRegionInfo region : regions) {
                if (!region.isMetaRegion()) continue;
                isCarryingMeta = true;
                break;
            }
            if (!isCarryingMeta) break;
        }
        LOG.info((Object)("#regions = " + regions.size()));
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            HRegionInfo region = (HRegionInfo)it.next();
            if (!region.isMetaTable() && !region.getEncodedName().equals(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName())) continue;
            it.remove();
        }
        if (regions.size() == 0) {
            return;
        }
        HRegionInfo curRegionInfo = (HRegionInfo)regions.get(0);
        byte[] startRow = curRegionInfo.getStartKey();
        if (startRow == null || startRow.length == 0) {
            startRow = new byte[]{0, 0, 0, 0, 1};
        }
        byte[] row = Bytes.incrementBytes((byte[])startRow, (long)1L);
        row = Arrays.copyOfRange(row, 3, 8);
        long value = 0L;
        TableName tableName = TableName.valueOf((String)"table");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qualifier = Bytes.toBytes((String)"c1");
        long timeStamp = System.currentTimeMillis();
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor(family));
        WAL wal = hrs.getWAL(curRegionInfo);
        for (int i = 0; i < 1000; ++i) {
            WALEdit e = new WALEdit();
            e.add((Cell)new KeyValue(row, family, qualifier, timeStamp, Bytes.toBytes((long)(++value))));
            wal.append(htd, curRegionInfo, (WALKey)new HLogKey(curRegionInfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), e, sequenceId, true, null);
        }
        wal.sync();
        wal.shutdown();
        this.abortRSAndWaitForRecovery(hrs, zkw, 40);
        LOG.info((Object)"Verification Starts...");
        Get g = new Get(row);
        Result r = ht.get(g);
        long theStoredVal = Bytes.toLong((byte[])r.getValue(family, qualifier));
        Assert.assertEquals((long)value, (long)theStoredVal);
        LOG.info((Object)"Verification after flush...");
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        r = ht.get(g);
        theStoredVal = Bytes.toLong((byte[])r.getValue(family, qualifier));
        Assert.assertEquals((long)value, (long)theStoredVal);
        ht.close();
    }

    @Test(timeout=300000L)
    public void testSameVersionUpdatesRecoveryWithCompaction() throws Exception {
        LOG.info((Object)"testSameVersionUpdatesRecoveryWithWrites");
        this.conf.setLong("hbase.regionserver.hlog.blocksize", 15360L);
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.conf.setInt("hbase.hregion.memstore.flush.size", 30720);
        this.conf.setInt("hbase.hstore.compactionThreshold", 3);
        this.startCluster(6);
        AtomicLong sequenceId = new AtomicLong(100L);
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_LOG_LINES = 2000;
        this.master.balanceSwitch(false);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        List regions = null;
        HRegionServer hrs = null;
        for (int i = 0; i < 6; ++i) {
            boolean isCarryingMeta = false;
            hrs = rsts.get(i).getRegionServer();
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (HRegionInfo region : regions) {
                if (!region.isMetaRegion()) continue;
                isCarryingMeta = true;
                break;
            }
            if (!isCarryingMeta) break;
        }
        LOG.info((Object)("#regions = " + regions.size()));
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            HRegionInfo region = (HRegionInfo)it.next();
            if (!region.isMetaTable() && !region.getEncodedName().equals(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName())) continue;
            it.remove();
        }
        if (regions.size() == 0) {
            return;
        }
        HRegionInfo curRegionInfo = (HRegionInfo)regions.get(0);
        byte[] startRow = curRegionInfo.getStartKey();
        if (startRow == null || startRow.length == 0) {
            startRow = new byte[]{0, 0, 0, 0, 1};
        }
        byte[] row = Bytes.incrementBytes((byte[])startRow, (long)1L);
        row = Arrays.copyOfRange(row, 3, 8);
        long value = 0L;
        final TableName tableName = TableName.valueOf((String)"table");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qualifier = Bytes.toBytes((String)"c1");
        long timeStamp = System.currentTimeMillis();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family));
        WAL wal = hrs.getWAL(curRegionInfo);
        for (int i = 0; i < 2000; ++i) {
            WALEdit e = new WALEdit();
            e.add((Cell)new KeyValue(row, family, qualifier, timeStamp, Bytes.toBytes((long)(++value))));
            wal.append(htd, curRegionInfo, (WALKey)new HLogKey(curRegionInfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), e, sequenceId, true, null);
        }
        wal.sync();
        wal.shutdown();
        this.abortRSAndWaitForRecovery(hrs, zkw, 40);
        LOG.info((Object)"Verification Starts...");
        Get g = new Get(row);
        Result r = ht.get(g);
        long theStoredVal = Bytes.toLong((byte[])r.getValue(family, qualifier));
        Assert.assertEquals((long)value, (long)theStoredVal);
        LOG.info((Object)"Verification after flush...");
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        TEST_UTIL.getHBaseAdmin().compact(tableName);
        TEST_UTIL.waitFor(30000L, 200L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TEST_UTIL.getHBaseAdmin().getCompactionState(tableName) == AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
            }
        });
        r = ht.get(g);
        theStoredVal = Bytes.toLong((byte[])r.getValue(family, qualifier));
        Assert.assertEquals((long)value, (long)theStoredVal);
        ht.close();
    }

    @Test(timeout=300000L)
    public void testReadWriteSeqIdFiles() throws Exception {
        LOG.info((Object)"testReadWriteSeqIdFiles");
        this.startCluster(2);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "table-creation", null);
        HTable ht = this.installTable(zkw, "table", "family", 10);
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)this.conf), (TableName)TableName.valueOf((String)"table"));
        List regionDirs = FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir);
        long newSeqId = WALSplitter.writeRegionSequenceIdFile((FileSystem)fs, (Path)((Path)regionDirs.get(0)), (long)1L, (long)1000L);
        WALSplitter.writeRegionSequenceIdFile((FileSystem)fs, (Path)((Path)regionDirs.get(0)), (long)1L, (long)1000L);
        Assert.assertEquals((long)(newSeqId + 2000L), (long)WALSplitter.writeRegionSequenceIdFile((FileSystem)fs, (Path)((Path)regionDirs.get(0)), (long)3L, (long)1000L));
        Path editsdir = WALSplitter.getRegionDirRecoveredEditsDir((Path)((Path)regionDirs.get(0)));
        FileStatus[] files = FSUtils.listStatus((FileSystem)fs, (Path)editsdir, (PathFilter)new PathFilter(){

            public boolean accept(Path p) {
                return WALSplitter.isSequenceIdFile((Path)p);
            }
        });
        Assert.assertEquals((long)1L, (long)files.length);
        NavigableSet recoveredEdits = WALSplitter.getSplitEditFilesSorted((FileSystem)fs, (Path)((Path)regionDirs.get(0)));
        Assert.assertEquals((long)0L, (long)recoveredEdits.size());
        ht.close();
    }

    HTable installTable(ZooKeeperWatcher zkw, String tname, String fname, int nrs) throws Exception {
        return this.installTable(zkw, tname, fname, nrs, 0);
    }

    HTable installTable(ZooKeeperWatcher zkw, String tname, String fname, int nrs, int existingRegions) throws Exception {
        TableName table = TableName.valueOf((String)tname);
        byte[] family = Bytes.toBytes((String)fname);
        LOG.info((Object)("Creating table with " + nrs + " regions"));
        HTable ht = TEST_UTIL.createMultiRegionTable(table, family, nrs);
        int numRegions = -1;
        try (RegionLocator r = ht.getRegionLocator();){
            numRegions = r.getStartKeys().length;
        }
        Assert.assertEquals((long)nrs, (long)numRegions);
        LOG.info((Object)"Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, this.master);
        LOG.debug((Object)"Disabling table\n");
        TEST_UTIL.getHBaseAdmin().disableTable(table);
        LOG.debug((Object)"Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, this.master);
        NavigableSet<String> regions = HBaseTestingUtility.getAllOnlineRegions(this.cluster);
        LOG.debug((Object)"Verifying only catalog and namespace regions are assigned\n");
        if (regions.size() != 2) {
            for (String oregion : regions) {
                LOG.debug((Object)("Region still online: " + oregion));
            }
        }
        Assert.assertEquals((long)(2 + existingRegions), (long)regions.size());
        LOG.debug((Object)"Enabling table\n");
        TEST_UTIL.getHBaseAdmin().enableTable(table);
        LOG.debug((Object)"Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, this.master);
        LOG.debug((Object)("Verifying there are " + numRegions + " assigned on cluster\n"));
        regions = HBaseTestingUtility.getAllOnlineRegions(this.cluster);
        Assert.assertEquals((long)(numRegions + 2 + existingRegions), (long)regions.size());
        return ht;
    }

    void populateDataInTable(int nrows, String fname) throws Exception {
        byte[] family = Bytes.toBytes((String)fname);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)6L, (long)rsts.size());
        for (JVMClusterUtil.RegionServerThread rst : rsts) {
            HRegionServer hrs = rst.getRegionServer();
            List hris = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (HRegionInfo hri : hris) {
                if (hri.getTable().isSystemTable()) continue;
                LOG.debug((Object)("adding data to rs = " + rst.getName() + " region = " + hri.getRegionNameAsString()));
                Region region = hrs.getOnlineRegion(hri.getRegionName());
                Assert.assertTrue((region != null ? 1 : 0) != 0);
                this.putData(region, hri.getStartKey(), nrows, Bytes.toBytes((String)"q"), new byte[][]{family});
            }
        }
    }

    public void makeWAL(HRegionServer hrs, List<HRegionInfo> regions, String tname, String fname, int num_edits, int edit_size) throws IOException {
        this.makeWAL(hrs, regions, tname, fname, num_edits, edit_size, true);
    }

    public void makeWAL(HRegionServer hrs, List<HRegionInfo> regions, String tname, String fname, int num_edits, int edit_size, boolean cleanShutdown) throws IOException {
        WAL log;
        TableName fullTName = TableName.valueOf((String)tname);
        regions.remove(HRegionInfo.FIRST_META_REGIONINFO);
        AtomicLong sequenceId = new AtomicLong(10L);
        Iterator<HRegionInfo> iter = regions.iterator();
        while (iter.hasNext()) {
            HRegionInfo regionInfo = iter.next();
            if (!regionInfo.getTable().isSystemTable()) continue;
            iter.remove();
        }
        HTableDescriptor htd = new HTableDescriptor(fullTName);
        byte[] family = Bytes.toBytes((String)fname);
        htd.addFamily(new HColumnDescriptor(family));
        byte[] value = new byte[edit_size];
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        for (HRegionInfo region : regions) {
            if (!region.getTable().getNameAsString().equalsIgnoreCase(tname)) continue;
            hris.add(region);
        }
        LOG.info((Object)("Creating wal edits across " + hris.size() + " regions."));
        for (int i = 0; i < edit_size; ++i) {
            value[i] = (byte)(97 + i % 26);
        }
        int n = hris.size();
        int[] counts = new int[n];
        int syncEvery = 30720 / edit_size;
        if (n > 0) {
            for (int i = 0; i < num_edits; ++i) {
                WALEdit e = new WALEdit();
                HRegionInfo curRegionInfo = (HRegionInfo)hris.get(i % n);
                WAL log2 = hrs.getWAL(curRegionInfo);
                byte[] startRow = curRegionInfo.getStartKey();
                if (startRow == null || startRow.length == 0) {
                    startRow = new byte[]{0, 0, 0, 0, 1};
                }
                byte[] row = Bytes.incrementBytes((byte[])startRow, (long)counts[i % n]);
                row = Arrays.copyOfRange(row, 3, 8);
                byte[] qualifier = Bytes.toBytes((String)("c" + Integer.toString(i)));
                e.add((Cell)new KeyValue(row, family, qualifier, System.currentTimeMillis(), value));
                log2.append(htd, curRegionInfo, (WALKey)new HLogKey(curRegionInfo.getEncodedNameAsBytes(), fullTName, System.currentTimeMillis()), e, sequenceId, true, null);
                if (0 == i % syncEvery) {
                    log2.sync();
                }
                int n2 = i % n;
                counts[n2] = counts[n2] + 1;
            }
        }
        for (HRegionInfo info : hris) {
            log = hrs.getWAL(info);
            log.sync();
        }
        if (cleanShutdown) {
            for (HRegionInfo info : hris) {
                log = hrs.getWAL(info);
                log.shutdown();
            }
        }
        for (int i = 0; i < n; ++i) {
            LOG.info((Object)("region " + ((HRegionInfo)hris.get(i)).getRegionNameAsString() + " has " + counts[i] + " edits"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countWAL(Path log, FileSystem fs, Configuration conf) throws IOException {
        int count = 0;
        WAL.Reader in = WALFactory.createReader((FileSystem)fs, (Path)log, (Configuration)conf);
        try {
            WAL.Entry e;
            while ((e = in.next()) != null) {
                if (WALEdit.isMetaEditFamily((Cell)((Cell)e.getEdit().getCells().get(0)))) continue;
                ++count;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException exception) {
                LOG.warn((Object)("Problem closing wal: " + exception.getMessage()));
                LOG.debug((Object)"exception details.", (Throwable)exception);
            }
        }
        return count;
    }

    private void blockUntilNoRIT(ZooKeeperWatcher zkw, HMaster master) throws KeeperException, InterruptedException {
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
    }

    private void putData(Region region, byte[] startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            Put put = new Put(Bytes.add((byte[])startRow, (byte[])Bytes.toBytes((int)i)));
            for (byte[] family : families) {
                put.add(family, qf, null);
            }
            region.put(put);
        }
    }

    private void prepareData(Table t, byte[] f, byte[] column) throws IOException {
        byte[] k = new byte[3];
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.add(f, column, k);
                    puts.add(put);
                }
            }
        }
        t.put(puts);
        for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
            k[0] = 97;
            k[1] = 97;
            k[2] = b3;
            Delete del = new Delete(k);
            t.delete(del);
        }
    }

    private void waitForCounter(AtomicLong ctr, long oldval, long newval, long timems) {
        long curt = System.currentTimeMillis();
        long endt = curt + timems;
        while (curt < endt) {
            if (ctr.get() == oldval) {
                Thread.yield();
                curt = System.currentTimeMillis();
                continue;
            }
            Assert.assertEquals((long)newval, (long)ctr.get());
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    private void abortMaster(MiniHBaseCluster cluster) throws InterruptedException {
        for (JVMClusterUtil.MasterThread mt : cluster.getLiveMasterThreads()) {
            if (!mt.getMaster().isActiveMaster()) continue;
            mt.getMaster().abort("Aborting for tests", (Throwable)new Exception("Trace info"));
            mt.join();
            break;
        }
        LOG.debug((Object)"Master is aborted");
    }

    private HRegionServer findRSToKill(boolean hasMetaRegion, String tableName) throws Exception {
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        int numOfRSs = rsts.size();
        List regions = null;
        HRegionServer hrs = null;
        for (int i = 0; i < numOfRSs; ++i) {
            boolean isCarryingMeta = false;
            boolean foundTableRegion = false;
            hrs = rsts.get(i).getRegionServer();
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (HRegionInfo region : regions) {
                if (region.isMetaRegion()) {
                    isCarryingMeta = true;
                }
                if (tableName == null || region.getTable().getNameAsString().equals(tableName)) {
                    foundTableRegion = true;
                }
                if (!foundTableRegion || !isCarryingMeta && hasMetaRegion) continue;
                break;
            }
            if (isCarryingMeta && hasMetaRegion) {
                if (!foundTableRegion) {
                    final HRegionServer destRS = hrs;
                    List tableRegions = TEST_UTIL.getHBaseAdmin().getTableRegions(TableName.valueOf((String)tableName));
                    final HRegionInfo hri = (HRegionInfo)tableRegions.get(0);
                    TEST_UTIL.getHBaseAdmin().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)destRS.getServerName().getServerName()));
                    final RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                    TEST_UTIL.waitFor(45000L, 200L, new Waiter.Predicate<Exception>(){

                        public boolean evaluate() throws Exception {
                            ServerName sn = regionStates.getRegionServerOfRegion(hri);
                            return sn != null && sn.equals((Object)destRS.getServerName());
                        }
                    });
                }
                return hrs;
            }
            if (!hasMetaRegion && !isCarryingMeta && foundTableRegion) break;
        }
        return hrs;
    }

    static {
        System.setProperty("hbase.tests.use.shortcircuit.reads", "false");
    }

    private static class NonceGeneratorWithDups
    extends PerClientRandomNonceGenerator {
        private boolean isDups = false;
        private LinkedList<Long> nonces = new LinkedList();

        private NonceGeneratorWithDups() {
        }

        public void startDups() {
            this.isDups = true;
        }

        public long newNonce() {
            long nonce;
            long l = nonce = this.isDups ? this.nonces.removeFirst().longValue() : super.newNonce();
            if (!this.isDups) {
                this.nonces.add(nonce);
            }
            return nonce;
        }
    }
}

