/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoordinatedStateManagerFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.RegionException;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.Mocking;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestAssignmentManager {
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final ServerName SERVERNAME_A = ServerName.valueOf((String)"example.org", (int)1234, (long)5678L);
    private static final ServerName SERVERNAME_B = ServerName.valueOf((String)"example.org", (int)0, (long)5678L);
    private static final HRegionInfo REGIONINFO = new HRegionInfo(TableName.valueOf((String)"t"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
    private static int assignmentCount;
    private static boolean enabling;
    private Server server;
    private ServerManager serverManager;
    private ZooKeeperWatcher watcher;
    private CoordinatedStateManager cp;
    private MetaTableLocator mtl;
    private LoadBalancer balancer;
    private HMaster master;
    private ClusterConnection connection;

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        HTU.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        HTU.shutdownMiniZKCluster();
    }

    @Before
    public void before() throws ZooKeeperConnectionException, IOException {
        this.server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)this.server.getServerName()).thenReturn((Object)ServerName.valueOf((String)"master,1,1"));
        Mockito.when((Object)this.server.getConfiguration()).thenReturn((Object)HTU.getConfiguration());
        this.watcher = new ZooKeeperWatcher(HTU.getConfiguration(), "mockedServer", (Abortable)this.server, true);
        Mockito.when((Object)this.server.getZooKeeper()).thenReturn((Object)this.watcher);
        ((Server)Mockito.doThrow((Throwable)new RuntimeException("Aborted")).when((Object)this.server)).abort(Mockito.anyString(), (Throwable)Mockito.anyObject());
        this.cp = new ZkCoordinatedStateManager();
        this.cp.initialize(this.server);
        this.cp.start();
        this.mtl = (MetaTableLocator)Mockito.mock(MetaTableLocator.class);
        Mockito.when((Object)this.server.getCoordinatedStateManager()).thenReturn((Object)this.cp);
        Mockito.when((Object)this.server.getMetaTableLocator()).thenReturn((Object)this.mtl);
        this.connection = HConnectionTestingUtility.getMockedConnection(HTU.getConfiguration());
        Mockito.when((Object)this.server.getConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.isManaged()).thenReturn((Object)true);
        this.serverManager = (ServerManager)Mockito.mock(ServerManager.class);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_A)).thenReturn((Object)true);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_B)).thenReturn((Object)true);
        Mockito.when((Object)this.serverManager.getDeadServers()).thenReturn((Object)new DeadServer());
        HashMap<ServerName, ServerLoad> onlineServers = new HashMap<ServerName, ServerLoad>();
        onlineServers.put(SERVERNAME_B, ServerLoad.EMPTY_SERVERLOAD);
        onlineServers.put(SERVERNAME_A, ServerLoad.EMPTY_SERVERLOAD);
        Mockito.when((Object)this.serverManager.getOnlineServersList()).thenReturn(new ArrayList(onlineServers.keySet()));
        Mockito.when((Object)this.serverManager.getOnlineServers()).thenReturn(onlineServers);
        ArrayList avServers = new ArrayList();
        avServers.addAll(onlineServers.keySet());
        Mockito.when((Object)this.serverManager.createDestinationServersList()).thenReturn(avServers);
        Mockito.when((Object)this.serverManager.createDestinationServersList(null)).thenReturn(avServers);
        Mockito.when((Object)this.serverManager.sendRegionClose(SERVERNAME_A, REGIONINFO, -1)).thenReturn((Object)true);
        Mockito.when((Object)this.serverManager.sendRegionClose(SERVERNAME_B, REGIONINFO, -1)).thenReturn((Object)true);
        Mockito.when((Object)this.serverManager.sendRegionOpen(SERVERNAME_A, REGIONINFO, -1, null)).thenReturn((Object)RegionOpeningState.OPENED);
        Mockito.when((Object)this.serverManager.sendRegionOpen(SERVERNAME_B, REGIONINFO, -1, null)).thenReturn((Object)RegionOpeningState.OPENED);
        this.master = (HMaster)Mockito.mock(HMaster.class);
        Mockito.when((Object)this.master.getServerManager()).thenReturn((Object)this.serverManager);
    }

    @After
    public void after() throws KeeperException, IOException {
        if (this.watcher != null) {
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
            this.watcher.close();
            this.cp.stop();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalanceOnMasterFailoverScenarioWithOpenedNode() throws IOException, KeeperException, InterruptedException, ServiceException, DeserializationException, CoordinatedStateException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            this.createRegionPlanAndBalance(am, SERVERNAME_A, SERVERNAME_B, REGIONINFO);
            this.startFakeFailedOverMasterAssignmentManager(am, this.watcher);
            while (!am.processRITInvoked) {
                Thread.sleep(1L);
            }
            am.addPlan(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_B));
            Mocking.waitForRegionFailedToCloseAndSetToPendingClose(am, REGIONINFO);
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            Mocking.waitForRegionPendingOpenInRIT(am, REGIONINFO.getEncodedName());
            versionid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            am.gate.set(false);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.watcher);
        }
        finally {
            am.getExecutorService().shutdown();
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalanceOnMasterFailoverScenarioWithClosedNode() throws IOException, KeeperException, InterruptedException, ServiceException, DeserializationException, CoordinatedStateException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            this.createRegionPlanAndBalance(am, SERVERNAME_A, SERVERNAME_B, REGIONINFO);
            this.startFakeFailedOverMasterAssignmentManager(am, this.watcher);
            while (!am.processRITInvoked) {
                Thread.sleep(1L);
            }
            am.addPlan(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_B));
            Mocking.waitForRegionFailedToCloseAndSetToPendingClose(am, REGIONINFO);
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            am.gate.set(false);
            Mocking.waitForRegionPendingOpenInRIT(am, REGIONINFO.getEncodedName());
            versionid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.watcher);
        }
        finally {
            am.getExecutorService().shutdown();
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalanceOnMasterFailoverScenarioWithOfflineNode() throws IOException, KeeperException, InterruptedException, ServiceException, DeserializationException, CoordinatedStateException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            this.createRegionPlanAndBalance(am, SERVERNAME_A, SERVERNAME_B, REGIONINFO);
            this.startFakeFailedOverMasterAssignmentManager(am, this.watcher);
            while (!am.processRITInvoked) {
                Thread.sleep(1L);
            }
            am.addPlan(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_B));
            Mocking.waitForRegionFailedToCloseAndSetToPendingClose(am, REGIONINFO);
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            Mocking.waitForRegionPendingOpenInRIT(am, REGIONINFO.getEncodedName());
            am.gate.set(false);
            versionid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.watcher);
        }
        finally {
            am.getExecutorService().shutdown();
            am.shutdown();
        }
    }

    private void createRegionPlanAndBalance(AssignmentManager am, ServerName from, ServerName to, HRegionInfo hri) throws RegionException {
        am.regionOnline(hri, from);
        am.balance(new RegionPlan(hri, from, to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testBalance() throws IOException, KeeperException, DeserializationException, InterruptedException, CoordinatedStateException {
        ExecutorService executor = this.startupMasterExecutor("testBalanceExecutor");
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, executor, null, this.master.getTableLockManager());
        am.failoverCleanupDone.set(true);
        try {
            this.watcher.registerListenerFirst((ZooKeeperListener)am);
            am.regionOnline(REGIONINFO, SERVERNAME_A);
            RegionPlan plan = new RegionPlan(REGIONINFO, SERVERNAME_A, SERVERNAME_B);
            am.balance(plan);
            RegionStates regionStates = am.getRegionStates();
            Assert.assertTrue((regionStates.isRegionInTransition(REGIONINFO) && regionStates.isRegionInState(REGIONINFO, new RegionState.State[]{RegionState.State.FAILED_CLOSE}) ? 1 : 0) != 0);
            regionStates.updateRegionState(REGIONINFO, RegionState.State.PENDING_CLOSE);
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            Mocking.waitForRegionPendingOpenInRIT(am, REGIONINFO.getEncodedName());
            versionid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            while (regionStates.isRegionInTransition(REGIONINFO)) {
                Threads.sleep((long)1L);
            }
        }
        finally {
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testShutdownHandler() throws KeeperException, IOException, CoordinatedStateException, ServiceException {
        ExecutorService executor = this.startupMasterExecutor("testShutdownHandler");
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            this.processServerShutdownHandler(am, false);
        }
        finally {
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    @Test(timeout=180000L)
    public void testSSHWhenDisableTableInProgress() throws KeeperException, IOException, CoordinatedStateException, ServiceException {
        this.testCaseWithPartiallyDisabledState(ZooKeeperProtos.Table.State.DISABLING);
        this.testCaseWithPartiallyDisabledState(ZooKeeperProtos.Table.State.DISABLED);
    }

    @Test(timeout=180000L)
    public void testSSHWhenSplitRegionInProgress() throws KeeperException, IOException, Exception {
        this.testCaseWithSplitRegionPartial(true);
        this.testCaseWithSplitRegionPartial(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCaseWithSplitRegionPartial(boolean regionSplitDone) throws KeeperException, IOException, InterruptedException, CoordinatedStateException, ServiceException {
        ExecutorService executor = this.startupMasterExecutor("testSSHWhenSplitRegionInProgress");
        ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        am.regionOnline(REGIONINFO, SERVERNAME_A);
        am.getRegionStates().updateRegionState(REGIONINFO, RegionState.State.SPLITTING, SERVERNAME_A);
        am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.ENABLED);
        RegionTransition data = RegionTransition.createRegionTransition((EventType)EventType.RS_ZK_REGION_SPLITTING, (byte[])REGIONINFO.getRegionName(), (ServerName)SERVERNAME_A);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)REGIONINFO.getEncodedName());
        ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)node, (byte[])data.toByteArray());
        try {
            this.processServerShutdownHandler(am, regionSplitDone);
            if (regionSplitDone) {
                Assert.assertFalse((String)"Region state of region in SPLITTING should be removed from rit.", (boolean)am.getRegionStates().isRegionsInTransition());
            } else {
                while (!am.assignInvoked) {
                    Thread.sleep(1L);
                }
                Assert.assertTrue((String)"Assign should be invoked.", (boolean)am.assignInvoked);
            }
        }
        finally {
            REGIONINFO.setOffline(false);
            REGIONINFO.setSplit(false);
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCaseWithPartiallyDisabledState(ZooKeeperProtos.Table.State state) throws KeeperException, IOException, CoordinatedStateException, ServiceException {
        ExecutorService executor = this.startupMasterExecutor("testSSHWhenDisableTableInProgress");
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, executor, null, this.master.getTableLockManager());
        am.regionOnline(REGIONINFO, SERVERNAME_A);
        am.getRegionStates().updateRegionState(REGIONINFO, RegionState.State.PENDING_CLOSE);
        if (state == ZooKeeperProtos.Table.State.DISABLING) {
            am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.DISABLING);
        } else {
            am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.DISABLED);
        }
        RegionTransition data = RegionTransition.createRegionTransition((EventType)EventType.M_ZK_REGION_CLOSING, (byte[])REGIONINFO.getRegionName(), (ServerName)SERVERNAME_A);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)REGIONINFO.getEncodedName());
        ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)node, (byte[])data.toByteArray());
        try {
            this.processServerShutdownHandler(am, false);
            Assert.assertTrue((String)"The znode should be deleted.", (ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)node) == -1 ? 1 : 0) != 0);
            if (state == ZooKeeperProtos.Table.State.DISABLED) {
                Assert.assertFalse((String)"Region state of region in pending close should be removed from rit.", (boolean)am.getRegionStates().isRegionsInTransition());
            }
        }
        finally {
            am.setEnabledTable(REGIONINFO.getTable());
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processServerShutdownHandler(AssignmentManager am, boolean splitRegion) throws IOException, ServiceException {
        this.watcher.registerListenerFirst((ZooKeeperListener)am);
        ClientProtos.ClientService.BlockingInterface implementation = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Result r = splitRegion ? MetaMockingUtil.getMetaTableRowResultAsSplitRegion(REGIONINFO, SERVERNAME_A) : MetaMockingUtil.getMetaTableRowResult(REGIONINFO, SERVERNAME_A);
        final ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        builder.setMoreResults(true);
        builder.addCellsPerResult(r.size());
        final ArrayList<Result> cellScannables = new ArrayList<Result>(1);
        cellScannables.add(r);
        Mockito.when((Object)implementation.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenAnswer((Answer)new Answer<ClientProtos.ScanResponse>(){

            public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                PayloadCarryingRpcController controller = (PayloadCarryingRpcController)invocation.getArguments()[0];
                if (controller != null) {
                    controller.setCellScanner(CellUtil.createCellScanner((List)cellScannables));
                }
                return builder.build();
            }
        });
        ClusterConnection connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(HTU.getConfiguration(), null, implementation, SERVERNAME_B, REGIONINFO);
        Mockito.when((Object)connection.isManaged()).thenReturn((Object)true);
        try {
            Mockito.when((Object)this.server.getConnection()).thenReturn((Object)connection);
            DeadServer deadServers = new DeadServer();
            deadServers.add(SERVERNAME_A);
            MasterFileSystem fs = (MasterFileSystem)Mockito.mock(MasterFileSystem.class);
            ((MasterFileSystem)Mockito.doNothing().when((Object)fs)).setLogRecoveryMode();
            Mockito.when((Object)fs.getLogRecoveryMode()).thenReturn((Object)ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY);
            MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
            Mockito.when((Object)services.getAssignmentManager()).thenReturn((Object)am);
            Mockito.when((Object)services.getServerManager()).thenReturn((Object)this.serverManager);
            Mockito.when((Object)services.getZooKeeper()).thenReturn((Object)this.watcher);
            Mockito.when((Object)services.getMasterFileSystem()).thenReturn((Object)fs);
            Mockito.when((Object)services.getConnection()).thenReturn((Object)connection);
            Configuration conf = this.server.getConfiguration();
            Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
            ServerShutdownHandler handler = new ServerShutdownHandler(this.server, services, deadServers, SERVERNAME_A, false);
            am.failoverCleanupDone.set(true);
            handler.process();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private ExecutorService startupMasterExecutor(String name) {
        ExecutorService executor = new ExecutorService(name);
        executor.startExecutorService(ExecutorType.MASTER_OPEN_REGION, 3);
        executor.startExecutorService(ExecutorType.MASTER_CLOSE_REGION, 3);
        executor.startExecutorService(ExecutorType.MASTER_SERVER_OPERATIONS, 3);
        executor.startExecutorService(ExecutorType.MASTER_META_SERVER_OPERATIONS, 3);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testUnassignWithSplitAtSameTime() throws KeeperException, IOException, CoordinatedStateException {
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        Mockito.when((Object)this.serverManager.sendRegionClose(SERVERNAME_A, hri, -1)).thenReturn((Object)true);
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, null, null, this.master.getTableLockManager());
        try {
            this.unassign(am, SERVERNAME_A, hri);
            ZKAssign.deleteClosingNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri, (ServerName)SERVERNAME_A);
            int version = TestAssignmentManager.createNodeSplitting(this.watcher, hri, SERVERNAME_A);
            this.unassign(am, SERVERNAME_A, hri);
            ZKAssign.transitionNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri, (ServerName)SERVERNAME_A, (EventType)EventType.RS_ZK_REGION_SPLITTING, (EventType)EventType.RS_ZK_REGION_SPLITTING, (int)version);
            Assert.assertFalse((boolean)am.getRegionStates().isRegionInTransition(hri));
        }
        finally {
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testProcessDeadServersAndRegionsInTransitionShouldNotFailWithNPE() throws IOException, KeeperException, CoordinatedStateException, InterruptedException, ServiceException {
        final RecoverableZooKeeper recoverableZk = (RecoverableZooKeeper)Mockito.mock(RecoverableZooKeeper.class);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(HBaseConfiguration.create(), "unittest", null){

            public RecoverableZooKeeper getRecoverableZooKeeper() {
                return recoverableZk;
            }
        };
        ((ZooKeeperWatcher)zkw).registerListener((ZooKeeperListener)am);
        ((RecoverableZooKeeper)Mockito.doThrow((Throwable)new InterruptedException()).when((Object)recoverableZk)).getChildren("/hbase/region-in-transition", null);
        am.setWatcher(zkw);
        try {
            am.processDeadServersAndRegionsInTransition(null);
            Assert.fail((String)"Expected to abort");
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Should not throw NPE");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Aborted", (Object)e.getLocalizedMessage());
        }
        finally {
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRegionPlanIsUpdatedWhenRegionFailsToOpen() throws IOException, KeeperException, ServiceException, InterruptedException, CoordinatedStateException {
        this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", MockedLoadBalancer.class, LoadBalancer.class);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            AtomicBoolean gate = new AtomicBoolean(false);
            if (this.balancer instanceof MockedLoadBalancer) {
                ((MockedLoadBalancer)this.balancer).setGateVariable(gate);
            }
            ZKAssign.createNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A);
            int v = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
            ZKAssign.transitionNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_FAILED_OPEN, (int)v);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)REGIONINFO.getEncodedName());
            am.getRegionStates().updateRegionState(REGIONINFO, RegionState.State.OPENING, SERVERNAME_A);
            am.regionPlans.put(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_A));
            RegionPlan regionPlan = (RegionPlan)am.regionPlans.get(REGIONINFO.getEncodedName());
            ArrayList<ServerName> serverList = new ArrayList<ServerName>(2);
            serverList.add(SERVERNAME_B);
            Mockito.when((Object)this.serverManager.createDestinationServersList(SERVERNAME_A)).thenReturn(serverList);
            am.nodeDataChanged(path);
            while (!gate.get()) {
                Thread.sleep(10L);
            }
            RegionPlan newRegionPlan = (RegionPlan)am.regionPlans.get(REGIONINFO.getEncodedName());
            while (newRegionPlan == null) {
                Thread.sleep(10L);
                newRegionPlan = (RegionPlan)am.regionPlans.get(REGIONINFO.getEncodedName());
            }
            Assert.assertNotSame((String)"Same region plan should not come", (Object)regionPlan, (Object)newRegionPlan);
            Assert.assertTrue((String)"Destination servers should be different.", (!regionPlan.getDestination().equals((Object)newRegionPlan.getDestination()) ? 1 : 0) != 0);
            Mocking.waitForRegionPendingOpenInRIT(am, REGIONINFO.getEncodedName());
        }
        finally {
            this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", SimpleLoadBalancer.class, LoadBalancer.class);
            am.getExecutorService().shutdown();
            am.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testRegionInOpeningStateOnDeadRSWhileMasterFailover() throws IOException, KeeperException, ServiceException, CoordinatedStateException, InterruptedException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A);
        int version = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
        ZKAssign.transitionNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)version);
        RegionTransition rt = RegionTransition.createRegionTransition((EventType)EventType.RS_ZK_REGION_OPENING, (byte[])REGIONINFO.getRegionName(), (ServerName)SERVERNAME_A, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        version = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_A)).thenReturn((Object)false);
        am.getRegionStates().logSplit(SERVERNAME_A);
        am.getRegionStates().createRegionState(REGIONINFO);
        am.gate.set(false);
        ZkCoordinatedStateManager cp = new ZkCoordinatedStateManager();
        cp.initialize(this.server);
        cp.start();
        OpenRegionCoordination orc = cp.getOpenRegionCoordination();
        ZkOpenRegionCoordination.ZkOpenRegionDetails zkOrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
        zkOrd.setServerName(this.server.getServerName());
        zkOrd.setVersion(version);
        Assert.assertFalse((boolean)am.processRegionsInTransition(rt, REGIONINFO, orc, (OpenRegionCoordination.OpenRegionDetails)zkOrd));
        am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.ENABLED);
        this.processServerShutdownHandler(am, false);
        while (!am.gate.get()) {
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"The region should be assigned immediately.", (null != am.regionPlans.get(REGIONINFO.getEncodedName()) ? 1 : 0) != 0);
        am.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDisablingTableRegionsAssignmentDuringCleanClusterStartup() throws KeeperException, IOException, Exception {
        this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", MockedLoadBalancer.class, LoadBalancer.class);
        Mockito.when((Object)this.serverManager.getOnlineServers()).thenReturn(new HashMap(0));
        ArrayList<ServerName> destServers = new ArrayList<ServerName>(1);
        destServers.add(SERVERNAME_A);
        Mockito.when((Object)this.serverManager.createDestinationServersList()).thenReturn(destServers);
        HTU.getConfiguration().setInt("hbase.master.port", 0);
        CoordinatedStateManager csm = CoordinatedStateManagerFactory.getCoordinatedStateManager((Configuration)HTU.getConfiguration());
        HMaster server = new HMaster(HTU.getConfiguration(), csm);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager((Server)server, this.serverManager);
        Whitebox.setInternalState((Object)server, (String)"metaTableLocator", (Object)Mockito.mock(MetaTableLocator.class));
        Whitebox.setInternalState((Object)server, (String)"clusterConnection", (Object)am.getConnection());
        AtomicBoolean gate = new AtomicBoolean(false);
        if (this.balancer instanceof MockedLoadBalancer) {
            ((MockedLoadBalancer)this.balancer).setGateVariable(gate);
        }
        try {
            am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.DISABLING);
            am.joinCluster();
            Assert.assertFalse((String)"Assign should not be invoked for disabling table regions during clean cluster startup.", (boolean)gate.get());
            Assert.assertTrue((String)"Table should be disabled.", (boolean)am.getTableStateManager().isTableState(REGIONINFO.getTable(), new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.DISABLED}));
        }
        finally {
            this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", SimpleLoadBalancer.class, LoadBalancer.class);
            am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.ENABLED);
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testMasterRestartWhenTableInEnabling() throws KeeperException, IOException, Exception {
        enabling = true;
        ArrayList<ServerName> destServers = new ArrayList<ServerName>(1);
        destServers.add(SERVERNAME_A);
        Mockito.when((Object)this.serverManager.createDestinationServersList()).thenReturn(destServers);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_A)).thenReturn((Object)true);
        HTU.getConfiguration().setInt("hbase.master.port", 0);
        CoordinatedStateManager csm = CoordinatedStateManagerFactory.getCoordinatedStateManager((Configuration)HTU.getConfiguration());
        HMaster server = new HMaster(HTU.getConfiguration(), csm);
        Whitebox.setInternalState((Object)server, (String)"serverManager", (Object)this.serverManager);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager((Server)server, this.serverManager);
        Whitebox.setInternalState((Object)server, (String)"metaTableLocator", (Object)Mockito.mock(MetaTableLocator.class));
        Whitebox.setInternalState((Object)server, (String)"clusterConnection", (Object)am.getConnection());
        try {
            am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.ENABLING);
            new EnableTableHandler((Server)server, REGIONINFO.getTable(), (AssignmentManager)am, (TableLockManager)new TableLockManager.NullTableLockManager(), true).prepare().process();
            Assert.assertEquals((String)"Number of assignments should be 1.", (long)1L, (long)assignmentCount);
            Assert.assertTrue((String)"Table should be enabled.", (boolean)am.getTableStateManager().isTableState(REGIONINFO.getTable(), new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED}));
        }
        finally {
            enabling = false;
            assignmentCount = 0;
            am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.ENABLED);
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testMasterRestartShouldRemoveStaleZnodesOfUnknownTableAsForMeta() throws Exception {
        ArrayList<ServerName> destServers = new ArrayList<ServerName>(1);
        destServers.add(SERVERNAME_A);
        Mockito.when((Object)this.serverManager.createDestinationServersList()).thenReturn(destServers);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_A)).thenReturn((Object)true);
        HTU.getConfiguration().setInt("hbase.master.port", 0);
        CoordinatedStateManager csm = CoordinatedStateManagerFactory.getCoordinatedStateManager((Configuration)HTU.getConfiguration());
        HMaster server = new HMaster(HTU.getConfiguration(), csm);
        Whitebox.setInternalState((Object)server, (String)"serverManager", (Object)this.serverManager);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager((Server)server, this.serverManager);
        Whitebox.setInternalState((Object)server, (String)"metaTableLocator", (Object)Mockito.mock(MetaTableLocator.class));
        Whitebox.setInternalState((Object)server, (String)"clusterConnection", (Object)am.getConnection());
        try {
            TableName tableName = TableName.valueOf((String)"dummyTable");
            am.getTableStateManager().setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
            am.joinCluster();
            Assert.assertFalse((String)"Table should not be present in zookeeper.", (boolean)am.getTableStateManager().isTablePresent(tableName));
        }
        finally {
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSSHTimesOutOpeningRegionTransition() throws KeeperException, IOException, CoordinatedStateException, ServiceException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        RegionState state = new RegionState(REGIONINFO, RegionState.State.OPENING, System.currentTimeMillis(), SERVERNAME_A);
        am.getRegionStates().regionOnline(REGIONINFO, SERVERNAME_B);
        am.getRegionStates().regionsInTransition.put(REGIONINFO.getEncodedName(), state);
        am.regionPlans.put(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, SERVERNAME_B, SERVERNAME_A));
        am.getTableStateManager().setTableState(REGIONINFO.getTable(), ZooKeeperProtos.Table.State.ENABLED);
        try {
            am.assignInvoked = false;
            this.processServerShutdownHandler(am, false);
            Assert.assertTrue((boolean)am.assignInvoked);
        }
        finally {
            am.getRegionStates().regionsInTransition.remove(REGIONINFO.getEncodedName());
            am.regionPlans.remove(REGIONINFO.getEncodedName());
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testClosingFailureDuringRecovery() throws Exception {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A);
        try {
            am.getRegionStates().createRegionState(REGIONINFO);
            Assert.assertFalse((boolean)am.getRegionStates().isRegionsInTransition());
            am.processRegionInTransition(REGIONINFO.getEncodedName(), REGIONINFO);
            Assert.assertTrue((boolean)am.getRegionStates().isRegionsInTransition());
        }
        finally {
            am.shutdown();
        }
    }

    private static int createNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, IOException {
        RegionTransition rt = RegionTransition.createRegionTransition((EventType)EventType.RS_ZK_REGION_SPLITTING, (byte[])region.getRegionName(), (ServerName)serverName);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)region.getEncodedName());
        if (!ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)zkw, (String)node, (byte[])rt.toByteArray())) {
            throw new IOException("Failed create of ephemeral " + node);
        }
        return TestAssignmentManager.transitionNodeSplitting(zkw, region, serverName, -1);
    }

    private static int transitionNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo parent, ServerName serverName, int version) throws KeeperException, IOException {
        return ZKAssign.transitionNode((ZooKeeperWatcher)zkw, (HRegionInfo)parent, (ServerName)serverName, (EventType)EventType.RS_ZK_REGION_SPLITTING, (EventType)EventType.RS_ZK_REGION_SPLITTING, (int)version);
    }

    private void unassign(AssignmentManager am, ServerName sn, HRegionInfo hri) throws RegionException {
        am.regionOnline(hri, sn);
        am.unassign(hri);
    }

    private AssignmentManagerWithExtrasForTesting setUpMockedAssignmentManager(Server server, ServerManager manager) throws IOException, KeeperException, ServiceException, CoordinatedStateException {
        ClientProtos.ClientService.BlockingInterface ri = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Result r = MetaMockingUtil.getMetaTableRowResult(REGIONINFO, SERVERNAME_A);
        final ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        builder.setMoreResults(true);
        builder.addCellsPerResult(r.size());
        final ArrayList<Result> rows = new ArrayList<Result>(1);
        rows.add(r);
        Answer<ClientProtos.ScanResponse> ans = new Answer<ClientProtos.ScanResponse>(){

            public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                PayloadCarryingRpcController controller = (PayloadCarryingRpcController)invocation.getArguments()[0];
                if (controller != null) {
                    controller.setCellScanner(CellUtil.createCellScanner((List)rows));
                }
                return builder.build();
            }
        };
        if (enabling) {
            Mockito.when((Object)ri.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenAnswer((Answer)ans).thenAnswer((Answer)ans).thenAnswer((Answer)ans).thenAnswer((Answer)ans).thenAnswer((Answer)ans).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setMoreResults(false).build());
        } else {
            Mockito.when((Object)ri.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenAnswer((Answer)ans);
        }
        ClientProtos.GetResponse.Builder getBuilder = ClientProtos.GetResponse.newBuilder();
        getBuilder.setResult(ProtobufUtil.toResult((Result)r));
        Mockito.when((Object)ri.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenReturn((Object)getBuilder.build());
        ClusterConnection connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(HTU.getConfiguration(), null, ri, SERVERNAME_B, REGIONINFO);
        Mockito.when((Object)this.server.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.isManaged()).thenReturn((Object)true);
        ExecutorService executor = this.startupMasterExecutor("mockedAMExecutor");
        this.balancer = LoadBalancerFactory.getLoadBalancer((Configuration)server.getConfiguration());
        AssignmentManagerWithExtrasForTesting am = new AssignmentManagerWithExtrasForTesting(server, connection, manager, this.balancer, executor, (TableLockManager)new TableLockManager.NullTableLockManager());
        return am;
    }

    private void startFakeFailedOverMasterAssignmentManager(final AssignmentManager am, ZooKeeperWatcher watcher) {
        watcher.registerListenerFirst((ZooKeeperListener)am);
        Thread t = new Thread("RunAmJoinCluster"){

            @Override
            public void run() {
                am.getRegionStates().regionsInTransition.clear();
                am.regionPlans.clear();
                try {
                    am.joinCluster();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (CoordinatedStateException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep((long)1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testForceAssignMergingRegion() throws Exception {
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, null, null, this.master.getTableLockManager());
        RegionStates regionStates = am.getRegionStates();
        try {
            regionStates.updateRegionState(hri, RegionState.State.MERGING);
            am.assign(hri, true, true);
            Assert.assertEquals((String)"The region should be still in merging state", (Object)RegionState.State.MERGING, (Object)regionStates.getRegionState(hri).getState());
        }
        finally {
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testAssignmentEventIgnoredIfNotExpected() throws KeeperException, IOException, CoordinatedStateException {
        final HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        final AtomicBoolean zkEventProcessed = new AtomicBoolean(false);
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, null, null, this.master.getTableLockManager()){

            void handleRegion(RegionTransition rt, OpenRegionCoordination coordination, OpenRegionCoordination.OpenRegionDetails ord) {
                super.handleRegion(rt, coordination, ord);
                if (rt != null && Bytes.equals((byte[])hri.getRegionName(), (byte[])rt.getRegionName()) && rt.getEventType() == EventType.RS_ZK_REGION_OPENING) {
                    zkEventProcessed.set(true);
                }
            }
        };
        try {
            am.getRegionStates().regionOffline(hri);
            zkEventProcessed.set(false);
            this.watcher.registerListenerFirst((ZooKeeperListener)am);
            Assert.assertFalse((String)"The region should not be in transition", (boolean)am.getRegionStates().isRegionInTransition(hri));
            ZKAssign.createNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri, (ServerName)SERVERNAME_A);
            ZKAssign.transitionNodeOpening((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri, (ServerName)SERVERNAME_A);
            long startTime = EnvironmentEdgeManager.currentTime();
            while (!zkEventProcessed.get()) {
                Assert.assertTrue((String)"Timed out in waiting for ZK event to be processed", (EnvironmentEdgeManager.currentTime() - startTime < 30000L ? 1 : 0) != 0);
                Threads.sleepWithoutInterrupt((long)100L);
            }
            Assert.assertFalse((boolean)am.getRegionStates().isRegionInTransition(hri));
        }
        finally {
            am.shutdown();
        }
    }

    @Test(timeout=180000L)
    public void testBalanceRegionOfDeletedTable() throws Exception {
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, this.balancer, null, null, this.master.getTableLockManager());
        RegionStates regionStates = am.getRegionStates();
        HRegionInfo hri = REGIONINFO;
        regionStates.createRegionState(hri);
        Assert.assertFalse((boolean)regionStates.isRegionInTransition(hri));
        RegionPlan plan = new RegionPlan(hri, SERVERNAME_A, SERVERNAME_B);
        regionStates.tableDeleted(hri.getTable());
        am.balance(plan);
        Assert.assertFalse((String)"The region should not in transition", (boolean)regionStates.isRegionInTransition(hri));
        am.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testOpenCloseRegionRPCIntendedForPreviousServer() throws Exception {
        Mockito.when((Object)this.serverManager.sendRegionOpen((ServerName)Mockito.eq((Object)SERVERNAME_B), (HRegionInfo)Mockito.eq((Object)REGIONINFO), Mockito.anyInt(), (List)Mockito.any())).thenThrow(new Throwable[]{new DoNotRetryIOException()});
        this.server.getConfiguration().setInt("hbase.assignment.maximum.attempts", 100);
        HRegionInfo hri = REGIONINFO;
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, null, null, this.master.getTableLockManager());
        RegionStates regionStates = am.getRegionStates();
        try {
            am.regionPlans.put(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_B));
            am.assign(hri, true, false);
        }
        finally {
            Assert.assertEquals((Object)SERVERNAME_A, (Object)regionStates.getRegionState(REGIONINFO).getServerName());
            am.shutdown();
        }
    }

    @Test(timeout=180000L)
    public void testCloseRegionOnAbortingRS() throws Exception {
        this.server.getConfiguration().setInt("hbase.assignment.maximum.attempts", 2);
        HRegionInfo hri = REGIONINFO;
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, null, null, this.master.getTableLockManager());
        RegionStates regionStates = am.getRegionStates();
        regionStates.createRegionState(hri, RegionState.State.OPEN, SERVERNAME_B, SERVERNAME_B);
        Mockito.when((Object)this.serverManager.sendRegionClose((ServerName)Mockito.eq((Object)SERVERNAME_B), (HRegionInfo)Mockito.eq((Object)REGIONINFO), Mockito.anyInt(), (ServerName)Mockito.any(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new RegionServerAbortedException("")});
        am.unassign(hri);
        Assert.assertEquals((Object)RegionState.State.FAILED_CLOSE, (Object)regionStates.getRegionState(REGIONINFO).getState());
        Assert.assertEquals((Object)SERVERNAME_B, (Object)regionStates.getRegionState(REGIONINFO).getServerName());
        am.shutdown();
    }

    @Test(timeout=180000L)
    public void testCloseRegionOnServerNotOnline() throws Exception {
        this.server.getConfiguration().setInt("hbase.assignment.maximum.attempts", 2);
        HRegionInfo hri = REGIONINFO;
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, balancer, null, null, this.master.getTableLockManager()){

            protected boolean wasRegionOnDeadServerByMeta(HRegionInfo region, ServerName sn) {
                return true;
            }
        };
        RegionStates regionStates = am.getRegionStates();
        regionStates.createRegionState(hri, RegionState.State.OPEN, SERVERNAME_B, SERVERNAME_B);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_B)).thenReturn((Object)false);
        am.unassign(hri);
        Assert.assertEquals((Object)RegionState.State.OFFLINE, (Object)regionStates.getRegionState(REGIONINFO).getState());
        am.regionPlans.put(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_A));
        am.assign(hri, true, false);
        Assert.assertEquals((Object)RegionState.State.OFFLINE, (Object)regionStates.getRegionState(REGIONINFO).getState());
        am.shutdown();
    }

    static {
        enabling = false;
    }

    class AssignmentManagerWithExtrasForTesting
    extends AssignmentManager {
        private final ExecutorService es;
        boolean processRITInvoked;
        boolean assignInvoked;
        AtomicBoolean gate;
        private ClusterConnection connection;

        public AssignmentManagerWithExtrasForTesting(Server master, ClusterConnection connection, ServerManager serverManager, LoadBalancer balancer, ExecutorService service, TableLockManager tableLockManager) throws KeeperException, IOException, CoordinatedStateException {
            super(master, serverManager, balancer, service, null, tableLockManager);
            this.processRITInvoked = false;
            this.assignInvoked = false;
            this.gate = new AtomicBoolean(true);
            this.es = service;
            this.connection = connection;
        }

        boolean processRegionInTransition(String encodedRegionName, HRegionInfo regionInfo) throws KeeperException, IOException {
            this.processRITInvoked = true;
            return super.processRegionInTransition(encodedRegionName, regionInfo);
        }

        public void assign(HRegionInfo region, boolean setOfflineInZK, boolean forceNewPlan) {
            if (enabling) {
                assignmentCount++;
                this.regionOnline(region, SERVERNAME_A);
            } else {
                super.assign(region, setOfflineInZK, forceNewPlan);
                this.gate.set(true);
            }
        }

        boolean assign(ServerName destination, List<HRegionInfo> regions) throws InterruptedException {
            if (enabling) {
                for (HRegionInfo region : regions) {
                    assignmentCount++;
                    this.regionOnline(region, SERVERNAME_A);
                }
                return true;
            }
            return super.assign(destination, regions);
        }

        public void assign(List<HRegionInfo> regions) throws IOException, InterruptedException {
            this.assignInvoked = regions != null && regions.size() > 0;
            super.assign(regions);
            this.gate.set(true);
        }

        void setWatcher(ZooKeeperWatcher watcher) {
            this.watcher = watcher;
        }

        ExecutorService getExecutorService() {
            return this.es;
        }

        ClusterConnection getConnection() {
            return this.connection;
        }

        public void shutdown() {
            super.shutdown();
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    Assert.fail((String)"Failed to close connection");
                }
            }
        }
    }

    public static class MockedLoadBalancer
    extends SimpleLoadBalancer {
        private AtomicBoolean gate;

        public void setGateVariable(AtomicBoolean gate) {
            this.gate = gate;
        }

        public ServerName randomAssignment(HRegionInfo regionInfo, List<ServerName> servers) {
            ServerName randomServerName = super.randomAssignment(regionInfo, servers);
            this.gate.set(true);
            return randomServerName;
        }

        public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) {
            this.gate.set(true);
            return super.retainAssignment(regions, servers);
        }
    }
}

