/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.Bytes;

public class TestKeyValue
extends TestCase {
    private final Log LOG = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private final byte[] rowA = Bytes.toBytes((String)"rowA");
    private final byte[] rowB = Bytes.toBytes((String)"rowB");
    private final byte[] family = Bytes.toBytes((String)"family");
    private final byte[] qualA = Bytes.toBytes((String)"qfA");
    private final byte[] qualB = Bytes.toBytes((String)"qfB");

    public void testColumnCompare() throws Exception {
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] family1 = Bytes.toBytes((String)"abc");
        byte[] qualifier1 = Bytes.toBytes((String)"def");
        byte[] family2 = Bytes.toBytes((String)"abcd");
        byte[] qualifier2 = Bytes.toBytes((String)"ef");
        KeyValue aaa = new KeyValue(a, family1, qualifier1, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family1, (byte[])qualifier1));
        aaa = new KeyValue(a, family2, qualifier2, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family1, (byte[])qualifier1));
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
        byte[] nullQualifier = new byte[]{};
        aaa = new KeyValue(a, family1, nullQualifier, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family1, null));
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
    }

    public void testColumnCompare_prefix() throws Exception {
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] family1 = Bytes.toBytes((String)"abc");
        byte[] qualifier1 = Bytes.toBytes((String)"def");
        byte[] family2 = Bytes.toBytes((String)"ab");
        byte[] qualifier2 = Bytes.toBytes((String)"def");
        KeyValue aaa = new KeyValue(a, family1, qualifier1, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
    }

    public void testBasics() throws Exception {
        this.LOG.info((Object)("LOWKEY: " + KeyValue.LOWESTKEY.toString()));
        this.check(Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()), 1L, Bytes.toBytes((String)this.getName()));
        this.check(Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()), null, 1L, null);
        this.check(HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)this.getName()), null, 1L, null);
        TestKeyValue.assertEquals((Object)new KeyValue(Bytes.toBytes((String)"rk"), Bytes.toBytes((String)"fam"), null, 1L, (byte[])null), (Object)new KeyValue(Bytes.toBytes((String)"rk"), Bytes.toBytes((String)"fam"), HConstants.EMPTY_BYTE_ARRAY, 1L, (byte[])null));
    }

    private void check(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        KeyValue kv = new KeyValue(row, family, qualifier, timestamp, value);
        TestKeyValue.assertTrue((Bytes.compareTo((byte[])kv.getRow(), (byte[])row) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn((Cell)kv, (byte[])family, (byte[])qualifier));
        this.LOG.info((Object)kv.toString());
    }

    public void testPlainCompare() throws Exception {
        KeyValue bbb;
        byte[] qf;
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] b = Bytes.toBytes((String)"bbb");
        byte[] fam = Bytes.toBytes((String)"col");
        KeyValue aaa = new KeyValue(a, fam, qf = Bytes.toBytes((String)"umn"), a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)aaa, (Cell)(bbb = new KeyValue(b, fam, qf, b))) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)bbb, (Cell)aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)bbb, (Cell)bbb) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)aaa, (Cell)aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, a);
        bbb = new KeyValue(a, fam, qf, 2L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)aaa, (Cell)bbb) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)bbb, (Cell)aaa) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)aaa, (Cell)aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, KeyValue.Type.Delete, a);
        bbb = new KeyValue(a, fam, qf, 1L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)aaa, (Cell)bbb) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)bbb, (Cell)aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare((Cell)aaa, (Cell)aaa) == 0 ? 1 : 0) != 0);
    }

    public void testMoreComparisons() throws Exception {
        long now = System.currentTimeMillis();
        KeyValue aaa = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236020145502"), now);
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        KeyValue bbb = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,99999999999999"), now);
        TestKeyValue.assertTrue((c.compare((Cell)bbb, (Cell)aaa) < 0 ? 1 : 0) != 0);
        KeyValue aaaa = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,1236023996656"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236024396271L, (byte[])null);
        TestKeyValue.assertTrue((c.compare((Cell)aaaa, (Cell)bbb) < 0 ? 1 : 0) != 0);
        KeyValue x = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        KeyValue y = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236034574912L, (byte[])null);
        TestKeyValue.assertTrue((c.compare((Cell)x, (Cell)y) < 0 ? 1 : 0) != 0);
        this.comparisons((KeyValue.KVComparator)new KeyValue.MetaComparator());
        this.comparisons(new KeyValue.KVComparator());
        this.metacomparisons(new KeyValue.MetaComparator());
    }

    public void testMetaComparatorTableKeysWithCommaOk() {
        KeyValue b;
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes((String)"table,key,with,commas1,1234"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)(b = new KeyValue(Bytes.toBytes((String)"table,key,with,commas2,0123"), now))) < 0 ? 1 : 0) != 0);
    }

    public void testKeyValueBorderCases() throws IOException {
        KeyValue rowB;
        KeyValue rowA = new KeyValue(Bytes.toBytes((String)"testtable,www.hbase.org/,1234"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare((Cell)rowA, (Cell)(rowB = new KeyValue(Bytes.toBytes((String)"testtable,www.hbase.org/%20,99999"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null))) < 0 ? 1 : 0) != 0);
        rowA = new KeyValue(Bytes.toBytes((String)"testtable,,1234"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        rowB = new KeyValue(Bytes.toBytes((String)"testtable,$www.hbase.org/,99999"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare((Cell)rowA, (Cell)rowB) < 0 ? 1 : 0) != 0);
    }

    private void metacomparisons(KeyValue.MetaComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now)) == 0 ? 1 : 0) != 0);
        KeyValue a = new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now);
        KeyValue b = new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2")), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now)) > 0 ? 1 : 0) != 0);
    }

    private void comparisons(KeyValue.KVComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now)) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,2")), now)) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,2")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now)) > 0 ? 1 : 0) != 0);
    }

    public void testBinaryKeys() throws Exception {
        TreeSet set = new TreeSet(KeyValue.COMPARATOR);
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] nb = new byte[]{};
        KeyValue[] keys = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"aaaaa,\u0000\u0000,2"), fam, qf, 2L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,\u0001,3"), fam, qf, 3L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,,1"), fam, qf, 1L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,\u1000,5"), fam, qf, 5L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,a,4"), fam, qf, 4L, nb), new KeyValue(Bytes.toBytes((String)"a,a,0"), fam, qf, 0L, nb)};
        Collections.addAll(set, keys);
        boolean assertion = false;
        int count = 0;
        try {
            for (KeyValue k : set) {
                TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        TestKeyValue.assertTrue((boolean)assertion);
        set = new TreeSet(new KeyValue.MetaComparator());
        Collections.addAll(set, keys);
        count = 0;
        for (KeyValue k : set) {
            TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
    }

    public void testStackedUpKeyValue() {
    }

    private void assertKVLess(KeyValue.KVComparator c, KeyValue less, KeyValue greater) {
        int cmp = c.compare((Cell)less, (Cell)greater);
        TestKeyValue.assertTrue((cmp < 0 ? 1 : 0) != 0);
        cmp = c.compare((Cell)greater, (Cell)less);
        TestKeyValue.assertTrue((cmp > 0 ? 1 : 0) != 0);
    }

    private void assertKVLessWithoutRow(KeyValue.KVComparator c, int common, KeyValue less, KeyValue greater) {
        int cmp = c.compareIgnoringPrefix(common, less.getBuffer(), less.getOffset() + 8, less.getKeyLength(), greater.getBuffer(), greater.getOffset() + 8, greater.getKeyLength());
        TestKeyValue.assertTrue((cmp < 0 ? 1 : 0) != 0);
        cmp = c.compareIgnoringPrefix(common, greater.getBuffer(), greater.getOffset() + 8, greater.getKeyLength(), less.getBuffer(), less.getOffset() + 8, less.getKeyLength());
        TestKeyValue.assertTrue((cmp > 0 ? 1 : 0) != 0);
    }

    public void testCompareWithoutRow() {
        KeyValue.KVComparator c = KeyValue.COMPARATOR;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] fa = Bytes.toBytes((String)"fa");
        byte[] fami = Bytes.toBytes((String)"fami");
        byte[] fami1 = Bytes.toBytes((String)"fami1");
        byte[] qual0 = Bytes.toBytes((String)"");
        byte[] qual1 = Bytes.toBytes((String)"qf1");
        byte[] qual2 = Bytes.toBytes((String)"qf2");
        long ts = 1L;
        KeyValue kv_0 = new KeyValue(row, fa, qual0, ts, KeyValue.Type.Put);
        KeyValue kv0_0 = new KeyValue(row, fami, qual0, ts, KeyValue.Type.Put);
        KeyValue kv0_1 = new KeyValue(row, fami, qual1, ts, KeyValue.Type.Put);
        KeyValue kv0_2 = new KeyValue(row, fami, qual2, ts, KeyValue.Type.Put);
        KeyValue kv1_0 = new KeyValue(row, fami1, qual0, ts, KeyValue.Type.Put);
        this.assertKVLessWithoutRow(c, 0, kv0_1, kv0_2);
        this.assertKVLessWithoutRow(c, 0, kv0_1, kv1_0);
        int commonLength = 3 + row.length;
        this.assertKVLessWithoutRow(c, commonLength + 2, kv_0, kv0_0);
        this.assertKVLessWithoutRow(c, commonLength + 4, kv0_0, kv0_1);
        this.assertKVLessWithoutRow(c, commonLength + 4, kv0_1, kv1_0);
        this.assertKVLessWithoutRow(c, commonLength + 6, kv0_1, kv0_2);
    }

    public void testFirstLastOnRow() {
        KeyValue.KVComparator c = KeyValue.COMPARATOR;
        long ts = 1L;
        byte[] bufferA = new byte[128];
        int offsetA = 0;
        byte[] bufferB = new byte[128];
        int offsetB = 7;
        KeyValue firstOnRowA = KeyValueUtil.createFirstOnRow((byte[])this.rowA);
        KeyValue firstOnRowABufferFamQual = KeyValueUtil.createFirstOnRow((byte[])bufferA, (int)offsetA, (byte[])this.rowA, (int)0, (int)this.rowA.length, (byte[])this.family, (int)0, (int)this.family.length, (byte[])this.qualA, (int)0, (int)this.qualA.length);
        KeyValue kvA_1 = new KeyValue(this.rowA, null, null, ts, KeyValue.Type.Put);
        KeyValue kvA_2 = new KeyValue(this.rowA, this.family, this.qualA, ts, KeyValue.Type.Put);
        KeyValue lastOnRowA = KeyValueUtil.createLastOnRow((byte[])this.rowA);
        KeyValue firstOnRowB = KeyValueUtil.createFirstOnRow((byte[])this.rowB);
        KeyValue firstOnRowBBufferFam = KeyValueUtil.createFirstOnRow((byte[])bufferB, (int)offsetB, (byte[])this.rowB, (int)0, (int)this.rowB.length, (byte[])this.family, (int)0, (int)this.family.length, null, (int)0, (int)0);
        KeyValue kvB = new KeyValue(this.rowB, this.family, this.qualA, ts, KeyValue.Type.Put);
        this.assertKVLess(c, firstOnRowA, firstOnRowB);
        this.assertKVLess(c, firstOnRowA, firstOnRowBBufferFam);
        this.assertKVLess(c, firstOnRowABufferFamQual, firstOnRowB);
        this.assertKVLess(c, firstOnRowA, kvA_1);
        this.assertKVLess(c, firstOnRowA, kvA_2);
        this.assertKVLess(c, firstOnRowABufferFamQual, kvA_2);
        this.assertKVLess(c, kvA_1, kvA_2);
        this.assertKVLess(c, kvA_2, firstOnRowB);
        this.assertKVLess(c, kvA_1, firstOnRowB);
        this.assertKVLess(c, kvA_2, firstOnRowBBufferFam);
        this.assertKVLess(c, kvA_1, firstOnRowBBufferFam);
        this.assertKVLess(c, lastOnRowA, firstOnRowB);
        this.assertKVLess(c, lastOnRowA, firstOnRowBBufferFam);
        this.assertKVLess(c, firstOnRowB, kvB);
        this.assertKVLess(c, firstOnRowBBufferFam, kvB);
        this.assertKVLess(c, lastOnRowA, kvB);
        this.assertKVLess(c, kvA_2, lastOnRowA);
        this.assertKVLess(c, kvA_1, lastOnRowA);
        this.assertKVLess(c, firstOnRowA, lastOnRowA);
        this.assertKVLess(c, firstOnRowABufferFamQual, lastOnRowA);
    }

    public void testCreateKeyOnly() throws Exception {
        long ts = 1L;
        byte[] value = Bytes.toBytes((String)"a real value");
        byte[] evalue = new byte[]{};
        for (byte[] val : new byte[][]{value, evalue}) {
            for (boolean useLen : new boolean[]{false, true}) {
                KeyValue kv1 = new KeyValue(this.rowA, this.family, this.qualA, ts, val);
                KeyValue kv1ko = kv1.createKeyOnly(useLen);
                TestKeyValue.assertTrue((boolean)kv1.equals((Object)kv1ko));
                TestKeyValue.assertTrue((kv1ko.getValue().length == (useLen ? 4 : 0) ? 1 : 0) != 0);
                if (!useLen) continue;
                TestKeyValue.assertEquals((int)kv1.getValueLength(), (int)Bytes.toInt((byte[])kv1ko.getValue()));
            }
        }
    }

    public void testCreateKeyValueFromKey() {
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"myRow"), Bytes.toBytes((String)"myCF"), Bytes.toBytes((String)"myQualifier"), 12345L, Bytes.toBytes((String)"myValue"));
        int initialPadding = 10;
        int endingPadding = 20;
        int keyLen = kv.getKeyLength();
        byte[] tmpArr = new byte[initialPadding + endingPadding + keyLen];
        System.arraycopy(kv.getBuffer(), kv.getKeyOffset(), tmpArr, initialPadding, keyLen);
        KeyValue kvFromKey = KeyValue.createKeyValueFromKey((byte[])tmpArr, (int)initialPadding, (int)keyLen);
        TestKeyValue.assertEquals((int)keyLen, (int)kvFromKey.getKeyLength());
        TestKeyValue.assertEquals((int)(8 + keyLen), (int)kvFromKey.getBuffer().length);
        System.err.println("kv=" + kv);
        System.err.println("kvFromKey=" + kvFromKey);
        TestKeyValue.assertEquals((String)kvFromKey.toString(), (String)kv.toString().replaceAll("=[0-9]+", "=0"));
    }

    public void testGetTimestamp() {
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"myRow"), Bytes.toBytes((String)"myCF"), Bytes.toBytes((String)"myQualifier"), Long.MAX_VALUE, Bytes.toBytes((String)"myValue"));
        long time1 = kv.getTimestamp();
        kv.updateLatestStamp(Bytes.toBytes((long)12345L));
        long time2 = kv.getTimestamp();
        TestKeyValue.assertEquals((long)Long.MAX_VALUE, (long)time1);
        TestKeyValue.assertEquals((long)12345L, (long)time2);
    }

    public void testGetShortMidpointKey() {
        KeyValue.KVComparator keyComparator = KeyValue.COMPARATOR;
        long ts = 5L;
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"the quick brown fox"), this.family, this.qualA, ts, KeyValue.Type.Put);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"the who test text"), this.family, this.qualA, ts, KeyValue.Type.Put);
        byte[] newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        short newRowLength = Bytes.toShort((byte[])newKey, (int)0);
        byte[] expectedArray = Bytes.toBytes((String)"the r");
        Bytes.equals((byte[])newKey, (int)2, (int)newRowLength, (byte[])expectedArray, (int)0, (int)expectedArray.length);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), this.family, this.qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), this.family, this.qualA, 0L, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), this.family, this.qualA, -5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), this.family, this.qualA, -10L, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), this.family, this.qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), this.family, this.qualB, 5L, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        KeyValue newKeyValue = KeyValue.createKeyValueFromKey((byte[])newKey);
        TestKeyValue.assertTrue((boolean)Arrays.equals(newKeyValue.getFamily(), this.family));
        TestKeyValue.assertTrue((boolean)Arrays.equals(newKeyValue.getQualifier(), this.qualB));
        TestKeyValue.assertTrue((newKeyValue.getTimestamp() == Long.MAX_VALUE ? 1 : 0) != 0);
        TestKeyValue.assertTrue((newKeyValue.getTypeByte() == KeyValue.Type.Maximum.getCode() ? 1 : 0) != 0);
        KeyValue.KVComparator metaKeyComparator = KeyValue.META_COMPARATOR;
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase123"), this.family, this.qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase234"), this.family, this.qualA, 0L, KeyValue.Type.Put);
        newKey = metaKeyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((metaKeyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((metaKeyComparator.compareFlatKey(newKey, kv2.getKey()) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), this.family, this.qualA, ts, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbaseandhdfs"), this.family, this.qualA, ts, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        newRowLength = Bytes.toShort((byte[])newKey, (int)0);
        expectedArray = Bytes.toBytes((String)"ilovehbasea");
        Bytes.equals((byte[])newKey, (int)2, (int)newRowLength, (byte[])expectedArray, (int)0, (int)expectedArray.length);
        kv1 = new KeyValue(Bytes.toBytes((String)"100abcdefg"), this.family, this.qualA, ts, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"101abcdefg"), this.family, this.qualA, ts, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        newRowLength = Bytes.toShort((byte[])newKey, (int)0);
        expectedArray = Bytes.toBytes((String)"101");
        Bytes.equals((byte[])newKey, (int)2, (int)newRowLength, (byte[])expectedArray, (int)0, (int)expectedArray.length);
    }

    public void testKVsWithTags() {
        byte[] row = Bytes.toBytes((String)"myRow");
        byte[] cf = Bytes.toBytes((String)"myCF");
        byte[] q = Bytes.toBytes((String)"myQualifier");
        byte[] value = Bytes.toBytes((String)"myValue");
        byte[] metaValue1 = Bytes.toBytes((String)"metaValue1");
        byte[] metaValue2 = Bytes.toBytes((String)"metaValue2");
        KeyValue kv = new KeyValue(row, cf, q, Long.MAX_VALUE, value, new Tag[]{new Tag(1, metaValue1), new Tag(2, metaValue2)});
        TestKeyValue.assertTrue((kv.getTagsLength() > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((boolean)Bytes.equals((byte[])kv.getRow(), (byte[])row));
        TestKeyValue.assertTrue((boolean)Bytes.equals((byte[])kv.getFamily(), (byte[])cf));
        TestKeyValue.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])q));
        TestKeyValue.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value));
        List tags = kv.getTags();
        TestKeyValue.assertNotNull((Object)tags);
        TestKeyValue.assertEquals((int)2, (int)tags.size());
        boolean meta1Ok = false;
        boolean meta2Ok = false;
        for (Tag tag : tags) {
            if (tag.getType() == 1) {
                if (!Bytes.equals((byte[])tag.getValue(), (byte[])metaValue1)) continue;
                meta1Ok = true;
                continue;
            }
            if (!Bytes.equals((byte[])tag.getValue(), (byte[])metaValue2)) continue;
            meta2Ok = true;
        }
        TestKeyValue.assertTrue((boolean)meta1Ok);
        TestKeyValue.assertTrue((boolean)meta2Ok);
        Iterator tagItr = CellUtil.tagsIterator((byte[])kv.getTagsArray(), (int)kv.getTagsOffset(), (int)kv.getTagsLength());
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        Tag next = (Tag)tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)1, (byte)next.getType());
        Bytes.equals((byte[])next.getValue(), (byte[])metaValue1);
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        next = (Tag)tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)2, (byte)next.getType());
        Bytes.equals((byte[])next.getValue(), (byte[])metaValue2);
        TestKeyValue.assertFalse((boolean)tagItr.hasNext());
        tagItr = CellUtil.tagsIterator((byte[])kv.getTagsArray(), (int)kv.getTagsOffset(), (int)kv.getTagsLength());
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        next = (Tag)tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)1, (byte)next.getType());
        Bytes.equals((byte[])next.getValue(), (byte[])metaValue1);
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        next = (Tag)tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)2, (byte)next.getType());
        Bytes.equals((byte[])next.getValue(), (byte[])metaValue2);
        TestKeyValue.assertFalse((boolean)tagItr.hasNext());
    }

    public void testMetaKeyComparator() {
        KeyValue b;
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes((String)"table1"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)(b = new KeyValue(Bytes.toBytes((String)"table2"), now))) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table1,111"), now);
        b = new KeyValue(Bytes.toBytes((String)"table2"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table1"), now);
        b = new KeyValue(Bytes.toBytes((String)"table2,111"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,2222"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,aaaa"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,2222"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,2222.bbb"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,,aaaa"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,bbb"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,aaaa"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,bbb"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,xxxx"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,222,bbb"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,11,xxx"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,222,bbb"), now);
        TestKeyValue.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
    }
}

