/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FairSchedulerConfiguration
extends Configuration {
    public static final Log LOG = LogFactory.getLog((String)FairSchedulerConfiguration.class.getName());
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_MB = "yarn.scheduler.increment-allocation-mb";
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_MB = 1024;
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = "yarn.scheduler.increment-allocation-vcores";
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = 1;
    public static final String RM_SCHEDULER_RESERVATION_THRESHOLD_INCREMENT_MULTIPLE = "yarn.scheduler.reservation-threshold.increment-multiple";
    public static final float DEFAULT_RM_SCHEDULER_RESERVATION_THRESHOLD_INCREMENT_MULTIPLE = 2.0f;
    private static final String CONF_PREFIX = "yarn.scheduler.fair.";
    public static final String ALLOCATION_FILE = "yarn.scheduler.fair.allocation.file";
    protected static final String DEFAULT_ALLOCATION_FILE = "fair-scheduler.xml";
    protected static final String ALLOW_UNDECLARED_POOLS = "yarn.scheduler.fair.allow-undeclared-pools";
    protected static final boolean DEFAULT_ALLOW_UNDECLARED_POOLS = true;
    protected static final String USER_AS_DEFAULT_QUEUE = "yarn.scheduler.fair.user-as-default-queue";
    protected static final boolean DEFAULT_USER_AS_DEFAULT_QUEUE = true;
    protected static final float DEFAULT_LOCALITY_THRESHOLD = -1.0f;
    protected static final String LOCALITY_THRESHOLD_NODE = "yarn.scheduler.fair.locality.threshold.node";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_NODE = -1.0f;
    protected static final String LOCALITY_THRESHOLD_RACK = "yarn.scheduler.fair.locality.threshold.rack";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_RACK = -1.0f;
    protected static final String LOCALITY_DELAY_NODE_MS = "yarn.scheduler.fair.locality-delay-node-ms";
    protected static final long DEFAULT_LOCALITY_DELAY_NODE_MS = -1L;
    protected static final String LOCALITY_DELAY_RACK_MS = "yarn.scheduler.fair.locality-delay-rack-ms";
    protected static final long DEFAULT_LOCALITY_DELAY_RACK_MS = -1L;
    protected static final String CONTINUOUS_SCHEDULING_ENABLED = "yarn.scheduler.fair.continuous-scheduling-enabled";
    protected static final boolean DEFAULT_CONTINUOUS_SCHEDULING_ENABLED = false;
    protected static final String CONTINUOUS_SCHEDULING_SLEEP_MS = "yarn.scheduler.fair.continuous-scheduling-sleep-ms";
    protected static final int DEFAULT_CONTINUOUS_SCHEDULING_SLEEP_MS = 5;
    protected static final String PREEMPTION = "yarn.scheduler.fair.preemption";
    protected static final boolean DEFAULT_PREEMPTION = false;
    protected static final String PREEMPTION_THRESHOLD = "yarn.scheduler.fair.preemption.cluster-utilization-threshold";
    protected static final float DEFAULT_PREEMPTION_THRESHOLD = 0.8f;
    protected static final String WAIT_TIME_BEFORE_KILL = "yarn.scheduler.fair.waitTimeBeforeKill";
    protected static final int DEFAULT_WAIT_TIME_BEFORE_KILL = 15000;
    protected static final String WAIT_TIME_BEFORE_NEXT_STARVATION_CHECK_MS = "yarn.scheduler.fair.waitTimeBeforeNextStarvationCheck";
    protected static final long DEFAULT_WAIT_TIME_BEFORE_NEXT_STARVATION_CHECK_MS = 10000L;
    public static final String ASSIGN_MULTIPLE = "yarn.scheduler.fair.assignmultiple";
    protected static final boolean DEFAULT_ASSIGN_MULTIPLE = false;
    protected static final String SIZE_BASED_WEIGHT = "yarn.scheduler.fair.sizebasedweight";
    protected static final boolean DEFAULT_SIZE_BASED_WEIGHT = false;
    public static final String DYNAMIC_MAX_ASSIGN = "yarn.scheduler.fair.dynamic.max.assign";
    private static final boolean DEFAULT_DYNAMIC_MAX_ASSIGN = true;
    protected static final String MAX_ASSIGN = "yarn.scheduler.fair.max.assign";
    protected static final int DEFAULT_MAX_ASSIGN = -1;
    public static final String UPDATE_INTERVAL_MS = "yarn.scheduler.fair.update-interval-ms";
    public static final int DEFAULT_UPDATE_INTERVAL_MS = 500;
    public static final String RESERVABLE_NODES = "yarn.scheduler.fair.reservable-nodes";
    public static final float RESERVABLE_NODES_DEFAULT = 0.05f;

    public FairSchedulerConfiguration() {
    }

    public FairSchedulerConfiguration(Configuration conf) {
        super(conf);
    }

    public Resource getMinimumAllocation() {
        int mem = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int cpu = this.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        return Resources.createResource((int)mem, (int)cpu);
    }

    public Resource getMaximumAllocation() {
        int mem = this.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        int cpu = this.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        return Resources.createResource((int)mem, (int)cpu);
    }

    public Resource getIncrementAllocation() {
        int incrementMemory = this.getInt(RM_SCHEDULER_INCREMENT_ALLOCATION_MB, 1024);
        int incrementCores = this.getInt(RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES, 1);
        return Resources.createResource((int)incrementMemory, (int)incrementCores);
    }

    public float getReservationThresholdIncrementMultiple() {
        return this.getFloat(RM_SCHEDULER_RESERVATION_THRESHOLD_INCREMENT_MULTIPLE, 2.0f);
    }

    public float getLocalityThresholdNode() {
        return this.getFloat(LOCALITY_THRESHOLD_NODE, -1.0f);
    }

    public float getLocalityThresholdRack() {
        return this.getFloat(LOCALITY_THRESHOLD_RACK, -1.0f);
    }

    public boolean isContinuousSchedulingEnabled() {
        return this.getBoolean(CONTINUOUS_SCHEDULING_ENABLED, false);
    }

    public int getContinuousSchedulingSleepMs() {
        return this.getInt(CONTINUOUS_SCHEDULING_SLEEP_MS, 5);
    }

    public long getLocalityDelayNodeMs() {
        return this.getLong(LOCALITY_DELAY_NODE_MS, -1L);
    }

    public long getLocalityDelayRackMs() {
        return this.getLong(LOCALITY_DELAY_RACK_MS, -1L);
    }

    public boolean getPreemptionEnabled() {
        return this.getBoolean(PREEMPTION, false);
    }

    public float getPreemptionUtilizationThreshold() {
        return this.getFloat(PREEMPTION_THRESHOLD, 0.8f);
    }

    public boolean getAssignMultiple() {
        return this.getBoolean(ASSIGN_MULTIPLE, false);
    }

    public boolean isMaxAssignDynamic() {
        return this.getBoolean(DYNAMIC_MAX_ASSIGN, true);
    }

    public int getMaxAssign() {
        return this.getInt(MAX_ASSIGN, -1);
    }

    public boolean getSizeBasedWeight() {
        return this.getBoolean(SIZE_BASED_WEIGHT, false);
    }

    public long getWaitTimeBeforeNextStarvationCheck() {
        return this.getLong(WAIT_TIME_BEFORE_NEXT_STARVATION_CHECK_MS, 10000L);
    }

    public int getWaitTimeBeforeKill() {
        return this.getInt(WAIT_TIME_BEFORE_KILL, 15000);
    }

    public boolean getUsePortForNodeName() {
        return this.getBoolean("yarn.scheduler.include-port-in-node-name", false);
    }

    public float getReservableNodes() {
        return this.getFloat(RESERVABLE_NODES, 0.05f);
    }

    public static ConfigurableResource parseResourceConfigValue(String val) throws AllocationConfigurationException {
        ConfigurableResource configurableResource;
        try {
            val = StringUtils.toLowerCase((String)val);
            if (val.contains("%")) {
                configurableResource = new ConfigurableResource(FairSchedulerConfiguration.getResourcePercentage(val));
            } else {
                int memory = FairSchedulerConfiguration.findResource(val, "mb");
                int vcores = FairSchedulerConfiguration.findResource(val, "vcores");
                configurableResource = new ConfigurableResource(BuilderUtils.newResource((long)memory, (int)vcores));
            }
        }
        catch (AllocationConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AllocationConfigurationException("Error reading resource config", ex);
        }
        return configurableResource;
    }

    private static double[] getResourcePercentage(String val) throws AllocationConfigurationException {
        double[] resourcePercentage = new double[ResourceType.values().length];
        String[] strings = val.split(",");
        if (strings.length == 1) {
            double percentage = FairSchedulerConfiguration.findPercentage(strings[0], "");
            for (int i = 0; i < ResourceType.values().length; ++i) {
                resourcePercentage[i] = percentage / 100.0;
            }
        } else {
            resourcePercentage[0] = FairSchedulerConfiguration.findPercentage(val, "memory") / 100.0;
            resourcePercentage[1] = FairSchedulerConfiguration.findPercentage(val, "cpu") / 100.0;
        }
        return resourcePercentage;
    }

    private static double findPercentage(String val, String units) throws AllocationConfigurationException {
        Pattern pattern = Pattern.compile("((\\d+)(\\.\\d*)?)\\s*%\\s*" + units);
        Matcher matcher = pattern.matcher(val);
        if (!matcher.find()) {
            if (units.equals("")) {
                throw new AllocationConfigurationException("Invalid percentage: " + val);
            }
            throw new AllocationConfigurationException("Missing resource: " + units);
        }
        return Double.parseDouble(matcher.group(1));
    }

    public long getUpdateInterval() {
        return this.getLong(UPDATE_INTERVAL_MS, 500L);
    }

    private static int findResource(String val, String units) throws AllocationConfigurationException {
        Pattern pattern = Pattern.compile("(\\d+)(\\.\\d*)?\\s*" + units);
        Matcher matcher = pattern.matcher(val);
        if (!matcher.find()) {
            throw new AllocationConfigurationException("Missing resource: " + units);
        }
        return Integer.parseInt(matcher.group(1));
    }
}

