/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.AppAttemptBlock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class RMAppAttemptBlock
extends AppAttemptBlock {
    private final ResourceManager rm;
    protected Configuration conf;

    @Inject
    RMAppAttemptBlock(View.ViewContext ctx, ResourceManager rm, Configuration conf) {
        super((ApplicationBaseProtocol)rm.getClientRMService(), ctx);
        this.rm = rm;
        this.conf = conf;
    }

    private void createResourceRequestsTable(HtmlBlock.Block html) {
        AppInfo app = new AppInfo(this.rm, (RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId()), true, WebAppUtils.getHttpSchemePrefix((Configuration)this.conf));
        List<ResourceRequest> resourceRequests = app.getResourceRequests();
        if (resourceRequests == null || resourceRequests.isEmpty()) {
            return;
        }
        Hamlet.DIV div = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.h3("Total Outstanding Resource Requests: " + this.getTotalResource(resourceRequests)).table("#ResourceRequests");
        table.tr().th(".ui-state-default", "Priority").th(".ui-state-default", "ResourceName").th(".ui-state-default", "Capability").th(".ui-state-default", "NumContainers").th(".ui-state-default", "RelaxLocality").th(".ui-state-default", "NodeLabelExpression")._();
        boolean odd = false;
        for (ResourceRequest request : resourceRequests) {
            if (request.getNumContainers() == 0) continue;
            odd = !odd;
            table.tr(odd ? ".odd" : ".even").td(String.valueOf(request.getPriority())).td(request.getResourceName()).td(String.valueOf(request.getCapability())).td(String.valueOf(request.getNumContainers())).td(String.valueOf(request.getRelaxLocality())).td(request.getNodeLabelExpression() == null ? "N/A" : request.getNodeLabelExpression())._();
        }
        table._();
        div._();
    }

    private Resource getTotalResource(List<ResourceRequest> requests) {
        Resource totalResource = Resource.newInstance((int)0, (int)0);
        if (requests == null) {
            return totalResource;
        }
        for (ResourceRequest request : requests) {
            if (request.getNumContainers() == 0 || !request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)totalResource, (Resource)Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers()));
        }
        return totalResource;
    }

    private void createContainerLocalityTable(HtmlBlock.Block html) {
        RMAppAttemptMetrics attemptMetrics = null;
        RMAppAttempt attempt = this.getRMAppAttempt();
        if (attempt != null) {
            attemptMetrics = attempt.getRMAppAttemptMetrics();
        }
        if (attemptMetrics == null) {
            return;
        }
        Hamlet.DIV div = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.h3("Total Allocated Containers: " + attemptMetrics.getTotalAllocatedContainers()).h3("Each table cell represents the number of NodeLocal/RackLocal/OffSwitch containers satisfied by NodeLocal/RackLocal/OffSwitch resource requests.").table("#containerLocality");
        table.tr().th(".ui-state-default", "").th(".ui-state-default", "Node Local Request").th(".ui-state-default", "Rack Local Request").th(".ui-state-default", "Off Switch Request")._();
        String[] containersType = new String[]{"Num Node Local Containers (satisfied by)", "Num Rack Local Containers (satisfied by)", "Num Off Switch Containers (satisfied by)"};
        boolean odd = false;
        for (int i = 0; i < attemptMetrics.getLocalityStatistics().length; ++i) {
            odd = !odd;
            table.tr(odd ? ".odd" : ".even").td(containersType[i]).td(String.valueOf(attemptMetrics.getLocalityStatistics()[i][0])).td(i == 0 ? "" : String.valueOf(attemptMetrics.getLocalityStatistics()[i][1])).td(i <= 1 ? "" : String.valueOf(attemptMetrics.getLocalityStatistics()[i][2]))._();
        }
        table._();
        div._();
    }

    private boolean isApplicationInFinalState(YarnApplicationAttemptState state) {
        return state == YarnApplicationAttemptState.FINISHED || state == YarnApplicationAttemptState.FAILED || state == YarnApplicationAttemptState.KILLED;
    }

    protected void createAttemptHeadRoomTable(HtmlBlock.Block html) {
        RMAppAttempt attempt = this.getRMAppAttempt();
        if (attempt != null && !this.isApplicationInFinalState(YarnApplicationAttemptState.valueOf((String)attempt.getAppAttemptState().toString()))) {
            RMAppAttemptMetrics metrics = attempt.getRMAppAttemptMetrics();
            Hamlet.DIV pdiv = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
            this.info("Application Attempt Overview").clear();
            this.info("Application Attempt Metrics")._("Application Attempt Headroom : ", (Object)(metrics == null ? "N/A" : metrics.getApplicationAttemptHeadroom()));
            pdiv._();
        }
    }

    private RMAppAttempt getRMAppAttempt() {
        ApplicationId appId = this.appAttemptId.getApplicationId();
        RMAppAttempt attempt = null;
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(appId);
        if (rmApp != null) {
            attempt = rmApp.getAppAttempts().get(this.appAttemptId);
        }
        return attempt;
    }

    protected void createTablesForAttemptMetrics(HtmlBlock.Block html) {
        this.createContainerLocalityTable(html);
        this.createResourceRequestsTable(html);
    }
}

