/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.VersionUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.utils.YarnServerBuilderUtils;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.YarnVersionInfo;

public class ResourceTrackerService
extends AbstractService
implements ResourceTracker {
    private static final Log LOG = LogFactory.getLog(ResourceTrackerService.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final RMContext rmContext;
    private final NodesListManager nodesListManager;
    private final NMLivelinessMonitor nmLivelinessMonitor;
    private final RMContainerTokenSecretManager containerTokenSecretManager;
    private final NMTokenSecretManagerInRM nmTokenSecretManager;
    private long nextHeartBeatInterval;
    private Server server;
    private InetSocketAddress resourceTrackerAddress;
    private String minimumNodeManagerVersion;
    private static final NodeHeartbeatResponse resync = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
    private static final NodeHeartbeatResponse shutDown = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
    private int minAllocMb;
    private int minAllocVcores;

    public ResourceTrackerService(RMContext rmContext, NodesListManager nodesListManager, NMLivelinessMonitor nmLivelinessMonitor, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager) {
        super(ResourceTrackerService.class.getName());
        this.rmContext = rmContext;
        this.nodesListManager = nodesListManager;
        this.nmLivelinessMonitor = nmLivelinessMonitor;
        this.containerTokenSecretManager = containerTokenSecretManager;
        this.nmTokenSecretManager = nmTokenSecretManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        RackResolver.init((Configuration)conf);
        this.nextHeartBeatInterval = conf.getLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1000L);
        if (this.nextHeartBeatInterval <= 0L) {
            throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.nodemanagers.heartbeat-interval-ms should be larger than 0.");
        }
        this.minAllocMb = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        this.minAllocVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        this.minimumNodeManagerVersion = conf.get("yarn.resourcemanager.nodemanager.minimum.version", "NONE");
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ResourceTracker.class, (Object)this, this.resourceTrackerAddress, conf, null, conf.getInt("yarn.resourcemanager.resource-tracker.client.thread-count", 50));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.server.start();
        conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", this.server.getListenerAddress());
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    void handleNMContainerStatus(NMContainerStatus containerStatus, NodeId nodeId) {
        ApplicationAttemptId appAttemptId = containerStatus.getContainerId().getApplicationAttemptId();
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId());
        if (rmApp == null) {
            LOG.error((Object)("Received finished container : " + containerStatus.getContainerId() + " for unknown application " + appAttemptId.getApplicationId() + " Skipping."));
            return;
        }
        if (rmApp.getApplicationSubmissionContext().getUnmanagedAM()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring container completion status for unmanaged AM " + rmApp.getApplicationId()));
            }
            return;
        }
        RMAppAttempt rmAppAttempt = rmApp.getRMAppAttempt(appAttemptId);
        Container masterContainer = rmAppAttempt.getMasterContainer();
        if (masterContainer.getId().equals((Object)containerStatus.getContainerId()) && containerStatus.getContainerState() == ContainerState.COMPLETE) {
            ContainerStatus status = ContainerStatus.newInstance((ContainerId)containerStatus.getContainerId(), (ContainerState)containerStatus.getContainerState(), (String)containerStatus.getDiagnostics(), (int)containerStatus.getContainerExitStatus());
            RMAppAttemptContainerFinishedEvent evt = new RMAppAttemptContainerFinishedEvent(appAttemptId, status, nodeId);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)evt);
        }
    }

    public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnException, IOException {
        NodeId nodeId = request.getNodeId();
        String host = nodeId.getHost();
        int cmPort = nodeId.getPort();
        int httpPort = request.getHttpPort();
        Resource capability = request.getResource();
        String nodeManagerVersion = request.getNMVersion();
        RegisterNodeManagerResponse response = (RegisterNodeManagerResponse)recordFactory.newRecordInstance(RegisterNodeManagerResponse.class);
        if (!this.minimumNodeManagerVersion.equals("NONE")) {
            if (this.minimumNodeManagerVersion.equals("EqualToRM")) {
                this.minimumNodeManagerVersion = YarnVersionInfo.getVersion();
            }
            if (nodeManagerVersion == null || VersionUtil.compareVersions((String)nodeManagerVersion, (String)this.minimumNodeManagerVersion) < 0) {
                String message = "Disallowed NodeManager Version " + nodeManagerVersion + ", is less than the minimum version " + this.minimumNodeManagerVersion + " sending SHUTDOWN signal to " + "NodeManager.";
                LOG.info((Object)message);
                response.setDiagnosticsMessage(message);
                response.setNodeAction(NodeAction.SHUTDOWN);
                return response;
            }
        }
        if (!this.nodesListManager.isValidNode(host)) {
            String message = "Disallowed NodeManager from  " + host + ", Sending SHUTDOWN signal to the NodeManager.";
            LOG.info((Object)message);
            response.setDiagnosticsMessage(message);
            response.setNodeAction(NodeAction.SHUTDOWN);
            return response;
        }
        if (capability.getMemory() < this.minAllocMb || capability.getVirtualCores() < this.minAllocVcores) {
            String message = "NodeManager from  " + host + " doesn't satisfy minimum allocations, Sending SHUTDOWN" + " signal to the NodeManager.";
            LOG.info((Object)message);
            response.setDiagnosticsMessage(message);
            response.setNodeAction(NodeAction.SHUTDOWN);
            return response;
        }
        response.setContainerTokenMasterKey(this.containerTokenSecretManager.getCurrentKey());
        response.setNMTokenMasterKey(this.nmTokenSecretManager.getCurrentKey());
        RMNodeImpl rmNode = new RMNodeImpl(nodeId, this.rmContext, host, cmPort, httpPort, ResourceTrackerService.resolve(host), capability, nodeManagerVersion);
        RMNode oldNode = this.rmContext.getRMNodes().putIfAbsent(nodeId, rmNode);
        if (oldNode == null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeStartedEvent(nodeId, request.getNMContainerStatuses(), request.getRunningApplications()));
        } else {
            LOG.info((Object)("Reconnect from the node at: " + host));
            this.nmLivelinessMonitor.unregister(nodeId);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeReconnectEvent(nodeId, rmNode, request.getRunningApplications(), request.getNMContainerStatuses()));
        }
        this.nmTokenSecretManager.removeNodeKey(nodeId);
        this.nmLivelinessMonitor.register(nodeId);
        if (!this.rmContext.isWorkPreservingRecoveryEnabled() && !request.getNMContainerStatuses().isEmpty()) {
            LOG.info((Object)("received container statuses on node manager register :" + request.getNMContainerStatuses()));
            for (NMContainerStatus status : request.getNMContainerStatuses()) {
                this.handleNMContainerStatus(status, nodeId);
            }
        }
        String message = "NodeManager from node " + host + "(cmPort: " + cmPort + " httpPort: " + httpPort + ") " + "registered with capability: " + capability + ", assigned nodeId " + nodeId;
        LOG.info((Object)message);
        response.setNodeAction(NodeAction.NORMAL);
        response.setRMIdentifier(ResourceManager.getClusterTimeStamp());
        response.setRMVersion(YarnVersionInfo.getVersion());
        return response;
    }

    public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnException, IOException {
        NodeStatus remoteNodeStatus = request.getNodeStatus();
        NodeId nodeId = remoteNodeStatus.getNodeId();
        if (!this.nodesListManager.isValidNode(nodeId.getHost())) {
            String message = "Disallowed NodeManager nodeId: " + nodeId + " hostname: " + nodeId.getHost();
            LOG.info((Object)message);
            shutDown.setDiagnosticsMessage(message);
            return shutDown;
        }
        RMNode rmNode = (RMNode)this.rmContext.getRMNodes().get(nodeId);
        if (rmNode == null) {
            String message = "Node not found resyncing " + remoteNodeStatus.getNodeId();
            LOG.info((Object)message);
            resync.setDiagnosticsMessage(message);
            return resync;
        }
        this.nmLivelinessMonitor.receivedPing(nodeId);
        NodeHeartbeatResponse lastNodeHeartbeatResponse = rmNode.getLastNodeHeartBeatResponse();
        if (remoteNodeStatus.getResponseId() + 1 == lastNodeHeartbeatResponse.getResponseId()) {
            LOG.info((Object)("Received duplicate heartbeat from node " + rmNode.getNodeAddress() + " responseId=" + remoteNodeStatus.getResponseId()));
            return lastNodeHeartbeatResponse;
        }
        if (remoteNodeStatus.getResponseId() + 1 < lastNodeHeartbeatResponse.getResponseId()) {
            String message = "Too far behind rm response id:" + lastNodeHeartbeatResponse.getResponseId() + " nm response id:" + remoteNodeStatus.getResponseId();
            LOG.info((Object)message);
            resync.setDiagnosticsMessage(message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.REBOOTING));
            return resync;
        }
        NodeHeartbeatResponse nodeHeartBeatResponse = YarnServerBuilderUtils.newNodeHeartbeatResponse((int)(lastNodeHeartbeatResponse.getResponseId() + 1), (NodeAction)NodeAction.NORMAL, null, null, null, null, (long)this.nextHeartBeatInterval);
        rmNode.updateNodeHeartbeatResponseForCleanup(nodeHeartBeatResponse);
        this.populateKeys(request, nodeHeartBeatResponse);
        ConcurrentMap<ApplicationId, ByteBuffer> systemCredentials = this.rmContext.getSystemCredentialsForApps();
        if (!systemCredentials.isEmpty()) {
            nodeHeartBeatResponse.setSystemCredentialsForApps(systemCredentials);
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeStatusEvent(nodeId, remoteNodeStatus.getNodeHealthStatus(), remoteNodeStatus.getContainersStatuses(), remoteNodeStatus.getKeepAliveApplications(), nodeHeartBeatResponse));
        return nodeHeartBeatResponse;
    }

    private void populateKeys(NodeHeartbeatRequest request, NodeHeartbeatResponse nodeHeartBeatResponse) {
        MasterKey nextMasterKeyForNode = this.containerTokenSecretManager.getNextKey();
        if (nextMasterKeyForNode != null && request.getLastKnownContainerTokenMasterKey().getKeyId() != nextMasterKeyForNode.getKeyId()) {
            nodeHeartBeatResponse.setContainerTokenMasterKey(nextMasterKeyForNode);
        }
        if ((nextMasterKeyForNode = this.nmTokenSecretManager.getNextKey()) != null && request.getLastKnownNMTokenMasterKey().getKeyId() != nextMasterKeyForNode.getKeyId()) {
            nodeHeartBeatResponse.setNMTokenMasterKey(nextMasterKeyForNode);
        }
    }

    public static Node resolve(String hostName) {
        return RackResolver.resolve((String)hostName);
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    static {
        resync.setNodeAction(NodeAction.RESYNC);
        shutDown.setNodeAction(NodeAction.SHUTDOWN);
    }
}

