/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DefaultLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.JavaSandboxLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingLinuxContainerRuntime.class);
    private DefaultLinuxContainerRuntime defaultLinuxContainerRuntime;
    private DockerLinuxContainerRuntime dockerLinuxContainerRuntime;
    private JavaSandboxLinuxContainerRuntime javaSandboxLinuxContainerRuntime;
    private EnumSet<LinuxContainerRuntimeConstants.RuntimeType> allowedRuntimes = EnumSet.noneOf(LinuxContainerRuntimeConstants.RuntimeType.class);

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        String[] configuredRuntimes;
        for (String configuredRuntime : configuredRuntimes = conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.allowed-runtimes", YarnConfiguration.DEFAULT_LINUX_CONTAINER_RUNTIME_ALLOWED_RUNTIMES)) {
            try {
                this.allowedRuntimes.add(LinuxContainerRuntimeConstants.RuntimeType.valueOf(configuredRuntime.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new ContainerExecutionException("Invalid runtime set in yarn.nodemanager.runtime.linux.allowed-runtimes : " + configuredRuntime);
            }
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.JAVASANDBOX)) {
            this.javaSandboxLinuxContainerRuntime = new JavaSandboxLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.javaSandboxLinuxContainerRuntime.initialize(conf);
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DOCKER)) {
            this.dockerLinuxContainerRuntime = new DockerLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.dockerLinuxContainerRuntime.initialize(conf);
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DEFAULT)) {
            this.defaultLinuxContainerRuntime = new DefaultLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.defaultLinuxContainerRuntime.initialize(conf);
        }
    }

    @Override
    public boolean useWhitelistEnv(Map<String, String> env) {
        try {
            LinuxContainerRuntime runtime = this.pickContainerRuntime(env);
            return runtime.useWhitelistEnv(env);
        }
        catch (ContainerExecutionException e) {
            LOG.debug("Unable to determine runtime");
            return false;
        }
    }

    @VisibleForTesting
    LinuxContainerRuntime pickContainerRuntime(Map<String, String> environment) throws ContainerExecutionException {
        LinuxContainerRuntime runtime;
        if (this.javaSandboxLinuxContainerRuntime != null && this.javaSandboxLinuxContainerRuntime.isSandboxContainerRequested()) {
            runtime = this.javaSandboxLinuxContainerRuntime;
        } else if (this.dockerLinuxContainerRuntime != null && DockerLinuxContainerRuntime.isDockerContainerRequested(environment)) {
            runtime = this.dockerLinuxContainerRuntime;
        } else if (this.defaultLinuxContainerRuntime != null && !DockerLinuxContainerRuntime.isDockerContainerRequested(environment)) {
            runtime = this.defaultLinuxContainerRuntime;
        } else {
            throw new ContainerExecutionException("Requested runtime not allowed.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using container runtime: " + runtime.getClass().getSimpleName());
        }
        return runtime;
    }

    private LinuxContainerRuntime pickContainerRuntime(Container container) throws ContainerExecutionException {
        return this.pickContainerRuntime(container.getLaunchContext().getEnvironment());
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        LinuxContainerRuntime runtime = this.pickContainerRuntime(ctx.getContainer());
        runtime.prepareContainer(ctx);
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.launchContainer(ctx);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.signalContainer(ctx);
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.reapContainer(ctx);
    }

    @Override
    public String[] getIpAndHost(Container container) throws ContainerExecutionException {
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        return runtime.getIpAndHost(container);
    }

    @VisibleForTesting
    boolean isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType runtimeType) {
        return this.allowedRuntimes.contains((Object)runtimeType);
    }
}

