/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.DirectoryCollection;

public class LocalDirsHandlerService
extends AbstractService {
    private static Log LOG = LogFactory.getLog(LocalDirsHandlerService.class);
    private Timer dirsHandlerScheduler;
    private long diskHealthCheckInterval;
    private boolean isDiskHealthCheckerEnabled;
    private float minNeededHealthyDisksFactor;
    private MonitoringTimerTask monitoringTimerTask;
    private DirectoryCollection localDirs = null;
    private DirectoryCollection logDirs = null;
    private LocalDirAllocator localDirsAllocator;
    private LocalDirAllocator logDirsAllocator;
    private long lastDisksCheckTime;
    private static String FILE_SCHEME = "file";

    public LocalDirsHandlerService() {
        super(LocalDirsHandlerService.class.getName());
    }

    protected void serviceInit(Configuration config) throws Exception {
        FileContext localFs;
        Configuration conf = new Configuration(config);
        this.diskHealthCheckInterval = conf.getLong("yarn.nodemanager.disk-health-checker.interval-ms", 120000L);
        this.monitoringTimerTask = new MonitoringTimerTask(conf);
        this.isDiskHealthCheckerEnabled = conf.getBoolean("yarn.nodemanager.disk-health-checker.enable", true);
        this.minNeededHealthyDisksFactor = conf.getFloat("yarn.nodemanager.disk-health-checker.min-healthy-disks", 0.25f);
        this.lastDisksCheckTime = System.currentTimeMillis();
        super.serviceInit(conf);
        try {
            localFs = FileContext.getLocalFSFileContext((Configuration)config);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Unable to get the local filesystem", (Throwable)e);
        }
        FsPermission perm = new FsPermission(493);
        boolean createSucceeded = this.localDirs.createNonExistentDirs(localFs, perm);
        if (!(createSucceeded &= this.logDirs.createNonExistentDirs(localFs, perm))) {
            this.updateDirsAfterTest();
        }
        this.checkDirs();
    }

    protected void serviceStart() throws Exception {
        if (this.isDiskHealthCheckerEnabled) {
            this.dirsHandlerScheduler = new Timer("DiskHealthMonitor-Timer", true);
            this.dirsHandlerScheduler.scheduleAtFixedRate((TimerTask)this.monitoringTimerTask, this.diskHealthCheckInterval, this.diskHealthCheckInterval);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.dirsHandlerScheduler != null) {
            this.dirsHandlerScheduler.cancel();
        }
        super.serviceStop();
    }

    public List<String> getLocalDirs() {
        return this.localDirs.getGoodDirs();
    }

    public List<String> getLogDirs() {
        return this.logDirs.getGoodDirs();
    }

    public List<String> getDiskFullLocalDirs() {
        return this.localDirs.getFullDirs();
    }

    public List<String> getDiskFullLogDirs() {
        return this.logDirs.getFullDirs();
    }

    public List<String> getLocalDirsForRead() {
        return DirectoryCollection.concat(this.localDirs.getGoodDirs(), this.localDirs.getFullDirs());
    }

    public List<String> getLocalDirsForCleanup() {
        return DirectoryCollection.concat(this.localDirs.getGoodDirs(), this.localDirs.getFullDirs());
    }

    public List<String> getLogDirsForRead() {
        return DirectoryCollection.concat(this.logDirs.getGoodDirs(), this.logDirs.getFullDirs());
    }

    public List<String> getLogDirsForCleanup() {
        return DirectoryCollection.concat(this.logDirs.getGoodDirs(), this.logDirs.getFullDirs());
    }

    public String getDisksHealthReport(boolean listGoodDirs) {
        if (!this.isDiskHealthCheckerEnabled) {
            return "";
        }
        StringBuilder report = new StringBuilder();
        List<String> failedLocalDirsList = this.localDirs.getFailedDirs();
        List<String> failedLogDirsList = this.logDirs.getFailedDirs();
        List<String> goodLocalDirsList = this.localDirs.getGoodDirs();
        List<String> goodLogDirsList = this.logDirs.getGoodDirs();
        int numLocalDirs = goodLocalDirsList.size() + failedLocalDirsList.size();
        int numLogDirs = goodLogDirsList.size() + failedLogDirsList.size();
        if (!listGoodDirs) {
            if (!failedLocalDirsList.isEmpty()) {
                report.append(failedLocalDirsList.size() + "/" + numLocalDirs + " local-dirs are bad: " + StringUtils.join((CharSequence)",", failedLocalDirsList) + "; ");
            }
            if (!failedLogDirsList.isEmpty()) {
                report.append(failedLogDirsList.size() + "/" + numLogDirs + " log-dirs are bad: " + StringUtils.join((CharSequence)",", failedLogDirsList));
            }
        } else {
            report.append(goodLocalDirsList.size() + "/" + numLocalDirs + " local-dirs are good: " + StringUtils.join((CharSequence)",", goodLocalDirsList) + "; ");
            report.append(goodLogDirsList.size() + "/" + numLogDirs + " log-dirs are good: " + StringUtils.join((CharSequence)",", goodLogDirsList));
        }
        return report.toString();
    }

    public boolean areDisksHealthy() {
        int failedDirs;
        int totalConfiguredDirs;
        if (!this.isDiskHealthCheckerEnabled) {
            return true;
        }
        int goodDirs = this.getLocalDirs().size();
        if ((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.localDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor) {
            return false;
        }
        goodDirs = this.getLogDirs().size();
        return !((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.logDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor);
    }

    public long getLastDisksCheckTime() {
        return this.lastDisksCheckTime;
    }

    private void updateDirsAfterTest() {
        Configuration conf = this.getConfig();
        List<String> localDirs = this.getLocalDirs();
        conf.setStrings("yarn.nodemanager.local-dirs", localDirs.toArray(new String[localDirs.size()]));
        List<String> logDirs = this.getLogDirs();
        conf.setStrings("yarn.nodemanager.log-dirs", logDirs.toArray(new String[logDirs.size()]));
        if (!this.areDisksHealthy()) {
            LOG.error((Object)("Most of the disks failed. " + this.getDisksHealthReport(false)));
        }
    }

    private void logDiskStatus(boolean newDiskFailure, boolean diskTurnedGood) {
        String report;
        if (newDiskFailure) {
            report = this.getDisksHealthReport(false);
            LOG.info((Object)("Disk(s) failed: " + report));
        }
        if (diskTurnedGood) {
            report = this.getDisksHealthReport(true);
            LOG.info((Object)("Disk(s) turned good: " + report));
        }
    }

    private void checkDirs() {
        boolean disksStatusChange = false;
        HashSet<String> failedLocalDirsPreCheck = new HashSet<String>(this.localDirs.getFailedDirs());
        HashSet<String> failedLogDirsPreCheck = new HashSet<String>(this.logDirs.getFailedDirs());
        if (this.localDirs.checkDirs()) {
            disksStatusChange = true;
        }
        if (this.logDirs.checkDirs()) {
            disksStatusChange = true;
        }
        HashSet<String> failedLocalDirsPostCheck = new HashSet<String>(this.localDirs.getFailedDirs());
        HashSet<String> failedLogDirsPostCheck = new HashSet<String>(this.logDirs.getFailedDirs());
        boolean disksFailed = false;
        boolean disksTurnedGood = false;
        disksFailed = this.disksTurnedBad(failedLocalDirsPreCheck, failedLocalDirsPostCheck);
        disksTurnedGood = this.disksTurnedGood(failedLocalDirsPreCheck, failedLocalDirsPostCheck);
        if (!disksFailed) {
            disksFailed = this.disksTurnedBad(failedLogDirsPreCheck, failedLogDirsPostCheck);
        }
        if (!disksTurnedGood) {
            disksTurnedGood = this.disksTurnedGood(failedLogDirsPreCheck, failedLogDirsPostCheck);
        }
        this.logDiskStatus(disksFailed, disksTurnedGood);
        if (disksStatusChange) {
            this.updateDirsAfterTest();
        }
        this.lastDisksCheckTime = System.currentTimeMillis();
    }

    private boolean disksTurnedBad(Set<String> preCheckFailedDirs, Set<String> postCheckDirs) {
        boolean disksFailed = false;
        for (String dir : postCheckDirs) {
            if (preCheckFailedDirs.contains(dir)) continue;
            disksFailed = true;
            break;
        }
        return disksFailed;
    }

    private boolean disksTurnedGood(Set<String> preCheckDirs, Set<String> postCheckDirs) {
        boolean disksTurnedGood = false;
        for (String dir : preCheckDirs) {
            if (postCheckDirs.contains(dir)) continue;
            disksTurnedGood = true;
            break;
        }
        return disksTurnedGood;
    }

    private Path getPathToRead(String pathStr, List<String> dirs) throws IOException {
        if (pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1);
        }
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.getConfig());
        for (String dir : dirs) {
            try {
                Path tmpDir = new Path(dir);
                File tmpFile = tmpDir.isAbsolute() ? new File(localFS.makeQualified(tmpDir).toUri()) : new File(dir);
                Path file = new Path(tmpFile.getPath(), pathStr);
                if (!localFS.exists(file)) continue;
                return file;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed to find " + pathStr + " at " + dir), (Throwable)ie);
            }
        }
        throw new IOException("Could not find " + pathStr + " in any of" + " the directories");
    }

    public Path getLocalPathForWrite(String pathStr) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, this.getConfig());
    }

    public Path getLocalPathForWrite(String pathStr, long size, boolean checkWrite) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, size, this.getConfig(), checkWrite);
    }

    public Path getLogPathForWrite(String pathStr, boolean checkWrite) throws IOException {
        return this.logDirsAllocator.getLocalPathForWrite(pathStr, -1L, this.getConfig(), checkWrite);
    }

    public Path getLogPathToRead(String pathStr) throws IOException {
        return this.getPathToRead(pathStr, this.getLogDirsForRead());
    }

    public static String[] validatePaths(String[] paths) {
        ArrayList<String> validPaths = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            try {
                URI uriPath = new Path(paths[i]).toUri();
                if (uriPath.getScheme() != null && !uriPath.getScheme().equals(FILE_SCHEME)) {
                    LOG.warn((Object)(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme"));
                    throw new YarnRuntimeException(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme");
                }
                validPaths.add(new Path(uriPath.getPath()).toString());
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)e.getMessage());
                throw new YarnRuntimeException(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme");
            }
        }
        String[] arrValidPaths = new String[validPaths.size()];
        validPaths.toArray(arrValidPaths);
        return arrValidPaths;
    }

    private final class MonitoringTimerTask
    extends TimerTask {
        public MonitoringTimerTask(Configuration conf) throws YarnRuntimeException {
            float maxUsableSpacePercentagePerDisk = conf.getFloat("yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage", 90.0f);
            long minFreeSpacePerDiskMB = conf.getLong("yarn.nodemanager.disk-health-checker.min-free-space-per-disk-mb", 0L);
            LocalDirsHandlerService.this.localDirs = new DirectoryCollection(LocalDirsHandlerService.validatePaths(conf.getTrimmedStrings("yarn.nodemanager.local-dirs")), maxUsableSpacePercentagePerDisk, minFreeSpacePerDiskMB);
            LocalDirsHandlerService.this.logDirs = new DirectoryCollection(LocalDirsHandlerService.validatePaths(conf.getTrimmedStrings("yarn.nodemanager.log-dirs")), maxUsableSpacePercentagePerDisk, minFreeSpacePerDiskMB);
            LocalDirsHandlerService.this.localDirsAllocator = new LocalDirAllocator("yarn.nodemanager.local-dirs");
            LocalDirsHandlerService.this.logDirsAllocator = new LocalDirAllocator("yarn.nodemanager.log-dirs");
        }

        @Override
        public void run() {
            LocalDirsHandlerService.this.checkDirs();
        }
    }
}

