/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import java.io.File;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.webapp.TestTimelineWebServicesWithSSL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTimelineWebServicesWithSSL {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestTimelineWebServicesWithSSL.class.getSimpleName();
    private static String keystoresDir;
    private static String sslConfDir;
    private static ApplicationHistoryServer timelineServer;
    private static TimelineStore store;
    private static Configuration conf;

    @BeforeClass
    public static void setupServer() throws Exception {
        conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
        conf.set("yarn.http.policy", "HTTPS_ONLY");
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestTimelineWebServicesWithSSL.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.addResource("ssl-server.xml");
        conf.addResource("ssl-client.xml");
        timelineServer = new ApplicationHistoryServer();
        timelineServer.init(conf);
        timelineServer.start();
        store = timelineServer.getTimelineStore();
    }

    @AfterClass
    public static void tearDownServer() throws Exception {
        if (timelineServer != null) {
            timelineServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutEntities() throws Exception {
        TestTimelineClient client = new TestTimelineClient(null);
        try {
            client.init(conf);
            client.start();
            TimelineEntity expectedEntity = new TimelineEntity();
            expectedEntity.setEntityType("test entity type");
            expectedEntity.setEntityId("test entity id");
            expectedEntity.setDomainId("test domain id");
            TimelineEvent event = new TimelineEvent();
            event.setEventType("test event type");
            event.setTimestamp(0L);
            expectedEntity.addEvent(event);
            TimelinePutResponse response = client.putEntities(new TimelineEntity[]{expectedEntity});
            Assert.assertEquals((long)0L, (long)response.getErrors().size());
            Assert.assertTrue((boolean)TestTimelineClient.access$100((TestTimelineClient)client).toString().contains("https"));
            TimelineEntity actualEntity = store.getEntity(expectedEntity.getEntityId(), expectedEntity.getEntityType(), EnumSet.allOf(TimelineReader.Field.class));
            Assert.assertNotNull((Object)actualEntity);
            Assert.assertEquals((Object)expectedEntity.getEntityId(), (Object)actualEntity.getEntityId());
            Assert.assertEquals((Object)expectedEntity.getEntityType(), (Object)actualEntity.getEntityType());
        }
        finally {
            client.stop();
            client.close();
        }
    }
}

