/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTimelineAuthenticationFilter {
    private static final String FOO_USER = "foo";
    private static final String BAR_USER = "bar";
    private static final String HTTP_USER = "HTTP";
    private static final File testRootDir = new File(System.getProperty("test.build.dir", "target/test-dir"), TestTimelineAuthenticationFilter.class.getName() + "-root");
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestTimelineAuthenticationFilter.class.getSimpleName();
    private MiniKdc testMiniKDC;
    private String keystoresDir;
    private String sslConfDir;
    private ApplicationHistoryServer testTimelineServer;
    private Configuration conf;
    private TimelineClient client;
    private boolean withSsl;

    @Parameterized.Parameters
    public static Collection<Object[]> withSsl() {
        return Arrays.asList({false}, {true});
    }

    public TestTimelineAuthenticationFilter(boolean withSsl) {
        this.withSsl = withSsl;
    }

    @Before
    public void setup() {
        try {
            this.testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            this.testMiniKDC.start();
            this.testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost"});
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't setup MiniKDC", (boolean)false);
        }
        try {
            this.testTimelineServer = new ApplicationHistoryServer();
            this.conf = new Configuration(false);
            this.conf.setStrings("yarn.timeline-service.http-authentication.type", new String[]{"kerberos"});
            this.conf.set("yarn.timeline-service.http-authentication.kerberos.principal", httpSpnegoPrincipal);
            this.conf.set("yarn.timeline-service.http-authentication.kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            this.conf.set("hadoop.security.authentication", "kerberos");
            this.conf.set("yarn.timeline-service.principal", httpSpnegoPrincipal);
            this.conf.set("yarn.timeline-service.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            this.conf.setBoolean("yarn.timeline-service.enabled", true);
            this.conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            this.conf.set("yarn.timeline-service.address", "localhost:10200");
            this.conf.set("yarn.timeline-service.webapp.address", "localhost:8188");
            this.conf.set("yarn.timeline-service.webapp.https.address", "localhost:8190");
            this.conf.set("hadoop.proxyuser.HTTP.hosts", "*");
            this.conf.set("hadoop.proxyuser.HTTP.users", FOO_USER);
            if (this.withSsl) {
                this.conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
                File base = new File(BASEDIR);
                FileUtil.fullyDelete((File)base);
                base.mkdirs();
                this.keystoresDir = new File(BASEDIR).getAbsolutePath();
                this.sslConfDir = KeyStoreTestUtil.getClasspathDir(TestTimelineAuthenticationFilter.class);
                KeyStoreTestUtil.setupSSLConfig((String)this.keystoresDir, (String)this.sslConfDir, (Configuration)this.conf, (boolean)false);
            }
            UserGroupInformation.setConfiguration((Configuration)this.conf);
            this.testTimelineServer.init(this.conf);
            this.testTimelineServer.start();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't setup TimelineServer", (boolean)false);
        }
        this.client = TimelineClient.createTimelineClient();
        this.client.init(this.conf);
        this.client.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.testMiniKDC != null) {
            this.testMiniKDC.stop();
        }
        if (this.testTimelineServer != null) {
            this.testTimelineServer.stop();
        }
        if (this.client != null) {
            this.client.stop();
        }
        if (this.withSsl) {
            KeyStoreTestUtil.cleanupSSLConfig((String)this.keystoresDir, (String)this.sslConfDir);
            File base = new File(BASEDIR);
            FileUtil.fullyDelete((File)base);
        }
    }

    @Test
    public void testPutTimelineEntities() throws Exception {
        KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testPutDomains() throws Exception {
        KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testDelegationTokenOperations() throws Exception {
        KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ TimelineClient access$000(TestTimelineAuthenticationFilter x0) {
        return x0.client;
    }

    static /* synthetic */ ApplicationHistoryServer access$100(TestTimelineAuthenticationFilter x0) {
        return x0.testTimelineServer;
    }
}

