/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilterInitializer;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationHistoryServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testStartStopServer() throws Exception {
        ApplicationHistoryServer historyServer = new ApplicationHistoryServer();
        YarnConfiguration config = new YarnConfiguration();
        config.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
        config.set("yarn.timeline-service.webapp.address", "localhost:0");
        try {
            historyServer.init((Configuration)config);
            Assert.assertEquals((Object)Service.STATE.INITED, (Object)historyServer.getServiceState());
            Assert.assertEquals((long)5L, (long)historyServer.getServices().size());
            ApplicationHistoryClientService historyService = historyServer.getClientService();
            Assert.assertNotNull((Object)historyServer.getClientService());
            Assert.assertEquals((Object)Service.STATE.INITED, (Object)historyService.getServiceState());
            historyServer.start();
            Assert.assertEquals((Object)Service.STATE.STARTED, (Object)historyServer.getServiceState());
            Assert.assertEquals((Object)Service.STATE.STARTED, (Object)historyService.getServiceState());
            historyServer.stop();
            Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)historyServer.getServiceState());
        }
        finally {
            historyServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLaunch() throws Exception {
        ExitUtil.disableSystemExit();
        ApplicationHistoryServer historyServer = null;
        try {
            historyServer = ApplicationHistoryServer.launchAppHistoryServer((String[])new String[0]);
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((long)0L, (long)e.status);
            ExitUtil.resetFirstExitException();
            Assert.fail();
        }
        finally {
            if (historyServer != null) {
                historyServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=240000L)
    public void testFilterOverrides() throws Exception {
        HashMap<String, String> driver = new HashMap<String, String>();
        driver.put("", TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(StaticUserWebFilter.class.getName(), TimelineAuthenticationFilterInitializer.class.getName() + "," + StaticUserWebFilter.class.getName());
        driver.put(AuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(TimelineAuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(AuthenticationFilterInitializer.class.getName() + "," + TimelineAuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(AuthenticationFilterInitializer.class.getName() + ", " + TimelineAuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        for (Map.Entry entry : driver.entrySet()) {
            String filterInitializer = (String)entry.getKey();
            String expectedValue = (String)entry.getValue();
            ApplicationHistoryServer historyServer = new ApplicationHistoryServer();
            YarnConfiguration config = new YarnConfiguration();
            config.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            config.set("yarn.timeline-service.webapp.address", "localhost:0");
            try {
                config.set("hadoop.http.filter.initializers", filterInitializer);
                historyServer.init((Configuration)config);
                historyServer.start();
                Configuration tmp = historyServer.getConfig();
                Assert.assertEquals((Object)expectedValue, (Object)tmp.get("hadoop.http.filter.initializers"));
            }
            finally {
                historyServer.stop();
            }
        }
    }
}

