/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplicationHistoryManagerOnTimelineStore
extends AbstractService
implements ApplicationHistoryManager {
    @VisibleForTesting
    static final String UNAVAILABLE = "N/A";
    private TimelineDataManager timelineDataManager;
    private ApplicationACLsManager aclsManager;
    private String serverHttpAddress;

    public ApplicationHistoryManagerOnTimelineStore(TimelineDataManager timelineDataManager, ApplicationACLsManager aclsManager) {
        super(ApplicationHistoryManagerOnTimelineStore.class.getName());
        this.timelineDataManager = timelineDataManager;
        this.aclsManager = aclsManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.serverHttpAddress = WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf);
        super.serviceInit(conf);
    }

    public ApplicationReport getApplication(ApplicationId appId) throws YarnException, IOException {
        return ApplicationReportExt.access$000((ApplicationReportExt)this.getApplication(appId, ApplicationReportField.ALL));
    }

    public Map<ApplicationId, ApplicationReport> getAllApplications() throws YarnException, IOException {
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_APPLICATION", null, null, null, null, null, null, Long.valueOf(Long.MAX_VALUE), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        HashMap<ApplicationId, ApplicationReport> apps = new HashMap<ApplicationId, ApplicationReport>();
        if (entities != null && entities.getEntities() != null) {
            for (TimelineEntity entity : entities.getEntities()) {
                ApplicationReportExt app = this.generateApplicationReport(entity, ApplicationReportField.ALL);
                apps.put(ApplicationReportExt.access$000((ApplicationReportExt)app).getApplicationId(), ApplicationReportExt.access$000((ApplicationReportExt)app));
            }
        }
        return apps;
    }

    public Map<ApplicationAttemptId, ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(appId, ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_APPLICATION_ATTEMPT", new NameValuePair("YARN_APPLICATION_ATTEMPT_PARENT", (Object)appId.toString()), null, null, null, null, null, Long.valueOf(Long.MAX_VALUE), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        HashMap<ApplicationAttemptId, ApplicationAttemptReport> appAttempts = new HashMap<ApplicationAttemptId, ApplicationAttemptReport>();
        for (TimelineEntity entity : entities.getEntities()) {
            ApplicationAttemptReport appAttempt = ApplicationHistoryManagerOnTimelineStore.convertToApplicationAttemptReport((TimelineEntity)entity);
            appAttempts.put(appAttempt.getApplicationAttemptId(), appAttempt);
        }
        return appAttempts;
    }

    public ApplicationAttemptReport getApplicationAttempt(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(appAttemptId.getApplicationId(), ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntity entity = this.timelineDataManager.getEntity("YARN_APPLICATION_ATTEMPT", appAttemptId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        if (entity == null) {
            throw new ApplicationAttemptNotFoundException("The entity for application attempt " + appAttemptId + " doesn't exist in the timeline store");
        }
        return ApplicationHistoryManagerOnTimelineStore.convertToApplicationAttemptReport((TimelineEntity)entity);
    }

    public ContainerReport getContainer(ContainerId containerId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(containerId.getApplicationAttemptId().getApplicationId(), ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntity entity = this.timelineDataManager.getEntity("YARN_CONTAINER", containerId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        if (entity == null) {
            throw new ContainerNotFoundException("The entity for container " + containerId + " doesn't exist in the timeline store");
        }
        return ApplicationHistoryManagerOnTimelineStore.convertToContainerReport((TimelineEntity)entity, (String)this.serverHttpAddress, (String)ApplicationReportExt.access$000((ApplicationReportExt)app).getUser());
    }

    public ContainerReport getAMContainer(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        ApplicationAttemptReport appAttempt = this.getApplicationAttempt(appAttemptId);
        return this.getContainer(appAttempt.getAMContainerId());
    }

    public Map<ContainerId, ContainerReport> getContainers(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(appAttemptId.getApplicationId(), ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_CONTAINER", new NameValuePair("YARN_CONTAINER_PARENT", (Object)appAttemptId.toString()), null, null, null, null, null, Long.valueOf(Long.MAX_VALUE), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        HashMap<ContainerId, ContainerReport> containers = new HashMap<ContainerId, ContainerReport>();
        if (entities != null && entities.getEntities() != null) {
            for (TimelineEntity entity : entities.getEntities()) {
                ContainerReport container = ApplicationHistoryManagerOnTimelineStore.convertToContainerReport((TimelineEntity)entity, (String)this.serverHttpAddress, (String)ApplicationReportExt.access$000((ApplicationReportExt)app).getUser());
                containers.put(container.getContainerId(), container);
            }
        }
        return containers;
    }

    private static ApplicationReportExt convertToApplicationReport(TimelineEntity entity, ApplicationReportField field) {
        List events;
        String user = null;
        String queue = null;
        String name = null;
        String type = null;
        long createdTime = 0L;
        long finishedTime = 0L;
        ApplicationAttemptId latestApplicationAttemptId = null;
        String diagnosticsInfo = null;
        FinalApplicationStatus finalStatus = FinalApplicationStatus.UNDEFINED;
        YarnApplicationState state = null;
        HashMap<ApplicationAccessType, String> appViewACLs = new HashMap<ApplicationAccessType, String>();
        Map entityInfo = entity.getOtherInfo();
        if (entityInfo != null) {
            String appViewACLsStr;
            if (entityInfo.containsKey("YARN_APPLICATION_USER")) {
                user = entityInfo.get("YARN_APPLICATION_USER").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_VIEW_ACLS") && (appViewACLsStr = entityInfo.get("YARN_APPLICATION_VIEW_ACLS").toString()).length() > 0) {
                appViewACLs.put(ApplicationAccessType.VIEW_APP, appViewACLsStr);
            }
            if (field == ApplicationReportField.USER_AND_ACLS) {
                return new ApplicationReportExt(ApplicationReport.newInstance((ApplicationId)ConverterUtils.toApplicationId((String)entity.getEntityId()), latestApplicationAttemptId, (String)user, (String)queue, (String)name, null, (int)-1, null, state, diagnosticsInfo, null, (long)createdTime, (long)finishedTime, (FinalApplicationStatus)finalStatus, null, null, (float)1.0f, (String)type, null), appViewACLs);
            }
            if (entityInfo.containsKey("YARN_APPLICATION_QUEUE")) {
                queue = entityInfo.get("YARN_APPLICATION_QUEUE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_NAME")) {
                name = entityInfo.get("YARN_APPLICATION_NAME").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getEventType().equals("YARN_APPLICATION_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (!event.getEventType().equals("YARN_APPLICATION_FINISHED")) continue;
                finishedTime = event.getTimestamp();
                Map eventInfo = event.getEventInfo();
                if (eventInfo == null) continue;
                if (eventInfo.containsKey("YARN_APPLICATION_LATEST_APP_ATTEMPT")) {
                    latestApplicationAttemptId = ConverterUtils.toApplicationAttemptId((String)eventInfo.get("YARN_APPLICATION_LATEST_APP_ATTEMPT").toString());
                }
                if (eventInfo.containsKey("YARN_APPLICATION_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_APPLICATION_DIAGNOSTICS_INFO").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_FINAL_STATUS")) {
                    finalStatus = FinalApplicationStatus.valueOf((String)eventInfo.get("YARN_APPLICATION_FINAL_STATUS").toString());
                }
                if (!eventInfo.containsKey("YARN_APPLICATION_STATE")) continue;
                state = YarnApplicationState.valueOf((String)eventInfo.get("YARN_APPLICATION_STATE").toString());
            }
        }
        return new ApplicationReportExt(ApplicationReport.newInstance((ApplicationId)ConverterUtils.toApplicationId((String)entity.getEntityId()), latestApplicationAttemptId, (String)user, (String)queue, (String)name, null, (int)-1, null, state, diagnosticsInfo, null, (long)createdTime, (long)finishedTime, (FinalApplicationStatus)finalStatus, null, null, (float)1.0f, (String)type, null), appViewACLs);
    }

    private static ApplicationAttemptReport convertToApplicationAttemptReport(TimelineEntity entity) {
        String host = null;
        int rpcPort = -1;
        ContainerId amContainerId = null;
        String trackingUrl = null;
        String originalTrackingUrl = null;
        String diagnosticsInfo = null;
        YarnApplicationAttemptState state = null;
        List events = entity.getEvents();
        if (events != null) {
            for (TimelineEvent event : events) {
                Map eventInfo;
                if (event.getEventType().equals("YARN_APPLICATION_ATTEMPT_REGISTERED")) {
                    eventInfo = event.getEventInfo();
                    if (eventInfo == null) continue;
                    if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_HOST")) {
                        host = eventInfo.get("YARN_APPLICATION_ATTEMPT_HOST").toString();
                    }
                    if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_RPC_PORT")) {
                        rpcPort = (Integer)eventInfo.get("YARN_APPLICATION_ATTEMPT_RPC_PORT");
                    }
                    if (!eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) continue;
                    amContainerId = ConverterUtils.toContainerId((String)eventInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
                    continue;
                }
                if (!event.getEventType().equals("YARN_APPLICATION_ATTEMPT_FINISHED") || (eventInfo = event.getEventInfo()) == null) continue;
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_TRACKING_URL")) {
                    trackingUrl = eventInfo.get("YARN_APPLICATION_ATTEMPT_TRACKING_URL").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL")) {
                    originalTrackingUrl = eventInfo.get("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO").toString();
                }
                if (!eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_STATE")) continue;
                state = YarnApplicationAttemptState.valueOf((String)eventInfo.get("YARN_APPLICATION_ATTEMPT_STATE").toString());
            }
        }
        return ApplicationAttemptReport.newInstance((ApplicationAttemptId)ConverterUtils.toApplicationAttemptId((String)entity.getEntityId()), host, (int)rpcPort, trackingUrl, originalTrackingUrl, diagnosticsInfo, state, amContainerId);
    }

    private static ContainerReport convertToContainerReport(TimelineEntity entity, String serverHttpAddress, String user) {
        List events;
        int allocatedMem = 0;
        int allocatedVcore = 0;
        String allocatedHost = null;
        int allocatedPort = -1;
        int allocatedPriority = 0;
        long createdTime = 0L;
        long finishedTime = 0L;
        String diagnosticsInfo = null;
        int exitStatus = -1000;
        ContainerState state = null;
        Map entityInfo = entity.getOtherInfo();
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_MEMORY")) {
                allocatedMem = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_MEMORY");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_VCORE")) {
                allocatedVcore = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_VCORE");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST")) {
                allocatedHost = entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST").toString();
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PORT")) {
                allocatedPort = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PORT");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PRIORITY")) {
                allocatedPriority = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PRIORITY");
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getEventType().equals("YARN_CONTAINER_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (!event.getEventType().equals("YARN_CONTAINER_FINISHED")) continue;
                finishedTime = event.getTimestamp();
                Map eventInfo = event.getEventInfo();
                if (eventInfo == null) continue;
                if (eventInfo.containsKey("YARN_CONTAINER_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_CONTAINER_DIAGNOSTICS_INFO").toString();
                }
                if (eventInfo.containsKey("YARN_CONTAINER_EXIT_STATUS")) {
                    exitStatus = (Integer)eventInfo.get("YARN_CONTAINER_EXIT_STATUS");
                }
                if (!eventInfo.containsKey("YARN_CONTAINER_STATE")) continue;
                state = ContainerState.valueOf((String)eventInfo.get("YARN_CONTAINER_STATE").toString());
            }
        }
        NodeId allocatedNode = NodeId.newInstance(allocatedHost, (int)allocatedPort);
        ContainerId containerId = ConverterUtils.toContainerId((String)entity.getEntityId());
        String logUrl = WebAppUtils.getAggregatedLogURL((String)serverHttpAddress, (String)allocatedNode.toString(), (String)containerId.toString(), (String)containerId.toString(), (String)user);
        return ContainerReport.newInstance((ContainerId)ConverterUtils.toContainerId((String)entity.getEntityId()), (Resource)Resource.newInstance((int)allocatedMem, (int)allocatedVcore), (NodeId)NodeId.newInstance((String)allocatedHost, (int)allocatedPort), (Priority)Priority.newInstance((int)allocatedPriority), (long)createdTime, (long)finishedTime, diagnosticsInfo, (String)logUrl, (int)exitStatus, state);
    }

    private ApplicationReportExt generateApplicationReport(TimelineEntity entity, ApplicationReportField field) throws YarnException, IOException {
        ApplicationReportExt app = ApplicationHistoryManagerOnTimelineStore.convertToApplicationReport((TimelineEntity)entity, (ApplicationReportField)field);
        if (field == ApplicationReportField.USER_AND_ACLS) {
            return app;
        }
        try {
            ApplicationAttemptReport appAttempt;
            this.checkAccess(app);
            if (ApplicationReportExt.access$000((ApplicationReportExt)app).getCurrentApplicationAttemptId() != null && (appAttempt = this.getApplicationAttempt(ApplicationReportExt.access$000((ApplicationReportExt)app).getCurrentApplicationAttemptId())) != null) {
                ApplicationReportExt.access$000((ApplicationReportExt)app).setHost(appAttempt.getHost());
                ApplicationReportExt.access$000((ApplicationReportExt)app).setRpcPort(appAttempt.getRpcPort());
                ApplicationReportExt.access$000((ApplicationReportExt)app).setTrackingUrl(appAttempt.getTrackingUrl());
                ApplicationReportExt.access$000((ApplicationReportExt)app).setOriginalTrackingUrl(appAttempt.getOriginalTrackingUrl());
            }
        }
        catch (AuthorizationException e) {
            ApplicationReportExt.access$000((ApplicationReportExt)app).setDiagnostics(null);
            ApplicationReportExt.access$000((ApplicationReportExt)app).setCurrentApplicationAttemptId(null);
        }
        if (ApplicationReportExt.access$000((ApplicationReportExt)app).getCurrentApplicationAttemptId() == null) {
            ApplicationReportExt.access$000((ApplicationReportExt)app).setCurrentApplicationAttemptId(ApplicationAttemptId.newInstance((ApplicationId)ApplicationReportExt.access$000((ApplicationReportExt)app).getApplicationId(), (int)-1));
        }
        if (ApplicationReportExt.access$000((ApplicationReportExt)app).getHost() == null) {
            ApplicationReportExt.access$000((ApplicationReportExt)app).setHost("N/A");
        }
        if (ApplicationReportExt.access$000((ApplicationReportExt)app).getRpcPort() < 0) {
            ApplicationReportExt.access$000((ApplicationReportExt)app).setRpcPort(-1);
        }
        if (ApplicationReportExt.access$000((ApplicationReportExt)app).getTrackingUrl() == null) {
            ApplicationReportExt.access$000((ApplicationReportExt)app).setTrackingUrl("N/A");
        }
        if (ApplicationReportExt.access$000((ApplicationReportExt)app).getOriginalTrackingUrl() == null) {
            ApplicationReportExt.access$000((ApplicationReportExt)app).setOriginalTrackingUrl("N/A");
        }
        if (ApplicationReportExt.access$000((ApplicationReportExt)app).getDiagnostics() == null) {
            ApplicationReportExt.access$000((ApplicationReportExt)app).setDiagnostics("");
        }
        return app;
    }

    private ApplicationReportExt getApplication(ApplicationId appId, ApplicationReportField field) throws YarnException, IOException {
        TimelineEntity entity = this.timelineDataManager.getEntity("YARN_APPLICATION", appId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        if (entity == null) {
            throw new ApplicationNotFoundException("The entity for application " + appId + " doesn't exist in the timeline store");
        }
        return this.generateApplicationReport(entity, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAccess(ApplicationReportExt app) throws YarnException, IOException {
        if (ApplicationReportExt.access$100((ApplicationReportExt)app) != null) {
            this.aclsManager.addApplication(ApplicationReportExt.access$000((ApplicationReportExt)app).getApplicationId(), ApplicationReportExt.access$100((ApplicationReportExt)app));
            try {
                if (!this.aclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, ApplicationReportExt.access$000((ApplicationReportExt)app).getUser(), ApplicationReportExt.access$000((ApplicationReportExt)app).getApplicationId())) {
                    throw new AuthorizationException("User " + UserGroupInformation.getCurrentUser().getShortUserName() + " does not have privilage to see this application " + ApplicationReportExt.access$000((ApplicationReportExt)app).getApplicationId());
                }
            }
            finally {
                this.aclsManager.removeApplication(ApplicationReportExt.access$000((ApplicationReportExt)app).getApplicationId());
            }
        }
    }
}

