/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.HistoryEventEmitter;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.tools.rumen.SingleEventEmitter;
import org.apache.hadoop.tools.rumen.TaskFailedEvent;
import org.apache.hadoop.tools.rumen.TaskFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskStartedEvent;
import org.apache.hadoop.tools.rumen.TaskUpdatedEvent;
import org.apache.hadoop.tools.rumen.Version20LogInterfaceUtils;

public class Task20LineHistoryEventEmitter
extends HistoryEventEmitter {
    static List<SingleEventEmitter> nonFinals = new LinkedList<SingleEventEmitter>();
    static List<SingleEventEmitter> finals = new LinkedList<SingleEventEmitter>();
    Long originalStartTime = null;
    TaskType originalTaskType = null;

    protected Task20LineHistoryEventEmitter() {
    }

    @Override
    List<SingleEventEmitter> finalSEEs() {
        return finals;
    }

    @Override
    List<SingleEventEmitter> nonFinalSEEs() {
        return nonFinals;
    }

    static {
        nonFinals.add(new TaskStartedEventEmitter());
        nonFinals.add(new TaskUpdatedEventEmitter());
        finals.add(new TaskFinishedEventEmitter());
        finals.add(new TaskFailedEventEmitter());
    }

    private static class TaskFailedEventEmitter
    extends SingleEventEmitter {
        private TaskFailedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskIDName, HistoryEventEmitter thatg) {
            if (taskIDName == null) {
                return null;
            }
            TaskID taskID = TaskID.forName((String)taskIDName);
            String status = line.get("TASK_STATUS");
            String finishTime = line.get("FINISH_TIME");
            String taskType = line.get("TASK_TYPE");
            String error = line.get("ERROR");
            if (finishTime != null && (error != null || status != null && !status.equalsIgnoreCase("success"))) {
                Task20LineHistoryEventEmitter that = (Task20LineHistoryEventEmitter)thatg;
                TaskType originalTaskType = that.originalTaskType == null ? Version20LogInterfaceUtils.get20TaskType(taskType) : that.originalTaskType;
                return new TaskFailedEvent(taskID, Long.parseLong(finishTime), originalTaskType, error, status, null);
            }
            return null;
        }
    }

    private static class TaskFinishedEventEmitter
    extends SingleEventEmitter {
        private TaskFinishedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskIDName, HistoryEventEmitter thatg) {
            if (taskIDName == null) {
                return null;
            }
            TaskID taskID = TaskID.forName((String)taskIDName);
            String status = line.get("TASK_STATUS");
            String finishTime = line.get("FINISH_TIME");
            String error = line.get("ERROR");
            String counters = line.get("COUNTERS");
            if (finishTime != null && error == null && status != null && status.equalsIgnoreCase("success")) {
                Counters eventCounters = HistoryEventEmitter.maybeParseCounters(counters);
                Task20LineHistoryEventEmitter that = (Task20LineHistoryEventEmitter)thatg;
                if (that.originalTaskType == null) {
                    return null;
                }
                return new TaskFinishedEvent(taskID, Long.parseLong(finishTime), that.originalTaskType, status, eventCounters);
            }
            return null;
        }
    }

    private static class TaskUpdatedEventEmitter
    extends SingleEventEmitter {
        private TaskUpdatedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskIDName, HistoryEventEmitter thatg) {
            if (taskIDName == null) {
                return null;
            }
            TaskID taskID = TaskID.forName((String)taskIDName);
            String finishTime = line.get("FINISH_TIME");
            if (finishTime != null) {
                return new TaskUpdatedEvent(taskID, Long.parseLong(finishTime));
            }
            return null;
        }
    }

    private static class TaskStartedEventEmitter
    extends SingleEventEmitter {
        private TaskStartedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskIDName, HistoryEventEmitter thatg) {
            if (taskIDName == null) {
                return null;
            }
            TaskID taskID = TaskID.forName((String)taskIDName);
            String taskType = line.get("TASK_TYPE");
            String startTime = line.get("START_TIME");
            String splits = line.get("SPLITS");
            if (startTime != null && taskType != null) {
                Task20LineHistoryEventEmitter that = (Task20LineHistoryEventEmitter)thatg;
                that.originalStartTime = Long.parseLong(startTime);
                that.originalTaskType = Version20LogInterfaceUtils.get20TaskType(taskType);
                return new TaskStartedEvent(taskID, that.originalStartTime, that.originalTaskType, splits);
            }
            return null;
        }
    }
}

