/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.JavaSerializationComparator;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.apache.hadoop.mapred.lib.TestMultipleOutputs;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMultipleOutputs
extends HadoopTestCase {
    private static final Path ROOT_DIR = new Path("testing/mo");
    private static final Path IN_DIR = new Path(ROOT_DIR, "input");
    private static final Path OUT_DIR = new Path(ROOT_DIR, "output");

    public TestMultipleOutputs() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testWithoutCounters() throws Exception {
        this._testMultipleOutputs(false);
        this._testMOWithJavaSerialization(false);
    }

    public void testWithCounters() throws Exception {
        this._testMultipleOutputs(true);
        this._testMOWithJavaSerialization(true);
    }

    private Path getDir(Path dir) {
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            dir = new Path(localPathRoot, dir);
        }
        return dir;
    }

    public void setUp() throws Exception {
        super.setUp();
        Path rootDir = this.getDir(ROOT_DIR);
        Path inDir = this.getDir(IN_DIR);
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(rootDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
    }

    public void tearDown() throws Exception {
        Path rootDir = this.getDir(ROOT_DIR);
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(rootDir, true);
        super.tearDown();
    }

    protected void _testMOWithJavaSerialization(boolean withCounters) throws Exception {
        FileStatus[] statuses;
        Path inDir = this.getDir(IN_DIR);
        Path outDir = this.getDir(OUT_DIR);
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        fs.delete(inDir, true);
        fs.delete(outDir, true);
        file = fs.create(new Path(inDir, "part-1"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        conf.setJobName("mo");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(Long.class);
        conf.setMapOutputValueClass(String.class);
        conf.setOutputKeyComparatorClass(JavaSerializationComparator.class);
        conf.setOutputKeyClass(Long.class);
        conf.setOutputValueClass(String.class);
        conf.setOutputFormat(TextOutputFormat.class);
        MultipleOutputs.addNamedOutput((JobConf)conf, (String)"text", TextOutputFormat.class, Long.class, String.class);
        MultipleOutputs.setCountersEnabled((JobConf)conf, (boolean)withCounters);
        conf.setMapperClass(MOJavaSerDeMap.class);
        conf.setReducerClass(MOJavaSerDeReduce.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobClient jc = new JobClient(conf);
        RunningJob job = jc.submitJob(conf);
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        int namedOutputCount = 0;
        for (FileStatus status : statuses = fs.listStatus(outDir)) {
            if (!status.getPath().getName().equals("text-m-00000") && !status.getPath().getName().equals("text-r-00000")) continue;
            ++namedOutputCount;
        }
        TestMultipleOutputs.assertEquals((int)2, (int)namedOutputCount);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(FileOutputFormat.getOutputPath((JobConf)conf), "text-r-00000"))));
        int count = 0;
        String line = reader.readLine();
        while (line != null) {
            TestMultipleOutputs.assertTrue((boolean)line.endsWith("text"));
            line = reader.readLine();
            ++count;
        }
        reader.close();
        TestMultipleOutputs.assertFalse((count == 0 ? 1 : 0) != 0);
        Counters.Group counters = job.getCounters().getGroup(MultipleOutputs.class.getName());
        if (!withCounters) {
            TestMultipleOutputs.assertEquals((int)0, (int)counters.size());
        } else {
            TestMultipleOutputs.assertEquals((int)1, (int)counters.size());
            TestMultipleOutputs.assertEquals((long)2L, (long)counters.getCounter("text"));
        }
    }

    protected void _testMultipleOutputs(boolean withCounters) throws Exception {
        FileStatus[] statuses;
        Path inDir = this.getDir(IN_DIR);
        Path outDir = this.getDir(OUT_DIR);
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        file = fs.create(new Path(inDir, "part-1"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        conf.setJobName("mo");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        MultipleOutputs.addNamedOutput((JobConf)conf, (String)"text", TextOutputFormat.class, LongWritable.class, Text.class);
        MultipleOutputs.addMultiNamedOutput((JobConf)conf, (String)"sequence", SequenceFileOutputFormat.class, LongWritable.class, Text.class);
        MultipleOutputs.setCountersEnabled((JobConf)conf, (boolean)withCounters);
        conf.setMapperClass(MOMap.class);
        conf.setReducerClass(MOReduce.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobClient jc = new JobClient(conf);
        RunningJob job = jc.submitJob(conf);
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        int namedOutputCount = 0;
        for (FileStatus status : statuses = fs.listStatus(outDir)) {
            if (!status.getPath().getName().equals("text-m-00000") && !status.getPath().getName().equals("text-m-00001") && !status.getPath().getName().equals("text-r-00000") && !status.getPath().getName().equals("sequence_A-m-00000") && !status.getPath().getName().equals("sequence_A-m-00001") && !status.getPath().getName().equals("sequence_B-m-00000") && !status.getPath().getName().equals("sequence_B-m-00001") && !status.getPath().getName().equals("sequence_B-r-00000") && !status.getPath().getName().equals("sequence_C-r-00000")) continue;
            ++namedOutputCount;
        }
        TestMultipleOutputs.assertEquals((int)9, (int)namedOutputCount);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(FileOutputFormat.getOutputPath((JobConf)conf), "text-r-00000"))));
        int count = 0;
        String line = reader.readLine();
        while (line != null) {
            TestMultipleOutputs.assertTrue((boolean)line.endsWith("text"));
            line = reader.readLine();
            ++count;
        }
        reader.close();
        TestMultipleOutputs.assertFalse((count == 0 ? 1 : 0) != 0);
        SequenceFile.Reader seqReader = new SequenceFile.Reader(fs, new Path(FileOutputFormat.getOutputPath((JobConf)conf), "sequence_B-r-00000"), (Configuration)conf);
        TestMultipleOutputs.assertEquals(LongWritable.class, (Object)seqReader.getKeyClass());
        TestMultipleOutputs.assertEquals(Text.class, (Object)seqReader.getValueClass());
        count = 0;
        LongWritable key = new LongWritable();
        Text value = new Text();
        while (seqReader.next((Writable)key, (Writable)value)) {
            TestMultipleOutputs.assertEquals((String)"sequence", (String)value.toString());
            ++count;
        }
        seqReader.close();
        TestMultipleOutputs.assertFalse((count == 0 ? 1 : 0) != 0);
        Counters.Group counters = job.getCounters().getGroup(MultipleOutputs.class.getName());
        if (!withCounters) {
            TestMultipleOutputs.assertEquals((int)0, (int)counters.size());
        } else {
            TestMultipleOutputs.assertEquals((int)4, (int)counters.size());
            TestMultipleOutputs.assertEquals((long)4L, (long)counters.getCounter("text"));
            TestMultipleOutputs.assertEquals((long)2L, (long)counters.getCounter("sequence_A"));
            TestMultipleOutputs.assertEquals((long)4L, (long)counters.getCounter("sequence_B"));
            TestMultipleOutputs.assertEquals((long)2L, (long)counters.getCounter("sequence_C"));
        }
    }
}

