/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.tools.AdminHelper;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class StoragePolicyAdmin
extends Configured
implements Tool {
    private static final AdminHelper.Command[] COMMANDS = new AdminHelper.Command[]{new ListStoragePoliciesCommand(), new SetStoragePolicyCommand(), new GetStoragePolicyCommand(), new UnsetStoragePolicyCommand()};

    public static void main(String[] argsArray) throws Exception {
        StoragePolicyAdmin admin = new StoragePolicyAdmin(new Configuration());
        int res = ToolRunner.run((Tool)admin, (String[])argsArray);
        System.exit(res);
    }

    public StoragePolicyAdmin(Configuration conf) {
        super(conf);
    }

    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            AdminHelper.printUsage(false, "storagepolicies", COMMANDS);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        AdminHelper.Command command = AdminHelper.determineCommand(args[0], COMMANDS);
        if (command == null) {
            System.err.println("Can't understand command '" + args[0] + "'");
            if (!args[0].startsWith("-")) {
                System.err.println("Command names must start with dashes.");
            }
            AdminHelper.printUsage(false, "storagepolicies", COMMANDS);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        LinkedList<String> argsList = new LinkedList<String>();
        argsList.addAll(Arrays.asList(args).subList(1, args.length));
        try {
            return command.run(this.getConf(), argsList);
        }
        catch (IllegalArgumentException e) {
            System.err.println(AdminHelper.prettifyException(e));
            return -1;
        }
    }

    private static class UnsetStoragePolicyCommand
    implements AdminHelper.Command {
        private UnsetStoragePolicyCommand() {
        }

        @Override
        public String getName() {
            return "-unsetStoragePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the file/directory from which the storage policy will be unset."});
            return this.getShortUsage() + "\nUnset the storage policy set for a file/directory.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify the path from which the storage policy will be unset.\nUsage: " + this.getLongUsage());
                return 1;
            }
            Path p = new Path(path);
            FileSystem fs = FileSystem.get((Configuration)conf);
            try {
                fs.unsetStoragePolicy(p);
                System.out.println("Unset storage policy from " + path);
            }
            catch (Exception e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class SetStoragePolicyCommand
    implements AdminHelper.Command {
        private SetStoragePolicyCommand() {
        }

        @Override
        public String getName() {
            return "-setStoragePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path> -policy <policy>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the file/directory to set storage policy"});
            listing.addRow(new String[]{"<policy>", "The name of the block storage policy"});
            return this.getShortUsage() + "\nSet the storage policy to a file/directory.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify the path for setting the storage policy.\nUsage: " + this.getLongUsage());
                return 1;
            }
            String policyName = StringUtils.popOptionWithArgument((String)"-policy", args);
            if (policyName == null) {
                System.err.println("Please specify the policy name.\nUsage: " + this.getLongUsage());
                return 1;
            }
            Path p = new Path(path);
            FileSystem fs = FileSystem.get((Configuration)conf);
            try {
                fs.setStoragePolicy(p, policyName);
                System.out.println("Set storage policy " + policyName + " on " + path);
            }
            catch (Exception e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class GetStoragePolicyCommand
    implements AdminHelper.Command {
        private GetStoragePolicyCommand() {
        }

        @Override
        public String getName() {
            return "-getStoragePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the file/directory for getting the storage policy"});
            return this.getShortUsage() + "\nGet the storage policy of a file/directory.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify the path with -path.\nUsage: " + this.getLongUsage());
                return 1;
            }
            Path p = new Path(path);
            FileSystem fs = FileSystem.get((Configuration)conf);
            try {
                FileStatus status;
                try {
                    status = fs.getFileStatus(p);
                }
                catch (FileNotFoundException e) {
                    System.err.println("File/Directory does not exist: " + path);
                    return 2;
                }
                if (status instanceof HdfsFileStatus) {
                    byte storagePolicyId = ((HdfsFileStatus)status).getStoragePolicy();
                    if (storagePolicyId == 0) {
                        System.out.println("The storage policy of " + path + " is unspecified");
                        return 0;
                    }
                    Collection policies = fs.getAllStoragePolicies();
                    for (BlockStoragePolicySpi policy : policies) {
                        if (!(policy instanceof BlockStoragePolicy) || ((BlockStoragePolicy)policy).getId() != storagePolicyId) continue;
                        System.out.println("The storage policy of " + path + ":\n" + policy);
                        return 0;
                    }
                }
                System.err.println(this.getName() + " is not supported for filesystem " + fs.getScheme() + " on path " + path);
                return 2;
            }
            catch (Exception e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
        }
    }

    private static class ListStoragePoliciesCommand
    implements AdminHelper.Command {
        private ListStoragePoliciesCommand() {
        }

        @Override
        public String getName() {
            return "-listPolicies";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + "]\n";
        }

        @Override
        public String getLongUsage() {
            return this.getShortUsage() + "\nList all the existing block storage policies.\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)conf);
            try {
                Collection policies = fs.getAllStoragePolicies();
                System.out.println("Block Storage Policies:");
                for (BlockStoragePolicySpi policy : policies) {
                    if (policy == null) continue;
                    System.out.println("\t" + policy);
                }
            }
            catch (IOException e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }
}

