/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestDFSAdmin {
    private static final Log LOG = LogFactory.getLog(TestDFSAdmin.class);
    private Configuration conf = null;
    private MiniDFSCluster cluster;
    private DFSAdmin admin;
    private DataNode datanode;
    private NameNode namenode;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT = System.out;
    private static final PrintStream OLD_ERR = System.err;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setInt("ipc.client.connect.max.retries", 3);
        this.restartCluster();
        this.admin = new DFSAdmin();
    }

    private void redirectStream() {
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    private void resetStream() {
        this.out.reset();
        this.err.reset();
    }

    @After
    public void tearDown() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(OLD_OUT);
            System.setErr(OLD_ERR);
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        this.resetStream();
    }

    private void restartCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
        this.datanode = this.cluster.getDataNodes().get(0);
        this.namenode = this.cluster.getNameNode();
    }

    private void getReconfigurableProperties(String nodeType, String address, List<String> outs, List<String> errs) throws IOException {
        this.reconfigurationOutErrFormatter("getReconfigurableProperties", nodeType, address, outs, errs);
    }

    private void getReconfigurationStatus(String nodeType, String address, List<String> outs, List<String> errs) throws IOException {
        this.reconfigurationOutErrFormatter("getReconfigurationStatus", nodeType, address, outs, errs);
    }

    private void reconfigurationOutErrFormatter(String methodName, String nodeType, String address, List<String> outs, List<String> errs) throws IOException {
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream outStream = new PrintStream(bufOut);
        ByteArrayOutputStream bufErr = new ByteArrayOutputStream();
        PrintStream errStream = new PrintStream(bufErr);
        if (methodName.equals("getReconfigurableProperties")) {
            this.admin.getReconfigurableProperties(nodeType, address, outStream, errStream);
        } else if (methodName.equals("getReconfigurationStatus")) {
            this.admin.getReconfigurationStatus(nodeType, address, outStream, errStream);
        } else if (methodName.equals("startReconfiguration")) {
            this.admin.startReconfiguration(nodeType, address, outStream, errStream);
        }
        TestDFSAdmin.scanIntoList(bufOut, outs);
        TestDFSAdmin.scanIntoList(bufErr, errs);
    }

    private static void scanIntoList(ByteArrayOutputStream baos, List<String> list) {
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            list.add(scanner.nextLine());
        }
        scanner.close();
    }

    @Test(timeout=30000L)
    public void testGetDatanodeInfo() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
            this.resetStream();
            DataNode dn = this.cluster.getDataNodes().get(i);
            String addr = String.format("%s:%d", dn.getXferAddress().getHostString(), dn.getIpcPort());
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-getDatanodeInfo", addr});
            Assert.assertEquals((long)0L, (long)ret);
            ArrayList outs = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outs);
            Assert.assertEquals((String)"One line per DataNode like: Uptime: XXX, Software version: x.y.z, Config version: core-x.y.z,hdfs-x", (long)1L, (long)outs.size());
            Assert.assertThat(outs.get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Uptime:"), (Matcher)CoreMatchers.containsString((String)"Software version"), (Matcher)CoreMatchers.containsString((String)"Config version"))));
        }
    }

    @Test(timeout=30000L)
    public void testGetVolumeReport() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
            this.resetStream();
            DataNode dn = this.cluster.getDataNodes().get(i);
            String addr = String.format("%s:%d", dn.getXferAddress().getHostString(), dn.getIpcPort());
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-getVolumeReport", addr});
            Assert.assertEquals((long)0L, (long)ret);
            ArrayList outs = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outs);
            Assert.assertEquals(outs.get(0), (Object)"Active Volumes : 2");
        }
    }

    @Test(timeout=60000L)
    public void testDFSAdminUnreachableDatanode() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        for (String command : new String[]{"-getDatanodeInfo", "-evictWriters", "-getBalancerBandwidth"}) {
            String dnDataAddr = this.datanode.getXferAddress().getHostString() + ":" + this.datanode.getXferPort();
            this.resetStream();
            ArrayList outs = Lists.newArrayList();
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{command, dnDataAddr});
            Assert.assertEquals((long)-1L, (long)ret);
            TestDFSAdmin.scanIntoList(this.out, outs);
            Assert.assertTrue((String)("Unexpected " + command + " stdout: " + this.out), (boolean)outs.isEmpty());
            Assert.assertTrue((String)("Unexpected " + command + " stderr: " + this.err), (boolean)this.err.toString().contains("Exception"));
        }
    }

    @Test(timeout=30000L)
    public void testDataNodeGetReconfigurableProperties() throws IOException {
        int port = this.datanode.getIpcPort();
        String address = "localhost:" + port;
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.getReconfigurableProperties("datanode", address, outs, errs);
        Assert.assertEquals((long)3L, (long)outs.size());
        Assert.assertEquals((Object)"dfs.datanode.data.dir", outs.get(1));
    }

    private void testDataNodeGetReconfigurationStatus(boolean expectedSuccuss) throws IOException, InterruptedException, TimeoutException {
        ReconfigurationUtil ru = (ReconfigurationUtil)Mockito.mock(ReconfigurationUtil.class);
        this.datanode.setReconfigurationUtil(ru);
        ArrayList<ReconfigurationUtil.PropertyChange> changes = new ArrayList<ReconfigurationUtil.PropertyChange>();
        File newDir = new File(this.cluster.getDataDirectory(), "data_new");
        if (expectedSuccuss) {
            newDir.mkdirs();
        } else {
            newDir.createNewFile();
        }
        changes.add(new ReconfigurationUtil.PropertyChange("dfs.datanode.data.dir", newDir.toString(), this.datanode.getConf().get("dfs.datanode.data.dir")));
        changes.add(new ReconfigurationUtil.PropertyChange("randomKey", "new123", "old456"));
        Mockito.when((Object)ru.parseChangedProperties((Configuration)Matchers.any(Configuration.class), (Configuration)Matchers.any(Configuration.class))).thenReturn(changes);
        int port = this.datanode.getIpcPort();
        String address = "localhost:" + port;
        Assert.assertThat((Object)this.admin.startReconfiguration("datanode", address), (Matcher)CoreMatchers.is((Object)0));
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.awaitReconfigurationFinished("datanode", address, outs, errs);
        if (expectedSuccuss) {
            Assert.assertThat((Object)outs.size(), (Matcher)CoreMatchers.is((Object)4));
        } else {
            Assert.assertThat((Object)outs.size(), (Matcher)CoreMatchers.is((Object)6));
        }
        List locations = DataNode.getStorageLocations((Configuration)this.datanode.getConf());
        if (expectedSuccuss) {
            Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new File(((StorageLocation)locations.get(0)).getUri()), (Matcher)CoreMatchers.is((Object)newDir));
            Assert.assertTrue((boolean)new File(newDir, "current").isDirectory());
        } else {
            Assert.assertTrue((boolean)locations.isEmpty());
        }
        int offset = 1;
        if (expectedSuccuss) {
            Assert.assertThat(outs.get(offset), (Matcher)CoreMatchers.containsString((String)"SUCCESS: Changed property dfs.datanode.data.dir"));
        } else {
            Assert.assertThat(outs.get(offset), (Matcher)CoreMatchers.containsString((String)"FAILED: Change property dfs.datanode.data.dir"));
        }
        Assert.assertThat(outs.get(offset + 1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"From:"), (Matcher)CoreMatchers.containsString((String)"data1"), (Matcher)CoreMatchers.containsString((String)"data2"))));
        Assert.assertThat(outs.get(offset + 2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"data1"), (Matcher)CoreMatchers.containsString((String)"data2")))));
        Assert.assertThat(outs.get(offset + 2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"To"), (Matcher)CoreMatchers.containsString((String)"data_new"))));
    }

    @Test(timeout=30000L)
    public void testDataNodeGetReconfigurationStatus() throws IOException, InterruptedException, TimeoutException {
        this.testDataNodeGetReconfigurationStatus(true);
        this.restartCluster();
        this.testDataNodeGetReconfigurationStatus(false);
    }

    @Test(timeout=30000L)
    public void testNameNodeGetReconfigurableProperties() throws IOException {
        String address = this.namenode.getHostAndPort();
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.getReconfigurableProperties("namenode", address, outs, errs);
        Assert.assertEquals((long)6L, (long)outs.size());
        Assert.assertEquals((Object)"dfs.heartbeat.interval", outs.get(1));
        Assert.assertEquals((Object)"dfs.namenode.heartbeat.recheck-interval", outs.get(2));
        Assert.assertEquals((long)errs.size(), (long)0L);
    }

    void awaitReconfigurationFinished(final String nodeType, final String address, final List<String> outs, final List<String> errs) throws TimeoutException, IOException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                outs.clear();
                errs.clear();
                try {
                    TestDFSAdmin.this.getReconfigurationStatus(nodeType, address, outs, errs);
                }
                catch (IOException e) {
                    LOG.error((Object)String.format("call getReconfigurationStatus on %s[%s] failed.", nodeType, address), (Throwable)e);
                }
                return !outs.isEmpty() && ((String)outs.get(0)).contains("finished");
            }
        }, (int)100, (int)10000);
    }

    @Test(timeout=30000L)
    public void testPrintTopology() throws Exception {
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        File baseDir = new File(PathUtils.getTestDir(this.getClass()), GenericTestUtils.getMethodName());
        dfsConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        int numDn = 4;
        String[] racks = new String[]{"/d1/r1", "/d1/r2", "/d2/r1", "/d2/r2"};
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(4).racks(racks).build();){
            miniCluster.waitActive();
            Assert.assertEquals((long)4L, (long)miniCluster.getDataNodes().size());
            DFSAdmin dfsAdmin = new DFSAdmin((Configuration)dfsConf);
            this.resetStream();
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-printTopology"});
            ArrayList outs = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outs);
            Assert.assertEquals((long)0L, (long)ret);
            Assert.assertEquals((String)"There should be three lines per Datanode: the 1st line is rack info, 2nd node info, 3rd empty line. The total should be as a result of 3 * numDn.", (long)12L, (long)outs.size());
            Assert.assertThat(outs.get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Rack:"), (Matcher)CoreMatchers.containsString((String)"/d1/r1"))));
            Assert.assertThat(outs.get(3), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Rack:"), (Matcher)CoreMatchers.containsString((String)"/d1/r2"))));
            Assert.assertThat(outs.get(6), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Rack:"), (Matcher)CoreMatchers.containsString((String)"/d2/r1"))));
            Assert.assertThat(outs.get(9), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Rack:"), (Matcher)CoreMatchers.containsString((String)"/d2/r2"))));
        }
    }

    @Test(timeout=30000L)
    public void testNameNodeGetReconfigurationStatus() throws IOException, InterruptedException, TimeoutException {
        ReconfigurationUtil ru = (ReconfigurationUtil)Mockito.mock(ReconfigurationUtil.class);
        this.namenode.setReconfigurationUtil(ru);
        String address = this.namenode.getHostAndPort();
        ArrayList<ReconfigurationUtil.PropertyChange> changes = new ArrayList<ReconfigurationUtil.PropertyChange>();
        changes.add(new ReconfigurationUtil.PropertyChange("dfs.heartbeat.interval", String.valueOf(6), this.namenode.getConf().get("dfs.heartbeat.interval")));
        changes.add(new ReconfigurationUtil.PropertyChange("randomKey", "new123", "old456"));
        Mockito.when((Object)ru.parseChangedProperties((Configuration)Matchers.any(Configuration.class), (Configuration)Matchers.any(Configuration.class))).thenReturn(changes);
        Assert.assertThat((Object)this.admin.startReconfiguration("namenode", address), (Matcher)CoreMatchers.is((Object)0));
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.awaitReconfigurationFinished("namenode", address, outs, errs);
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)6L, (long)this.namenode.getConf().getLong("dfs.heartbeat.interval", 3L));
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)6L, (long)this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatInterval());
        int offset = 1;
        Assert.assertThat(outs.get(offset), (Matcher)CoreMatchers.containsString((String)"SUCCESS: Changed property dfs.heartbeat.interval"));
        Assert.assertThat(outs.get(offset + 1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"From:"), (Matcher)CoreMatchers.containsString((String)"3"))));
        Assert.assertThat(outs.get(offset + 2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"To:"), (Matcher)CoreMatchers.containsString((String)"6"))));
    }

    private static String scanIntoString(ByteArrayOutputStream baos) {
        StrBuilder sb = new StrBuilder();
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            sb.appendln(scanner.nextLine());
        }
        scanner.close();
        return sb.toString();
    }

    private void waitForCorruptBlock(final MiniDFSCluster miniCluster, final DFSClient client, final Path file) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                LocatedBlocks blocks = null;
                try {
                    miniCluster.triggerBlockReports();
                    blocks = client.getNamenode().getBlockLocations(file.toString(), 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    return false;
                }
                return blocks != null && blocks.get(0).isCorrupt();
            }
        }, (int)1000, (int)60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testReportCommand() throws Exception {
        this.tearDown();
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)4);
        dfsConf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        dfsConf.setLong("dfs.heartbeat.interval", 1L);
        Path baseDir = new Path(PathUtils.getTestDir(this.getClass()).getAbsolutePath(), GenericTestUtils.getMethodName());
        dfsConf.set("hdfs.minidfs.basedir", baseDir.toString());
        int numDn = ecPolicy.getNumDataUnits() + ecPolicy.getNumParityUnits();
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(numDn).build();){
            miniCluster.waitActive();
            Assert.assertEquals((long)numDn, (long)miniCluster.getDataNodes().size());
            DFSAdmin dfsAdmin = new DFSAdmin((Configuration)dfsConf);
            DFSClient client = miniCluster.getFileSystem().getClient();
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn, 0, 0, client);
            boolean replFactor = true;
            long fileLength = 512L;
            DistributedFileSystem fs = miniCluster.getFileSystem();
            Path file = new Path(baseDir, "/corrupted");
            fs.enableErasureCodingPolicy(ecPolicy.getName());
            DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, (short)1);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file);
            LocatedBlocks lbs = miniCluster.getFileSystem().getClient().getNamenode().getBlockLocations(file.toString(), 0L, 512L);
            Assert.assertTrue((String)("Unexpected block type: " + lbs.get(0)), (boolean)(lbs.get(0) instanceof LocatedBlock));
            LocatedBlock locatedBlock = lbs.get(0);
            DatanodeInfo locatedDataNode = locatedBlock.getLocations()[0];
            LOG.info((Object)("Replica block located on: " + locatedDataNode));
            Path ecDir = new Path(baseDir, "ec");
            fs.mkdirs(ecDir);
            fs.getClient().setErasureCodingPolicy(ecDir.toString(), ecPolicy.getName());
            Path ecFile = new Path(ecDir, "ec-file");
            int stripesPerBlock = 2;
            int cellSize = ecPolicy.getCellSize();
            int blockSize = stripesPerBlock * cellSize;
            int blockGroupSize = ecPolicy.getNumDataUnits() * blockSize;
            int totalBlockGroups = 1;
            DFSTestUtil.createStripedFile(miniCluster, ecFile, ecDir, totalBlockGroups, stripesPerBlock, false, ecPolicy);
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn, 0, 0, client);
            ArrayList<DataNode> datanodes = miniCluster.getDataNodes();
            DataNode dataNodeToShutdown = null;
            for (DataNode dn : datanodes) {
                if (dn.getDatanodeId().getDatanodeUuid().equals(locatedDataNode.getDatanodeUuid())) continue;
                dataNodeToShutdown = dn;
                break;
            }
            Assert.assertTrue((String)"Unable to choose a DataNode to shutdown!", (dataNodeToShutdown != null ? 1 : 0) != 0);
            LOG.info((Object)("Shutting down: " + dataNodeToShutdown));
            dataNodeToShutdown.shutdown();
            miniCluster.setDataNodeDead(dataNodeToShutdown.getDatanodeId());
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn - 1, 0, 0, client);
            int blockFilesCorrupted = miniCluster.corruptBlockOnDataNodes(block);
            Assert.assertEquals((String)("Fail to corrupt all replicas for block " + block), (long)1L, (long)blockFilesCorrupted);
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)this.conf, (boolean)true);
                Assert.fail((String)"Should have failed to read the file with corrupted blocks.");
            }
            catch (ChecksumException dn) {
                // empty catch block
            }
            fs.setReplication(file, (short)2);
            BlockManagerTestUtil.updateState(miniCluster.getNameNode().getNamesystem().getBlockManager());
            this.waitForCorruptBlock(miniCluster, client, file);
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn - 1, 1, 0, client);
            lbs = miniCluster.getFileSystem().getClient().getNamenode().getBlockLocations(ecFile.toString(), 0L, (long)blockGroupSize);
            Assert.assertTrue((String)("Unexpected block type: " + lbs.get(0)), (boolean)(lbs.get(0) instanceof LocatedStripedBlock));
            LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
            miniCluster.getNamesystem().writeLock();
            try {
                BlockManager bm = miniCluster.getNamesystem().getBlockManager();
                bm.findAndMarkBlockAsCorrupt(bg.getBlock(), bg.getLocations()[0], "STORAGE_ID", "TEST");
                BlockManagerTestUtil.updateState(bm);
            }
            finally {
                miniCluster.getNamesystem().writeUnlock();
            }
            this.waitForCorruptBlock(miniCluster, client, file);
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn - 1, 1, 1, client);
        }
    }

    @Test(timeout=300000L)
    public void testListOpenFiles() throws Exception {
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        dfsConf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        dfsConf.setLong("dfs.heartbeat.interval", 1L);
        dfsConf.setLong("dfs.namenode.list.openfiles.num.responses", 5L);
        Path baseDir = new Path(PathUtils.getTestDir(this.getClass()).getAbsolutePath(), GenericTestUtils.getMethodName());
        dfsConf.set("hdfs.minidfs.basedir", baseDir.toString());
        int numDataNodes = 3;
        int numClosedFiles = 25;
        int numOpenFiles = 15;
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(3).build();){
            boolean replFactor = true;
            long fileLength = 512L;
            DistributedFileSystem fs = miniCluster.getFileSystem();
            Path parentDir = new Path("/tmp/files/");
            fs.mkdirs(parentDir);
            HashSet<Path> closedFileSet = new HashSet<Path>();
            for (int i = 0; i < 25; ++i) {
                Path file = new Path(parentDir, "closed-file-" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
                closedFileSet.add(file);
            }
            HashMap<Path, FSDataOutputStream> openFilesMap = new HashMap<Path, FSDataOutputStream>();
            for (int i = 0; i < 15; ++i) {
                Path file = new Path(parentDir, "open-file-" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
                FSDataOutputStream outputStream = fs.append(file);
                openFilesMap.put(file, outputStream);
            }
            DFSAdmin dfsAdmin = new DFSAdmin((Configuration)dfsConf);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
            this.verifyOpenFilesListing(closedFileSet, openFilesMap);
            for (int count = 0; count < 15; ++count) {
                closedFileSet.addAll(DFSTestUtil.closeOpenFiles(openFilesMap, 1));
                this.resetStream();
                Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
                this.verifyOpenFilesListing(closedFileSet, openFilesMap);
            }
            openFilesMap.clear();
            HashMap<Path, FSDataOutputStream> openFiles1 = new HashMap<Path, FSDataOutputStream>();
            HashMap<Path, FSDataOutputStream> openFiles2 = new HashMap<Path, FSDataOutputStream>();
            for (int i = 0; i < 15; ++i) {
                Path file = i % 2 == 0 ? new Path(new Path("/tmp/files/a"), "open-file-" + i) : new Path(new Path("/tmp/files/b"), "open-file-" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
                FSDataOutputStream outputStream = fs.append(file);
                if (i % 2 == 0) {
                    openFiles1.put(file, outputStream);
                } else {
                    openFiles2.put(file, outputStream);
                }
                openFilesMap.put(file, outputStream);
            }
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
            this.verifyOpenFilesListing(null, openFilesMap);
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path", "/tmp/files/a"}));
            this.verifyOpenFilesListing(null, openFiles1);
            this.resetStream();
            Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path"}));
            String outStr = TestDFSAdmin.scanIntoString(this.err);
            Assert.assertTrue((boolean)outStr.contains("listOpenFiles: option -path requires 1 argument"));
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path", ""}));
            this.verifyOpenFilesListing(null, openFilesMap);
            this.resetStream();
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path", "/invalid_path"}));
            outStr = TestDFSAdmin.scanIntoString(this.out);
            for (Path openFilePath : openFilesMap.keySet()) {
                Assert.assertThat((Object)outStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)openFilePath.toString())));
            }
            DFSTestUtil.closeOpenFiles(openFilesMap, openFilesMap.size());
        }
    }

    private void verifyOpenFilesListing(HashSet<Path> closedFileSet, HashMap<Path, FSDataOutputStream> openFilesMap) {
        String outStr = TestDFSAdmin.scanIntoString(this.out);
        LOG.info((Object)("dfsadmin -listOpenFiles output: \n" + this.out));
        if (closedFileSet != null) {
            for (Path closedFilePath : closedFileSet) {
                Assert.assertThat((Object)outStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)(closedFilePath.toString() + System.lineSeparator()))));
            }
        }
        for (Path openFilePath : openFilesMap.keySet()) {
            Assert.assertThat((Object)outStr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.containsString((String)(openFilePath.toString() + System.lineSeparator()))));
        }
    }

    private void verifyNodesAndCorruptBlocks(int numDn, int numLiveDn, int numCorruptBlocks, int numCorruptECBlockGroups, DFSClient client) throws IOException {
        String outStr = TestDFSAdmin.scanIntoString(this.out);
        String expectedLiveNodesStr = String.format("Live datanodes (%d)", numLiveDn);
        String expectedCorruptedBlocksStr = String.format("Blocks with corrupt replicas: %d", numCorruptBlocks);
        String expectedCorruptedECBlockGroupsStr = String.format("Block groups with corrupt internal blocks: %d", numCorruptECBlockGroups);
        Assert.assertThat((Object)outStr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)expectedLiveNodesStr), (Matcher)CoreMatchers.containsString((String)expectedCorruptedBlocksStr), (Matcher)CoreMatchers.containsString((String)expectedCorruptedECBlockGroupsStr))));
        Assert.assertEquals((long)numDn, (long)client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL).length);
        Assert.assertEquals((long)numLiveDn, (long)client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertEquals((long)(numDn - numLiveDn), (long)client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.DEAD).length);
        Assert.assertEquals((long)(numCorruptBlocks + numCorruptECBlockGroups), (long)client.getCorruptBlocksCount());
        Assert.assertEquals((long)numCorruptBlocks, (long)client.getNamenode().getReplicatedBlockStats().getCorruptBlocks());
        Assert.assertEquals((long)numCorruptECBlockGroups, (long)client.getNamenode().getECBlockGroupStats().getCorruptBlockGroups());
    }

    @Test
    public void testSetBalancerBandwidth() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "10000"}));
        String outStr = TestDFSAdmin.scanIntoString(this.out);
        Assert.assertTrue((String)"Did not set bandwidth!", (boolean)outStr.contains("Balancer bandwidth is set to 10000"));
        this.resetStream();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "10m"}));
        outStr = TestDFSAdmin.scanIntoString(this.out);
        Assert.assertTrue((String)"Did not set bandwidth!", (boolean)outStr.contains("Balancer bandwidth is set to 10485760"));
        this.resetStream();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "10k"}));
        outStr = TestDFSAdmin.scanIntoString(this.out);
        Assert.assertTrue((String)"Did not set bandwidth!", (boolean)outStr.contains("Balancer bandwidth is set to 10240"));
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "-10000"}));
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "-10m"}));
    }
}

