/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.FsDatasetTestUtils;
import org.apache.hadoop.hdfs.server.datanode.LocalReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBuilder;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaUnderRecovery;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.log4j.Level;
import org.slf4j.Logger;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class FsDatasetImplTestUtils
implements FsDatasetTestUtils {
    private static final Log LOG = LogFactory.getLog(FsDatasetImplTestUtils.class);
    private final FsDatasetImpl dataset;
    private static final DataChecksum DEFAULT_CHECKSUM = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32C, (int)512);
    public static final int DEFAULT_NUM_OF_DATA_DIRS = 2;

    public FsDatasetImplTestUtils(DataNode datanode) {
        Preconditions.checkArgument((boolean)(datanode.getFSDataset() instanceof FsDatasetImpl));
        this.dataset = (FsDatasetImpl)datanode.getFSDataset();
    }

    private ReplicaInfo getBlockFile(ExtendedBlock eb) throws IOException {
        return this.dataset.getReplicaInfo(eb);
    }

    @Override
    public FsDatasetTestUtils.MaterializedReplica getMaterializedReplica(ExtendedBlock block) throws ReplicaNotFoundException {
        File blockFile;
        try {
            ReplicaInfo r = this.dataset.getReplicaInfo(block);
            blockFile = new File(r.getBlockURI());
        }
        catch (IOException e) {
            LOG.error((Object)("Block file for " + block + " does not existed:"), (Throwable)e);
            throw new ReplicaNotFoundException(block);
        }
        File metaFile = FsDatasetUtil.getMetaFile((File)blockFile, (long)block.getGenerationStamp());
        return new FsDatasetImplMaterializedReplica(blockFile, metaFile);
    }

    @Override
    public Replica createFinalizedReplica(ExtendedBlock block) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            Replica replica = this.createFinalizedReplica(volumes.get(0), block);
            return replica;
        }
    }

    @Override
    public Replica createFinalizedReplica(FsVolumeSpi volume, ExtendedBlock block) throws IOException {
        FsVolumeImpl vol = (FsVolumeImpl)volume;
        FinalizedReplica info = new FinalizedReplica(block.getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile());
        this.dataset.volumeMap.add(block.getBlockPoolId(), (ReplicaInfo)info);
        info.getBlockFile().createNewFile();
        info.getMetaFile().createNewFile();
        this.saveMetaFileHeader(info.getMetaFile());
        return info;
    }

    private void saveMetaFileHeader(File metaFile) throws IOException {
        DataOutputStream metaOut = new DataOutputStream(new FileOutputStream(metaFile));
        BlockMetadataHeader.writeHeader((DataOutputStream)metaOut, (DataChecksum)DEFAULT_CHECKSUM);
        metaOut.close();
    }

    @Override
    public Replica createReplicaInPipeline(ExtendedBlock block) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            Replica replica = this.createReplicaInPipeline(volumes.get(0), block);
            return replica;
        }
    }

    @Override
    public Replica createReplicaInPipeline(FsVolumeSpi volume, ExtendedBlock block) throws IOException {
        FsVolumeImpl vol = (FsVolumeImpl)volume;
        LocalReplicaInPipeline rip = new LocalReplicaInPipeline(block.getBlockId(), block.getGenerationStamp(), volume, vol.createTmpFile(block.getBlockPoolId(), block.getLocalBlock()).getParentFile(), 0L);
        this.dataset.volumeMap.add(block.getBlockPoolId(), (ReplicaInfo)rip);
        return rip;
    }

    @Override
    public Replica createRBW(ExtendedBlock eb) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            Replica replica = this.createRBW(volumes.get(0), eb);
            return replica;
        }
    }

    @Override
    public Replica createRBW(FsVolumeSpi volume, ExtendedBlock eb) throws IOException {
        FsVolumeImpl vol = (FsVolumeImpl)volume;
        String bpid = eb.getBlockPoolId();
        Block block = eb.getLocalBlock();
        ReplicaBeingWritten rbw = new ReplicaBeingWritten(eb.getLocalBlock(), volume, vol.createRbwFile(bpid, block).getParentFile(), null);
        rbw.getBlockFile().createNewFile();
        rbw.getMetaFile().createNewFile();
        this.dataset.volumeMap.add(bpid, (ReplicaInfo)rbw);
        FileIoProvider fileIoProvider = rbw.getFileIoProvider();
        try (RandomAccessFile blockRAF = fileIoProvider.getRandomAccessFile(volume, rbw.getBlockFile(), "rw");){
            blockRAF.setLength(eb.getNumBytes());
        }
        this.saveMetaFileHeader(rbw.getMetaFile());
        return rbw;
    }

    @Override
    public Replica createReplicaWaitingToBeRecovered(ExtendedBlock eb) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            Replica replica = this.createReplicaInPipeline(volumes.get(0), eb);
            return replica;
        }
    }

    @Override
    public Replica createReplicaWaitingToBeRecovered(FsVolumeSpi volume, ExtendedBlock eb) throws IOException {
        FsVolumeImpl vol = (FsVolumeImpl)volume;
        String bpid = eb.getBlockPoolId();
        Block block = eb.getLocalBlock();
        ReplicaInfo rwbr = new ReplicaBuilder(HdfsServerConstants.ReplicaState.RWR).setBlock(eb.getLocalBlock()).setFsVolume(volume).setDirectoryToUse(vol.createRbwFile(bpid, block).getParentFile()).build();
        this.dataset.volumeMap.add(bpid, rwbr);
        return rwbr;
    }

    @Override
    public Replica createReplicaUnderRecovery(ExtendedBlock block, long recoveryId) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            FsVolumeImpl volume = (FsVolumeImpl)volumes.get(0);
            ReplicaUnderRecovery rur = new ReplicaUnderRecovery((ReplicaInfo)new FinalizedReplica(block.getLocalBlock(), (FsVolumeSpi)volume, volume.getCurrentDir().getParentFile()), recoveryId);
            this.dataset.volumeMap.add(block.getBlockPoolId(), (ReplicaInfo)rur);
            ReplicaUnderRecovery replicaUnderRecovery = rur;
            return replicaUnderRecovery;
        }
    }

    @Override
    public void checkStoredReplica(Replica replica) throws IOException {
        Preconditions.checkArgument((boolean)(replica instanceof ReplicaInfo));
        ReplicaInfo r = (ReplicaInfo)replica;
        FsDatasetImpl.checkReplicaFiles((ReplicaInfo)r);
    }

    @Override
    public void injectCorruptReplica(ExtendedBlock block) throws IOException {
        Preconditions.checkState((!this.dataset.contains(block) ? 1 : 0) != 0, (Object)("Block " + block + " already exists on dataset."));
        try (FsDatasetSpi.FsVolumeReferences volRef = this.dataset.getFsVolumeReferences();){
            FsVolumeImpl volume = (FsVolumeImpl)volRef.get(0);
            FinalizedReplica finalized = new FinalizedReplica(block.getLocalBlock(), (FsVolumeSpi)volume, volume.getFinalizedDir(block.getBlockPoolId()));
            File blockFile = finalized.getBlockFile();
            if (!blockFile.createNewFile()) {
                throw new FileExistsException("Block file " + blockFile + " already exists.");
            }
            File metaFile = FsDatasetUtil.getMetaFile((File)blockFile, (long)1000L);
            if (!metaFile.createNewFile()) {
                throw new FileExistsException("Meta file " + metaFile + " already exists.");
            }
            this.dataset.volumeMap.add(block.getBlockPoolId(), (ReplicaInfo)finalized);
        }
    }

    @Override
    public Replica fetchReplica(ExtendedBlock block) {
        return this.dataset.fetchReplicaInfo(block.getBlockPoolId(), block.getBlockId());
    }

    @Override
    public int getDefaultNumOfDataDirs() {
        return 2;
    }

    @Override
    public long getRawCapacity() throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volRefs = this.dataset.getFsVolumeReferences();){
            Preconditions.checkState((volRefs.size() != 0 ? 1 : 0) != 0);
            DF df = volRefs.get(0).getUsageStats(this.dataset.datanode.getConf());
            if (df != null) {
                long l = df.getCapacity();
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    @Override
    public long getStoredDataLength(ExtendedBlock block) throws IOException {
        ReplicaInfo r = this.getBlockFile(block);
        return r.getBlockDataLength();
    }

    @Override
    public long getStoredGenerationStamp(ExtendedBlock block) throws IOException {
        ReplicaInfo r = this.getBlockFile(block);
        return r.getGenerationStamp();
    }

    @Override
    public void changeStoredGenerationStamp(ExtendedBlock block, long newGenStamp) throws IOException {
        ReplicaInfo r = this.dataset.getReplicaInfo(block);
        File blockFile = new File(r.getBlockURI());
        File metaFile = FsDatasetUtil.findMetaFile((File)blockFile);
        File newMetaFile = new File(DatanodeUtil.getMetaName((String)blockFile.getAbsolutePath(), (long)newGenStamp));
        Files.move(metaFile.toPath(), newMetaFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public Iterator<Replica> getStoredReplicas(String bpid) throws IOException {
        ReplicaMap replicaMap = new ReplicaMap(this.dataset.datasetLock);
        try (FsDatasetSpi.FsVolumeReferences refs = this.dataset.getFsVolumeReferences();){
            for (FsVolumeSpi vol : refs) {
                FsVolumeImpl volume = (FsVolumeImpl)vol;
                volume.getVolumeMap(bpid, replicaMap, this.dataset.ramDiskReplicaTracker);
            }
        }
        ArrayList ret = new ArrayList();
        if (replicaMap.replicas(bpid) != null) {
            ret.addAll(replicaMap.replicas(bpid));
        }
        return ret.iterator();
    }

    @Override
    public long getPendingAsyncDeletions() {
        return this.dataset.asyncDiskService.countPendingDeletions();
    }

    @Override
    public void verifyBlockPoolExists(String bpid) throws IOException {
        FsVolumeImpl volume;
        try (FsDatasetSpi.FsVolumeReferences references = this.dataset.getFsVolumeReferences();){
            volume = (FsVolumeImpl)references.get(0);
        }
        File bpDir = new File(volume.getCurrentDir(), bpid);
        File bpCurrentDir = new File(bpDir, "current");
        File finalizedDir = new File(bpCurrentDir, "finalized");
        File rbwDir = new File(bpCurrentDir, "rbw");
        File versionFile = new File(bpCurrentDir, "VERSION");
        if (!finalizedDir.isDirectory()) {
            throw new IOException(finalizedDir.getPath() + " is not a directory.");
        }
        if (!rbwDir.isDirectory()) {
            throw new IOException(finalizedDir.getPath() + " is not a directory.");
        }
        if (!versionFile.exists()) {
            throw new IOException("Version file: " + versionFile.getPath() + " does not exist.");
        }
    }

    @Override
    public void verifyBlockPoolMissing(String bpid) throws IOException {
        FsVolumeImpl volume;
        try (FsDatasetSpi.FsVolumeReferences references = this.dataset.getFsVolumeReferences();){
            volume = (FsVolumeImpl)references.get(0);
        }
        File bpDir = new File(volume.getCurrentDir(), bpid);
        if (bpDir.exists()) {
            throw new IOException(String.format("Block pool directory %s exists", bpDir));
        }
    }

    public static void setFsDatasetImplLogLevel(Level level) {
        GenericTestUtils.setLogLevel((Logger)FsDatasetImpl.LOG, (Level)level);
    }

    private static class FsDatasetImplMaterializedReplica
    implements FsDatasetTestUtils.MaterializedReplica {
        private final File blockFile;
        private final File metaFile;

        private static void checkFile(File file) throws FileNotFoundException {
            if (file == null || !file.exists()) {
                throw new FileNotFoundException("The block file or metadata file " + file + " does not exist.");
            }
        }

        private static void truncate(File file, long newSize) throws IOException {
            Preconditions.checkArgument((newSize >= 0L ? 1 : 0) != 0);
            FsDatasetImplMaterializedReplica.checkFile(file);
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.setLength(newSize);
            }
        }

        private static void delete(File file) throws IOException {
            FsDatasetImplMaterializedReplica.checkFile(file);
            Files.delete(file.toPath());
        }

        FsDatasetImplMaterializedReplica(File blockFile, File metaFile) {
            this.blockFile = blockFile;
            this.metaFile = metaFile;
        }

        @Override
        public void corruptData() throws IOException {
            FsDatasetImplMaterializedReplica.checkFile(this.blockFile);
            LOG.info((Object)("Corrupting block file: " + this.blockFile));
            int BUF_SIZE = 32;
            byte[] buf = new byte[32];
            try (RandomAccessFile raf = new RandomAccessFile(this.blockFile, "rw");){
                int nread = raf.read(buf);
                int i = 0;
                while (i < nread) {
                    int n = i++;
                    buf[n] = (byte)(buf[n] + 1);
                }
                raf.seek(0L);
                raf.write(buf);
            }
        }

        @Override
        public void corruptData(byte[] newContent) throws IOException {
            FsDatasetImplMaterializedReplica.checkFile(this.blockFile);
            LOG.info((Object)("Corrupting block file with new content: " + this.blockFile));
            try (RandomAccessFile raf = new RandomAccessFile(this.blockFile, "rw");){
                raf.write(newContent);
            }
        }

        @Override
        public void truncateData(long newSize) throws IOException {
            LOG.info((Object)("Truncating block file: " + this.blockFile));
            FsDatasetImplMaterializedReplica.truncate(this.blockFile, newSize);
        }

        @Override
        public void deleteData() throws IOException {
            LOG.info((Object)("Deleting block file: " + this.blockFile));
            FsDatasetImplMaterializedReplica.delete(this.blockFile);
        }

        @Override
        public void corruptMeta() throws IOException {
            FsDatasetImplMaterializedReplica.checkFile(this.metaFile);
            LOG.info((Object)("Corrupting meta file: " + this.metaFile));
            Random random = new Random();
            try (RandomAccessFile raf = new RandomAccessFile(this.metaFile, "rw");){
                FileChannel channel = raf.getChannel();
                int offset = random.nextInt((int)channel.size() / 2);
                raf.seek(offset);
                raf.write("BADBAD".getBytes());
            }
        }

        @Override
        public void deleteMeta() throws IOException {
            LOG.info((Object)("Deleting metadata file: " + this.metaFile));
            FsDatasetImplMaterializedReplica.delete(this.metaFile);
        }

        @Override
        public void truncateMeta(long newSize) throws IOException {
            LOG.info((Object)("Truncating metadata file: " + this.metaFile));
            FsDatasetImplMaterializedReplica.truncate(this.metaFile, newSize);
        }

        @Override
        public void makeUnreachable() throws IOException {
            long blockId = Block.getBlockId((String)this.blockFile.getAbsolutePath());
            File origDir = this.blockFile.getParentFile();
            File root = origDir.getParentFile().getParentFile();
            File newDir = null;
            while (origDir.equals(newDir = DatanodeUtil.idToBlockDir((File)root, (long)(++blockId)))) {
            }
            Files.createDirectories(newDir.toPath(), new FileAttribute[0]);
            Files.move(this.blockFile.toPath(), new File(newDir, this.blockFile.getName()).toPath(), new CopyOption[0]);
            Files.move(this.metaFile.toPath(), new File(newDir, this.metaFile.getName()).toPath(), new CopyOption[0]);
        }

        public String toString() {
            return String.format("MaterializedReplica: file=%s", this.blockFile);
        }
    }
}

