/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStandbyInProgressTail {
    private static final Log LOG = LogFactory.getLog(TestStandbyInProgressTail.class);
    private Configuration conf;
    private MiniQJMHACluster qjmhaCluster;
    private MiniDFSCluster cluster;
    private NameNode nn0;
    private NameNode nn1;

    @Before
    public void startUp() throws IOException {
        this.conf = new Configuration();
        this.conf.setInt("dfs.ha.tail-edits.period", 1200);
        this.conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        this.qjmhaCluster = new MiniQJMHACluster.Builder(this.conf).build();
        this.cluster = this.qjmhaCluster.getDfsCluster();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
    }

    @After
    public void tearDown() throws IOException {
        if (this.qjmhaCluster != null) {
            this.qjmhaCluster.shutdown();
        }
    }

    @Test
    public void testDefault() throws Exception {
        if (this.qjmhaCluster != null) {
            this.qjmhaCluster.shutdown();
        }
        this.conf = new Configuration();
        this.conf.setInt("dfs.ha.tail-edits.period", 1200);
        this.conf.setBoolean("dfs.ha.tail-edits.in-progress", false);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        this.qjmhaCluster = new MiniQJMHACluster.Builder(this.conf).build();
        this.cluster = this.qjmhaCluster.getDfsCluster();
        try {
            ArrayList allDirs = Lists.newArrayList();
            allDirs.addAll(this.cluster.getNameDirs(0));
            allDirs.addAll(this.cluster.getNameDirs(1));
            TestStandbyInProgressTail.assertNoEditFiles(allDirs);
            this.cluster.transitionToActive(0);
            TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
            TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
            this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
            this.cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
            Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true));
            this.cluster.restartNameNode(1);
            TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
            TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
            Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true));
            this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
            this.cluster.restartNameNode(0);
            this.cluster.transitionToActive(1);
            Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true));
            Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test2", true));
        }
        finally {
            if (this.qjmhaCluster != null) {
                this.qjmhaCluster.shutdown();
            }
        }
    }

    @Test
    public void testSetup() throws Exception {
        ArrayList allDirs = Lists.newArrayList();
        allDirs.addAll(this.cluster.getNameDirs(0));
        allDirs.addAll(this.cluster.getNameDirs(1));
        TestStandbyInProgressTail.assertNoEditFiles(allDirs);
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.nn1.getNamesystem().getEditLogTailer().doTailEdits();
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true));
        this.cluster.restartNameNode(1);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        this.cluster.restartNameNode(0);
        this.cluster.transitionToActive(1);
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test2", true));
    }

    @Test
    public void testHalfStartInProgressTail() throws Exception {
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.nn1.getNamesystem().getEditLogTailer().doTailEdits();
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        this.nn0.getRpcServer().rollEditLog();
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test2", true));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test3", FsPermission.createImmutable((short)493), true);
        this.nn1.getNamesystem().getEditLogTailer().doTailEdits();
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test2", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test3", true));
    }

    @Test
    public void testInitStartInProgressTail() throws Exception {
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        this.nn0.getRpcServer().rollEditLog();
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test3", FsPermission.createImmutable((short)493), true);
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true));
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test2", true));
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test3", true));
        this.nn1.getNamesystem().getEditLogTailer().doTailEdits();
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test2", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test3", true));
    }

    @Test
    public void testNewStartInProgressTail() throws Exception {
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        this.nn1.getNamesystem().getEditLogTailer().doTailEdits();
        this.nn0.getRpcServer().rollEditLog();
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test2", true));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test3", FsPermission.createImmutable((short)493), true);
        this.nn1.getNamesystem().getEditLogTailer().doTailEdits();
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test2", true));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test3", true));
    }

    @Test
    public void testNonUniformConfig() throws Exception {
        Configuration newConf = this.cluster.getNameNode(0).getConf();
        newConf.setBoolean("dfs.ha.tail-edits.in-progress", false);
        this.cluster.restartNameNode(0);
        this.cluster.transitionToActive(0);
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.cluster.getNameNode(0).getRpcServer().rollEdits();
        this.cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true));
    }

    private static void assertNoEditFiles(Iterable<URI> dirs) throws IOException {
        TestStandbyInProgressTail.assertEditFiles(dirs, new String[0]);
    }

    private static void assertEditFiles(Iterable<URI> dirs, String ... files) throws IOException {
        for (URI u : dirs) {
            File editDirRoot = new File(u.getPath());
            File editDir = new File(editDirRoot, "current");
            GenericTestUtils.assertExists((File)editDir);
            if (files.length == 0) {
                LOG.info((Object)("Checking no edit files exist in " + editDir));
            } else {
                LOG.info((Object)("Checking for following edit files in " + editDir + ": " + Joiner.on((String)",").join((Object[])files)));
            }
            GenericTestUtils.assertGlobEquals((File)editDir, (String)"edits_.*", (String[])files);
        }
    }
}

