/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRefreshUserMappings {
    private MiniDFSCluster cluster;
    Configuration config;
    private static final long groupRefreshTimeoutSec = 1L;
    private String tempResource = null;

    @Before
    public void setUp() throws Exception {
        this.config = new Configuration();
        this.config.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        this.config.setLong("hadoop.security.groups.cache.secs", 1L);
        Groups.getUserToGroupsMappingService((Configuration)this.config);
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        this.cluster = new MiniDFSCluster.Builder(this.config).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        if (this.tempResource != null) {
            File f = new File(this.tempResource);
            f.delete();
        }
    }

    @Test
    public void testGroupMappingRefresh() throws Exception {
        DFSAdmin admin = new DFSAdmin(this.config);
        String[] args = new String[]{"-refreshUserToGroupsMappings"};
        Groups groups = Groups.getUserToGroupsMappingService((Configuration)this.config);
        String user = UserGroupInformation.getCurrentUser().getUserName();
        System.out.println("first attempt:");
        List g1 = groups.getGroups(user);
        Object[] str_groups = new String[g1.size()];
        g1.toArray(str_groups);
        System.out.println(Arrays.toString(str_groups));
        System.out.println("second attempt, should be same:");
        List g2 = groups.getGroups(user);
        g2.toArray(str_groups);
        System.out.println(Arrays.toString(str_groups));
        for (int i = 0; i < g2.size(); ++i) {
            Assert.assertEquals((String)"Should be same group ", g1.get(i), g2.get(i));
        }
        admin.run(args);
        System.out.println("third attempt(after refresh command), should be different:");
        List g3 = groups.getGroups(user);
        g3.toArray(str_groups);
        System.out.println(Arrays.toString(str_groups));
        for (int i = 0; i < g3.size(); ++i) {
            Assert.assertFalse((String)("Should be different group: " + (String)g1.get(i) + " and " + (String)g3.get(i)), (boolean)((String)g1.get(i)).equals(g3.get(i)));
        }
        Thread.sleep(1100L);
        System.out.println("fourth attempt(after timeout), should be different:");
        List g4 = groups.getGroups(user);
        g4.toArray(str_groups);
        System.out.println(Arrays.toString(str_groups));
        for (int i = 0; i < g4.size(); ++i) {
            Assert.assertFalse((String)"Should be different group ", (boolean)((String)g3.get(i)).equals(g4.get(i)));
        }
    }

    @Test
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        String SUPER_USER = "super_user";
        ArrayList<String> groupNames1 = new ArrayList<String>();
        groupNames1.add("gr1");
        groupNames1.add("gr2");
        ArrayList<String> groupNames2 = new ArrayList<String>();
        groupNames2.add("gr3");
        groupNames2.add("gr4");
        String userKeyGroups = DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey("super_user");
        String userKeyHosts = DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey("super_user");
        this.config.set(userKeyGroups, "gr3,gr4,gr5");
        this.config.set(userKeyHosts, "127.0.0.1");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.config);
        UserGroupInformation ugi1 = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        UserGroupInformation ugi2 = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        UserGroupInformation suUgi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi1.getRealUser()).thenReturn((Object)suUgi);
        Mockito.when((Object)ugi2.getRealUser()).thenReturn((Object)suUgi);
        Mockito.when((Object)suUgi.getShortUserName()).thenReturn((Object)"super_user");
        Mockito.when((Object)suUgi.getUserName()).thenReturn((Object)"super_userL");
        Mockito.when((Object)ugi1.getShortUserName()).thenReturn((Object)"user1");
        Mockito.when((Object)ugi2.getShortUserName()).thenReturn((Object)"user2");
        Mockito.when((Object)ugi1.getUserName()).thenReturn((Object)"userL1");
        Mockito.when((Object)ugi2.getUserName()).thenReturn((Object)"userL2");
        Mockito.when((Object)ugi1.getGroups()).thenReturn(groupNames1);
        Mockito.when((Object)ugi2.getGroups()).thenReturn(groupNames2);
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi1, (String)"127.0.0.1");
            Assert.fail((String)("first auth for " + ugi1.getShortUserName() + " should've failed "));
        }
        catch (AuthorizationException e) {
            System.err.println("auth for " + ugi1.getUserName() + " failed");
        }
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi2, (String)"127.0.0.1");
            System.err.println("auth for " + ugi2.getUserName() + " succeeded");
        }
        catch (AuthorizationException e) {
            Assert.fail((String)("first auth for " + ugi2.getShortUserName() + " should've succeeded: " + e.getLocalizedMessage()));
        }
        String rsrc = "testGroupMappingRefresh_rsrc.xml";
        this.addNewConfigResource(rsrc, userKeyGroups, "gr2", userKeyHosts, "127.0.0.1");
        DFSAdmin admin = new DFSAdmin(this.config);
        String[] args = new String[]{"-refreshSuperUserGroupsConfiguration"};
        admin.run(args);
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi2, (String)"127.0.0.1");
            Assert.fail((String)("second auth for " + ugi2.getShortUserName() + " should've failed "));
        }
        catch (AuthorizationException e) {
            System.err.println("auth for " + ugi2.getUserName() + " failed");
        }
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi1, (String)"127.0.0.1");
            System.err.println("auth for " + ugi1.getUserName() + " succeeded");
        }
        catch (AuthorizationException e) {
            Assert.fail((String)("second auth for " + ugi1.getShortUserName() + " should've succeeded: " + e.getLocalizedMessage()));
        }
    }

    private void addNewConfigResource(String rsrcName, String keyGroup, String groups, String keyHosts, String hosts) throws FileNotFoundException, UnsupportedEncodingException {
        Configuration conf = new Configuration();
        URL url = conf.getResource("hdfs-site.xml");
        String urlPath = URLDecoder.decode(url.getPath().toString(), "UTF-8");
        Path p = new Path(urlPath);
        Path dir = p.getParent();
        this.tempResource = dir.toString() + "/" + rsrcName;
        String newResource = "<configuration><property><name>" + keyGroup + "</name><value>" + groups + "</value></property>" + "<property><name>" + keyHosts + "</name><value>" + hosts + "</value></property>" + "</configuration>";
        PrintWriter writer = new PrintWriter(new FileOutputStream(this.tempResource));
        writer.println(newResource);
        writer.close();
        Configuration.addDefaultResource((String)rsrcName);
    }

    public static class MockUnixGroupsMapping
    implements GroupMappingServiceProvider {
        private int i = 0;

        public List<String> getGroups(String user) throws IOException {
            System.out.println("Getting groups in MockUnixGroupsMapping");
            String g1 = user + (10 * this.i + 1);
            String g2 = user + (10 * this.i + 2);
            ArrayList<String> l = new ArrayList<String>(2);
            l.add(g1);
            l.add(g2);
            ++this.i;
            return l;
        }

        public void cacheGroupsRefresh() throws IOException {
            System.out.println("Refreshing groups in MockUnixGroupsMapping");
        }

        public void cacheGroupsAdd(List<String> groups) throws IOException {
        }
    }
}

