/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestFSImage {
    private static final String HADOOP_2_7_ZER0_BLOCK_SIZE_TGZ = "image-with-zero-block-size.tar.gz";

    @Test
    public void testPersist() throws IOException {
        Configuration conf = new Configuration();
        this.testPersistHelper(conf);
    }

    @Test
    public void testCompression() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.image.compress", true);
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.DefaultCodec");
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.GzipCodec");
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.BZip2Codec");
    }

    @Test
    public void testNativeCompression() throws IOException {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.image.compress", true);
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.Lz4Codec");
    }

    private void setCompressCodec(Configuration conf, String compressCodec) throws IOException {
        conf.set("dfs.image.compression.codec", compressCodec);
        this.testPersistHelper(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPersistHelper(Configuration conf) throws IOException {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/abc/def");
            Path file1 = new Path(dir, "f1");
            Path file2 = new Path(dir, "f2");
            fs.create(file1).close();
            FSDataOutputStream out = fs.create(file2);
            out.writeBytes("hello");
            ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fs.saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNode(new String[0]);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.isDirectory(dir));
            Assert.assertTrue((boolean)fs.exists(file1));
            Assert.assertTrue((boolean)fs.exists(file2));
            INodeFile file2Node = fsn.dir.getINode4Write(file2.toString()).asFile();
            Assert.assertEquals((long)"hello".length(), (long)file2Node.computeFileSize());
            Assert.assertTrue((boolean)file2Node.isUnderConstruction());
            BlockInfoContiguous[] blks = file2Node.getBlocks();
            Assert.assertEquals((long)1L, (long)blks.length);
            Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, (Object)blks[0].getBlockUCState());
            LeaseManager.Lease lease = fsn.leaseManager.getLeaseByPath(file2.toString());
            Assert.assertNotNull((Object)lease);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDigest() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fs.saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            File currentDir = FSImageTestUtil.getNameNodeCurrentDirs(cluster, 0).get(0);
            File fsimage = FSImageTestUtil.findNewestImageFile(currentDir.getAbsolutePath());
            Assert.assertEquals((Object)MD5FileUtils.readStoredMd5ForFile((File)fsimage), (Object)MD5FileUtils.computeMd5ForFile((File)fsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLoadMtimeAtime() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String userDir = hdfs.getHomeDirectory().toUri().getPath().toString();
            Path file = new Path(userDir, "file");
            Path dir = new Path(userDir, "/dir");
            Path link = new Path(userDir, "/link");
            hdfs.createNewFile(file);
            hdfs.mkdirs(dir);
            hdfs.createSymlink(file, link, false);
            long mtimeFile = hdfs.getFileStatus(file).getModificationTime();
            long atimeFile = hdfs.getFileStatus(file).getAccessTime();
            long mtimeDir = hdfs.getFileStatus(dir).getModificationTime();
            long mtimeLink = hdfs.getFileLinkStatus(link).getModificationTime();
            long atimeLink = hdfs.getFileLinkStatus(link).getAccessTime();
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            hdfs.saveNamespace();
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(1).build();
            cluster.waitActive();
            hdfs = cluster.getFileSystem();
            Assert.assertEquals((long)mtimeFile, (long)hdfs.getFileStatus(file).getModificationTime());
            Assert.assertEquals((long)atimeFile, (long)hdfs.getFileStatus(file).getAccessTime());
            Assert.assertEquals((long)mtimeDir, (long)hdfs.getFileStatus(dir).getModificationTime());
            Assert.assertEquals((long)mtimeLink, (long)hdfs.getFileLinkStatus(link).getModificationTime());
            Assert.assertEquals((long)atimeLink, (long)hdfs.getFileLinkStatus(link).getAccessTime());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroBlockSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String tarFile = System.getProperty("test.cache.data", "build/test/cache") + "/" + HADOOP_2_7_ZER0_BLOCK_SIZE_TGZ;
        String testDir = PathUtils.getTestDirName(this.getClass());
        File dfsDir = new File(testDir, "image-with-zero-block-size");
        if (dfsDir.exists() && !FileUtil.fullyDelete((File)dfsDir)) {
            throw new IOException("Could not delete dfs directory '" + dfsDir + "'");
        }
        FileUtil.unTar((File)new File(tarFile), (File)new File(testDir));
        File nameDir = new File(dfsDir, "name");
        GenericTestUtils.assertExists((File)nameDir);
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).waitSafeMode(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testPath = new Path("/tmp/zeroBlockFile");
            Assert.assertTrue((String)"File /tmp/zeroBlockFile doesn't exist ", (boolean)fs.exists(testPath));
            Assert.assertTrue((String)"Name node didn't come up", (boolean)cluster.isNameNodeUp(0));
        }
        finally {
            cluster.shutdown();
            FileUtil.fullyDelete((File)dfsDir);
        }
    }
}

