/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBlockUnderConstruction {
    static final String BASE_DIR = "/test/TestBlockUnderConstruction";
    static final int BLOCK_SIZE = 8192;
    static final int NUM_BLOCKS = 5;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem hdfs;

    @BeforeClass
    public static void setUp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (hdfs != null) {
            hdfs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    void writeFile(Path file, FSDataOutputStream stm, int size) throws IOException {
        long blocksBefore = stm.getPos() / 8192L;
        TestFileCreation.writeFile(stm, 8192);
        stm.flush();
        int blocksAfter = 0;
        while ((long)blocksAfter <= blocksBefore) {
            BlockLocation[] locatedBlocks = DFSClientAdapter.getDFSClient(hdfs).getBlockLocations(file.toString(), 0L, 40960L);
            blocksAfter = locatedBlocks == null ? 0 : locatedBlocks.length;
        }
    }

    private void verifyFileBlocks(String file, boolean isFileOpen) throws IOException {
        BlockInfoContiguous curBlock;
        int idx;
        FSNamesystem ns = cluster.getNamesystem();
        INodeFile inode = INodeFile.valueOf((INode)ns.dir.getINode(file), (String)file);
        Assert.assertTrue((String)("File " + inode.toString() + " isUnderConstruction = " + inode.isUnderConstruction() + " expected to be " + isFileOpen), (inode.isUnderConstruction() == isFileOpen ? 1 : 0) != 0);
        BlockInfoContiguous[] blocks = inode.getBlocks();
        Assert.assertTrue((String)("File does not have blocks: " + inode.toString()), (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
        for (idx = 0; idx < blocks.length - 2; ++idx) {
            curBlock = blocks[idx];
            Assert.assertTrue((String)("Block is not complete: " + curBlock), (boolean)curBlock.isComplete());
            Assert.assertTrue((String)("Block is not in BlocksMap: " + curBlock), (ns.getBlockManager().getStoredBlock((Block)curBlock) == curBlock ? 1 : 0) != 0);
        }
        if (idx > 0) {
            curBlock = blocks[idx - 1];
            Assert.assertTrue((String)("Block " + curBlock + " isUnderConstruction = " + inode.isUnderConstruction() + " expected to be " + isFileOpen), (isFileOpen && curBlock.isComplete() || !isFileOpen && !curBlock.isComplete() == (curBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) ? 1 : 0) != 0);
            Assert.assertTrue((String)("Block is not in BlocksMap: " + curBlock), (ns.getBlockManager().getStoredBlock((Block)curBlock) == curBlock ? 1 : 0) != 0);
        }
        curBlock = blocks[idx];
        if (!isFileOpen) {
            Assert.assertTrue((String)("Block " + curBlock + ", isFileOpen = " + isFileOpen), (boolean)curBlock.isComplete());
        }
        Assert.assertTrue((String)("Block is not in BlocksMap: " + curBlock), (ns.getBlockManager().getStoredBlock((Block)curBlock) == curBlock ? 1 : 0) != 0);
    }

    @Test
    public void testBlockCreation() throws IOException {
        Path file1 = new Path(BASE_DIR, "file1.dat");
        FSDataOutputStream out = TestFileCreation.createFile((FileSystem)hdfs, file1, 3);
        for (int idx = 0; idx < 5; ++idx) {
            this.writeFile(file1, out, 8192);
            this.verifyFileBlocks(file1.toString(), true);
        }
        out.close();
        this.verifyFileBlocks(file1.toString(), false);
    }

    @Test
    public void testGetBlockLocations() throws IOException {
        NamenodeProtocols namenode = cluster.getNameNodeRpc();
        Path p = new Path(BASE_DIR, "file2.dat");
        String src = p.toString();
        FSDataOutputStream out = TestFileCreation.createFile((FileSystem)hdfs, p, 3);
        int len = 4096;
        this.writeFile(p, out, len);
        int i = 1;
        while (i < 5) {
            LocatedBlocks lb = namenode.getBlockLocations(src, 0L, (long)len);
            List blocks = lb.getLocatedBlocks();
            Assert.assertEquals((long)i, (long)blocks.size());
            Block b = ((LocatedBlock)blocks.get(blocks.size() - 1)).getBlock().getLocalBlock();
            Assert.assertTrue((boolean)(b instanceof BlockInfoContiguousUnderConstruction));
            if (++i >= 5) continue;
            this.writeFile(p, out, 8192);
            len += 8192;
        }
        out.close();
    }

    @Test
    public void testEmptyExpectedLocations() throws Exception {
        NamenodeProtocols namenode = cluster.getNameNodeRpc();
        FSNamesystem fsn = cluster.getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        Path p = new Path(BASE_DIR, "file2.dat");
        String src = p.toString();
        FSDataOutputStream out = TestFileCreation.createFile((FileSystem)hdfs, p, 1);
        this.writeFile(p, out, 256);
        out.hflush();
        LocatedBlocks lbs = namenode.getBlockLocations(src, 0L, 256L);
        LocatedBlock lastLB = (LocatedBlock)lbs.getLocatedBlocks().get(0);
        Block b = lastLB.getBlock().getLocalBlock();
        long blockRecoveryId = fsn.getBlockIdManager().nextGenerationStamp(false);
        BlockInfoContiguousUnderConstruction uc = bm.getStoredBlock(b).convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        uc.initializeBlockRecovery(blockRecoveryId, false);
        try {
            String[] storages = new String[]{"invalid-storage-id1"};
            fsn.commitBlockSynchronization(lastLB.getBlock(), blockRecoveryId, 256L, true, false, (DatanodeID[])lastLB.getLocations(), storages);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        lbs = namenode.getBlockLocations(src, 0L, 256L);
    }
}

