/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.VolumeScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockScanner {
    public static final Logger LOG = LoggerFactory.getLogger(TestBlockScanner.class);

    @Before
    public void before() {
        BlockScanner.Conf.allowUnitTestSettings = true;
        GenericTestUtils.setLogLevel((Logger)BlockScanner.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)VolumeScanner.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)FsVolumeImpl.LOG, (Level)Level.ALL);
    }

    private static void disableBlockScanner(Configuration conf) {
        conf.setLong("dfs.block.scanner.volume.bytes.per.second", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testVolumeIteratorImpl(int numFiles, long maxStaleness) throws Exception {
        Configuration conf = new Configuration();
        TestBlockScanner.disableBlockScanner(conf);
        TestContext ctx = new TestContext(conf, 1);
        ctx.createFiles(0, numFiles, 1);
        Assert.assertEquals((long)1L, (long)ctx.volumes.size());
        FsVolumeSpi volume = ctx.volumes.get(0);
        ExtendedBlock savedBlock = null;
        ExtendedBlock loadedBlock = null;
        boolean testedRewind = false;
        boolean testedSave = false;
        boolean testedLoad = false;
        int blocksProcessed = 0;
        int savedBlocksProcessed = 0;
        try {
            BPOfferService[] bpos = ctx.datanode.getAllBpOs();
            Assert.assertEquals((long)1L, (long)bpos.length);
            FsVolumeSpi.BlockIterator iter = volume.newBlockIterator(ctx.bpids[0], "test");
            Assert.assertEquals((Object)ctx.bpids[0], (Object)iter.getBlockPoolId());
            iter.setMaxStalenessMs(maxStaleness);
            while (true) {
                ExtendedBlock block;
                HashSet<ExtendedBlock> blocks = new HashSet<ExtendedBlock>();
                for (int blockIdx = 0; blockIdx < numFiles; ++blockIdx) {
                    blocks.add(ctx.getFileBlock(0, blockIdx));
                }
                while ((block = iter.nextBlock()) != null) {
                    LOG.info("BlockIterator for {} found block {}, blocksProcessed = {}", new Object[]{volume, block, ++blocksProcessed});
                    if (testedSave && savedBlock == null) {
                        savedBlock = block;
                    }
                    if (testedLoad && loadedBlock == null) {
                        loadedBlock = block;
                        Assert.assertEquals((Object)savedBlock, (Object)loadedBlock);
                    }
                    boolean blockRemoved = blocks.remove(block);
                    Assert.assertTrue((String)("Found unknown block " + block), (boolean)blockRemoved);
                    if (blocksProcessed > numFiles / 3 && !testedSave) {
                        LOG.info("Processed {} blocks out of {}.  Saving iterator.", (Object)blocksProcessed, (Object)numFiles);
                        iter.save();
                        testedSave = true;
                        savedBlocksProcessed = blocksProcessed;
                    }
                    if (blocksProcessed > numFiles / 2 && !testedRewind) {
                        LOG.info("Processed {} blocks out of {}.  Rewinding iterator.", (Object)blocksProcessed, (Object)numFiles);
                        iter.rewind();
                        break;
                    }
                    if (blocksProcessed <= 2 * numFiles / 3 || testedLoad) continue;
                    LOG.info("Processed {} blocks out of {}.  Loading iterator.", (Object)blocksProcessed, (Object)numFiles);
                    iter = volume.loadBlockIterator(ctx.bpids[0], "test");
                    iter.setMaxStalenessMs(maxStaleness);
                    break;
                }
                if (!testedRewind) {
                    testedRewind = true;
                    blocksProcessed = 0;
                    LOG.info("Starting again at the beginning...");
                    continue;
                }
                if (testedLoad) break;
                testedLoad = true;
                blocksProcessed = savedBlocksProcessed;
                LOG.info("Starting again at the load point...");
            }
            Assert.assertEquals((long)numFiles, (long)blocksProcessed);
        }
        finally {
            ctx.close();
        }
    }

    @Test(timeout=60000L)
    public void testVolumeIteratorWithoutCaching() throws Exception {
        this.testVolumeIteratorImpl(5, 0L);
    }

    @Test(timeout=60000L)
    public void testVolumeIteratorWithCaching() throws Exception {
        this.testVolumeIteratorImpl(600, 100L);
    }

    @Test(timeout=60000L)
    public void testDisableVolumeScanner() throws Exception {
        Configuration conf = new Configuration();
        TestBlockScanner.disableBlockScanner(conf);
        try (TestContext ctx = new TestContext(conf, 1);){
            Assert.assertFalse((boolean)ctx.datanode.getBlockScanner().isEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScanAllBlocksImpl(final boolean rescan) throws Exception {
        TestScanResultHandler.Info info;
        Configuration conf = new Configuration();
        conf.setLong("dfs.block.scanner.volume.bytes.per.second", 0x100000L);
        if (rescan) {
            conf.setLong("internal.dfs.datanode.scan.period.ms.key", 100L);
        } else {
            conf.setLong("dfs.datanode.scan.period.hours", 100L);
        }
        conf.set("internal.volume.scanner.scan.result.handler", TestScanResultHandler.class.getName());
        final TestContext ctx = new TestContext(conf, 1);
        int NUM_EXPECTED_BLOCKS = 10;
        ctx.createFiles(0, 10, 1);
        final HashSet<ExtendedBlock> expectedBlocks = new HashSet<ExtendedBlock>();
        for (int i = 0; i < 10; ++i) {
            expectedBlocks.add(ctx.getFileBlock(0, i));
        }
        TestScanResultHandler.Info info2 = info = TestScanResultHandler.getInfo(ctx.volumes.get(0));
        synchronized (info2) {
            info.shouldRun = true;
            info.notify();
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info = TestScanResultHandler.getInfo(ctx.volumes.get(0));
                int numFoundBlocks = 0;
                StringBuilder foundBlocksBld = new StringBuilder();
                String prefix = "";
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    for (ExtendedBlock block : info.goodBlocks) {
                        Assert.assertTrue((boolean)expectedBlocks.contains(block));
                        ++numFoundBlocks;
                        foundBlocksBld.append(prefix).append(block);
                        prefix = ", ";
                    }
                    LOG.info("numFoundBlocks = {}.  blocksScanned = {}. Found blocks {}", new Object[]{numFoundBlocks, info.blocksScanned, foundBlocksBld.toString()});
                    if (rescan) {
                        return numFoundBlocks == 10 && info.blocksScanned >= 20L;
                    }
                    return numFoundBlocks == 10;
                }
            }
        }, (int)10, (int)60000);
        if (!rescan) {
            info2 = info;
            synchronized (info2) {
                Assert.assertEquals((long)10L, (long)info.blocksScanned);
            }
            VolumeScanner.Statistics stats = ctx.blockScanner.getVolumeStats(ctx.volumes.get(0).getStorageID());
            Assert.assertEquals((long)50L, (long)stats.bytesScannedInPastHour);
            Assert.assertEquals((long)10L, (long)stats.blocksScannedSinceRestart);
            Assert.assertEquals((long)10L, (long)stats.blocksScannedInCurrentPeriod);
            Assert.assertEquals((long)0L, (long)stats.scanErrorsSinceRestart);
            Assert.assertEquals((long)1L, (long)stats.scansSinceRestart);
        }
        ctx.close();
    }

    @Test(timeout=60000L)
    public void testScanAllBlocksNoRescan() throws Exception {
        this.testScanAllBlocksImpl(false);
    }

    @Test(timeout=60000L)
    public void testScanAllBlocksWithRescan() throws Exception {
        this.testScanAllBlocksImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testScanRateLimit() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.block.scanner.volume.bytes.per.second", 4096L);
        conf.setLong("internal.dfs.datanode.scan.period.ms.key", 1L);
        conf.set("internal.volume.scanner.scan.result.handler", TestScanResultHandler.class.getName());
        TestContext ctx = new TestContext(conf, 1);
        int NUM_EXPECTED_BLOCKS = 5;
        ctx.createFiles(0, 5, 4096);
        final TestScanResultHandler.Info info = TestScanResultHandler.getInfo(ctx.volumes.get(0));
        long startMs = Time.monotonicNow();
        TestScanResultHandler.Info info2 = info;
        synchronized (info2) {
            info.shouldRun = true;
            info.notify();
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    return info.blocksScanned > 0L;
                }
            }
        }, (int)1, (int)30000);
        Thread.sleep(2000L);
        info2 = info;
        synchronized (info2) {
            long endMs = Time.monotonicNow();
            long seconds = (endMs + 999L - startMs) / 1000L;
            long maxBlocksScanned = seconds * 1L;
            Assert.assertTrue((String)("The number of blocks scanned is too large.  Scanned " + info.blocksScanned + " blocks; only expected to scan at most " + maxBlocksScanned + " in " + seconds + " seconds."), (info.blocksScanned <= maxBlocksScanned ? 1 : 0) != 0);
        }
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCorruptBlockHandling() throws Exception {
        TestScanResultHandler.Info info;
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.scan.period.hours", 100L);
        conf.set("internal.volume.scanner.scan.result.handler", TestScanResultHandler.class.getName());
        TestContext ctx = new TestContext(conf, 1);
        int NUM_EXPECTED_BLOCKS = 5;
        int CORRUPT_INDEX = 3;
        ctx.createFiles(0, 5, 4);
        ExtendedBlock badBlock = ctx.getFileBlock(0, 3);
        ctx.cluster.corruptBlockOnDataNodes(badBlock);
        TestScanResultHandler.Info info2 = info = TestScanResultHandler.getInfo(ctx.volumes.get(0));
        synchronized (info2) {
            info.shouldRun = true;
            info.notify();
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    return info.blocksScanned == 5L;
                }
            }
        }, (int)3, (int)30000);
        info2 = info;
        synchronized (info2) {
            Assert.assertTrue((boolean)info.badBlocks.contains(badBlock));
            for (int i = 0; i < 5; ++i) {
                if (i == 3) continue;
                ExtendedBlock block = ctx.getFileBlock(0, i);
                Assert.assertTrue((boolean)info.goodBlocks.contains(block));
            }
        }
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testDatanodeCursor() throws Exception {
        TestScanResultHandler.Info info;
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.scan.period.hours", 100L);
        conf.set("internal.volume.scanner.scan.result.handler", TestScanResultHandler.class.getName());
        conf.setLong("dfs.block.scanner.cursor.save.interval.ms", 0L);
        TestContext ctx = new TestContext(conf, 1);
        int NUM_EXPECTED_BLOCKS = 10;
        ctx.createFiles(0, 10, 1);
        TestScanResultHandler.Info info2 = info = TestScanResultHandler.getInfo(ctx.volumes.get(0));
        synchronized (info2) {
            info.sem = new Semaphore(5);
            info.shouldRun = true;
            info.notify();
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    return info.blocksScanned == 5L;
                }
            }
        }, (int)3, (int)30000);
        info2 = info;
        synchronized (info2) {
            Assert.assertEquals((long)5L, (long)info.goodBlocks.size());
            Assert.assertEquals((long)5L, (long)info.blocksScanned);
            info.shouldRun = false;
        }
        ctx.datanode.shutdown();
        String vPath = ctx.volumes.get(0).getBasePath();
        File cursorPath = new File(new File(new File(vPath, "current"), ctx.bpids[0]), "scanner.cursor");
        Assert.assertTrue((String)("Failed to find cursor save file in " + cursorPath.getAbsolutePath()), (boolean)cursorPath.exists());
        HashSet<ExtendedBlock> prevGoodBlocks = new HashSet<ExtendedBlock>();
        TestScanResultHandler.Info info3 = info;
        synchronized (info3) {
            info.sem = new Semaphore(4);
            prevGoodBlocks.addAll(info.goodBlocks);
            info.goodBlocks.clear();
        }
        ctx.cluster.restartDataNode(0);
        info3 = info;
        synchronized (info3) {
            info.shouldRun = true;
            info.notify();
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    if (info.blocksScanned != 9L) {
                        LOG.info("Waiting for blocksScanned to reach 9.  It is at {}", (Object)info.blocksScanned);
                    }
                    return info.blocksScanned == 9L;
                }
            }
        }, (int)3, (int)30000);
        info3 = info;
        synchronized (info3) {
            Assert.assertEquals((long)4L, (long)info.goodBlocks.size());
            info.goodBlocks.addAll(prevGoodBlocks);
            Assert.assertEquals((long)9L, (long)info.goodBlocks.size());
            Assert.assertEquals((long)9L, (long)info.blocksScanned);
        }
        ctx.datanode.shutdown();
        info3 = info;
        synchronized (info3) {
            info.sem = null;
            info.shouldRun = false;
            info.goodBlocks.clear();
        }
        ctx.cluster.restartDataNode(0);
        info3 = info;
        synchronized (info3) {
            info.shouldRun = true;
            info.notify();
        }
        Thread.sleep(3000L);
        info3 = info;
        synchronized (info3) {
            Assert.assertTrue((boolean)info.goodBlocks.isEmpty());
        }
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testMultipleBlockPoolScanning() throws Exception {
        TestScanResultHandler.Info info;
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.scan.period.hours", 100L);
        conf.set("internal.volume.scanner.scan.result.handler", TestScanResultHandler.class.getName());
        final TestContext ctx = new TestContext(conf, 3);
        int BYTES_SCANNED_PER_FILE = 5;
        int[] NUM_FILES = new int[]{1, 5, 10};
        int TOTAL_FILES = 0;
        for (int i = 0; i < NUM_FILES.length; ++i) {
            TOTAL_FILES += NUM_FILES[i];
        }
        ctx.createFiles(0, NUM_FILES[0], 1);
        ctx.createFiles(0, NUM_FILES[1], 1);
        ctx.createFiles(0, NUM_FILES[2], 1);
        TestScanResultHandler.Info info2 = info = TestScanResultHandler.getInfo(ctx.volumes.get(0));
        synchronized (info2) {
            info.shouldRun = true;
            info.notify();
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    VolumeScanner.Statistics stats = ctx.blockScanner.getVolumeStats(ctx.volumes.get(0).getStorageID());
                    if (stats.scansSinceRestart < 3L) {
                        LOG.info("Waiting for scansSinceRestart to reach 3 (it is {})", (Object)stats.scansSinceRestart);
                        return false;
                    }
                    if (!stats.eof) {
                        LOG.info("Waiting for eof.");
                        return false;
                    }
                    return true;
                }
            }
        }, (int)3, (int)30000);
        VolumeScanner.Statistics stats = ctx.blockScanner.getVolumeStats(ctx.volumes.get(0).getStorageID());
        Assert.assertEquals((long)TOTAL_FILES, (long)stats.blocksScannedSinceRestart);
        Assert.assertEquals((long)(5 * TOTAL_FILES), (long)stats.bytesScannedInPastHour);
        ctx.close();
    }

    @Test(timeout=120000L)
    public void testNextSorted() throws Exception {
        LinkedList<String> arr = new LinkedList<String>();
        arr.add("1");
        arr.add("3");
        arr.add("5");
        arr.add("7");
        Assert.assertEquals((Object)"3", (Object)FsVolumeImpl.nextSorted(arr, (String)"2"));
        Assert.assertEquals((Object)"3", (Object)FsVolumeImpl.nextSorted(arr, (String)"1"));
        Assert.assertEquals((Object)"1", (Object)FsVolumeImpl.nextSorted(arr, (String)""));
        Assert.assertEquals((Object)"1", (Object)FsVolumeImpl.nextSorted(arr, null));
        Assert.assertEquals(null, (Object)FsVolumeImpl.nextSorted(arr, (String)"9"));
    }

    @Test(timeout=120000L)
    public void testCalculateNeededBytesPerSec() throws Exception {
        Assert.assertTrue((boolean)VolumeScanner.calculateShouldScan((String)"test", (long)100L, (long)0L, (long)0L, (long)60L));
        Assert.assertFalse((boolean)VolumeScanner.calculateShouldScan((String)"test", (long)100L, (long)363600L, (long)1000L, (long)5000L));
        Assert.assertTrue((boolean)VolumeScanner.calculateShouldScan((String)"test", (long)1L, (long)3540L, (long)0L, (long)60L));
        Assert.assertTrue((boolean)VolumeScanner.calculateShouldScan((String)"test", (long)100000L, (long)354000000L, (long)0L, (long)60L));
        Assert.assertFalse((boolean)VolumeScanner.calculateShouldScan((String)"test", (long)100000L, (long)365000000L, (long)0L, (long)60L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testMarkSuspectBlock() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.scan.period.hours", 100L);
        conf.set("internal.volume.scanner.scan.result.handler", TestScanResultHandler.class.getName());
        conf.setLong("dfs.block.scanner.cursor.save.interval.ms", 0L);
        TestContext ctx = new TestContext(conf, 1);
        int NUM_EXPECTED_BLOCKS = 10;
        ctx.createFiles(0, 10, 1);
        final TestScanResultHandler.Info info = TestScanResultHandler.getInfo(ctx.volumes.get(0));
        String storageID = ((FsVolumeSpi)ctx.datanode.getFSDataset().getVolumes().get(0)).getStorageID();
        TestScanResultHandler.Info info2 = info;
        synchronized (info2) {
            info.sem = new Semaphore(4);
            info.shouldRun = true;
            info.notify();
        }
        LOG.info("Waiting for the first 4 blocks to be scanned.");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    if (info.blocksScanned >= 4L) {
                        LOG.info("info = {}.  blockScanned has now reached 4.", (Object)info);
                        return true;
                    }
                    LOG.info("info = {}.  Waiting for blockScanned to reach 4.", (Object)info);
                    return false;
                }
            }
        }, (int)50, (int)30000);
        info2 = info;
        synchronized (info2) {
            Assert.assertEquals((String)"Expected 4 good blocks.", (long)4L, (long)info.goodBlocks.size());
            info.goodBlocks.clear();
            Assert.assertEquals((String)"Expected 4 blocksScanned", (long)4L, (long)info.blocksScanned);
            Assert.assertEquals((String)"Did not expect bad blocks.", (long)0L, (long)info.badBlocks.size());
            info.blocksScanned = 0L;
        }
        ExtendedBlock first = ctx.getFileBlock(0, 0);
        ctx.datanode.getBlockScanner().markSuspectBlock(storageID, first);
        info.sem.release(2);
        LOG.info("Waiting for 2 more blocks to be scanned.");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    if (info.blocksScanned >= 2L) {
                        LOG.info("info = {}.  blockScanned has now reached 2.", (Object)info);
                        return true;
                    }
                    LOG.info("info = {}.  Waiting for blockScanned to reach 2.", (Object)info);
                    return false;
                }
            }
        }, (int)50, (int)30000);
        TestScanResultHandler.Info info3 = info;
        synchronized (info3) {
            Assert.assertTrue((String)("Expected block " + first + " to have been scanned."), (boolean)info.goodBlocks.contains(first));
            Assert.assertEquals((long)2L, (long)info.goodBlocks.size());
            info.goodBlocks.clear();
            Assert.assertEquals((String)"Did not expect bad blocks.", (long)0L, (long)info.badBlocks.size());
            Assert.assertEquals((long)2L, (long)info.blocksScanned);
            info.blocksScanned = 0L;
        }
        ctx.datanode.getBlockScanner().markSuspectBlock(storageID, first);
        info.sem.release(10);
        LOG.info("Waiting for 5 more blocks to be scanned.");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                TestScanResultHandler.Info info2 = info;
                synchronized (info2) {
                    if (info.blocksScanned >= 5L) {
                        LOG.info("info = {}.  blockScanned has now reached 5.", (Object)info);
                        return true;
                    }
                    LOG.info("info = {}.  Waiting for blockScanned to reach 5.", (Object)info);
                    return false;
                }
            }
        }, (int)50, (int)30000);
        info3 = info;
        synchronized (info3) {
            Assert.assertEquals((long)5L, (long)info.goodBlocks.size());
            Assert.assertEquals((long)0L, (long)info.badBlocks.size());
            Assert.assertEquals((long)5L, (long)info.blocksScanned);
            Assert.assertFalse((String)("We should not have rescanned block " + first + ", because it should have been " + "in recentSuspectBlocks."), (boolean)info.goodBlocks.contains(first));
            info.blocksScanned = 0L;
        }
    }

    public static class TestScanResultHandler
    extends VolumeScanner.ScanResultHandler {
        private VolumeScanner scanner;
        static final ConcurrentHashMap<String, Info> infos = new ConcurrentHashMap();

        static Info getInfo(FsVolumeSpi volume) {
            Info newInfo = new Info();
            Info prevInfo = infos.putIfAbsent(volume.getStorageID(), newInfo);
            return prevInfo == null ? newInfo : prevInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setup(VolumeScanner scanner) {
            this.scanner = scanner;
            Info info = TestScanResultHandler.getInfo(scanner.volume);
            LOG.info("about to start scanning.");
            Info info2 = info;
            synchronized (info2) {
                while (!info.shouldRun) {
                    try {
                        info.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            LOG.info("starting scanning.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(ExtendedBlock block, IOException e) {
            Semaphore sem;
            Info info;
            LOG.info("handling block {} (exception {})", (Object)block, (Object)e);
            Info info2 = info = TestScanResultHandler.getInfo(this.scanner.volume);
            synchronized (info2) {
                sem = info.sem;
            }
            if (sem != null) {
                try {
                    sem.acquire();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("interrupted");
                }
            }
            info2 = info;
            synchronized (info2) {
                if (!info.shouldRun) {
                    throw new RuntimeException("stopping volumescanner thread.");
                }
                if (e == null) {
                    info.goodBlocks.add(block);
                } else {
                    info.badBlocks.add(block);
                }
                ++info.blocksScanned;
            }
        }

        static class Info {
            boolean shouldRun = false;
            final Set<ExtendedBlock> badBlocks = new HashSet<ExtendedBlock>();
            final Set<ExtendedBlock> goodBlocks = new HashSet<ExtendedBlock>();
            long blocksScanned = 0L;
            Semaphore sem = null;

            Info() {
            }

            public String toString() {
                StringBuilder bld = new StringBuilder();
                bld.append("ScanResultHandler.Info{");
                bld.append("shouldRun=").append(this.shouldRun).append(", ");
                bld.append("blocksScanned=").append(this.blocksScanned).append(", ");
                bld.append("sem#availablePermits=").append(this.sem.availablePermits()).append(", ");
                bld.append("badBlocks=").append(this.badBlocks).append(", ");
                bld.append("goodBlocks=").append(this.goodBlocks);
                bld.append("}");
                return bld.toString();
            }
        }
    }

    private static class TestContext
    implements Closeable {
        final int numNameServices;
        final MiniDFSCluster cluster;
        final DistributedFileSystem[] dfs;
        final String[] bpids;
        final DataNode datanode;
        final BlockScanner blockScanner;
        final FsDatasetSpi<? extends FsVolumeSpi> data;
        final List<? extends FsVolumeSpi> volumes;

        TestContext(Configuration conf, int numNameServices) throws Exception {
            int i;
            this.numNameServices = numNameServices;
            MiniDFSCluster.Builder bld = new MiniDFSCluster.Builder(conf).numDataNodes(1).storagesPerDatanode(1);
            if (numNameServices > 1) {
                bld.nnTopology(MiniDFSNNTopology.simpleFederatedTopology(numNameServices));
            }
            this.cluster = bld.build();
            this.cluster.waitActive();
            this.dfs = new DistributedFileSystem[numNameServices];
            for (i = 0; i < numNameServices; ++i) {
                this.dfs[i] = this.cluster.getFileSystem(i);
            }
            this.bpids = new String[numNameServices];
            for (i = 0; i < numNameServices; ++i) {
                this.bpids[i] = this.cluster.getNamesystem(i).getBlockPoolId();
            }
            this.datanode = this.cluster.getDataNodes().get(0);
            this.blockScanner = this.datanode.getBlockScanner();
            for (i = 0; i < numNameServices; ++i) {
                this.dfs[i].mkdirs(new Path("/test"));
            }
            this.data = this.datanode.getFSDataset();
            this.volumes = this.data.getVolumes();
        }

        @Override
        public void close() throws IOException {
            if (this.cluster != null) {
                for (int i = 0; i < this.numNameServices; ++i) {
                    this.dfs[i].delete(new Path("/test"), true);
                }
                this.cluster.shutdown();
            }
        }

        public void createFiles(int nsIdx, int numFiles, int length) throws Exception {
            for (int blockIdx = 0; blockIdx < numFiles; ++blockIdx) {
                DFSTestUtil.createFile((FileSystem)this.dfs[nsIdx], this.getPath(blockIdx), length, (short)1, 123L);
            }
        }

        public Path getPath(int fileIdx) {
            return new Path("/test/" + fileIdx);
        }

        public ExtendedBlock getFileBlock(int nsIdx, int fileIdx) throws Exception {
            return DFSTestUtil.getFirstBlock((FileSystem)this.dfs[nsIdx], this.getPath(fileIdx));
        }
    }
}

