/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.util.VersionInfo;

public class NamespaceInfo
extends StorageInfo
implements Writable {
    String revision;
    String version;
    int distributedUpgradeVersion;

    public NamespaceInfo() {
    }

    public NamespaceInfo(int nsID, long cT, int duVersion) {
        super(-32, nsID, cT);
        this.version = VersionInfo.getVersion();
        this.revision = VersionInfo.getRevision();
        this.distributedUpgradeVersion = duVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRevision() {
        return this.revision;
    }

    public int getDistributedUpgradeVersion() {
        return this.distributedUpgradeVersion;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.getVersion());
        UTF8.writeString(out, this.getRevision());
        out.writeInt(this.getLayoutVersion());
        out.writeInt(this.getNamespaceID());
        out.writeLong(this.getCTime());
        out.writeInt(this.getDistributedUpgradeVersion());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.version = UTF8.readString(in);
        this.revision = UTF8.readString(in);
        this.layoutVersion = in.readInt();
        this.namespaceID = in.readInt();
        this.cTime = in.readLong();
        this.distributedUpgradeVersion = in.readInt();
    }

    static {
        WritableFactories.setFactory(NamespaceInfo.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new NamespaceInfo();
            }
        });
    }
}

