/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.serializer.JavaSerializationComparator;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSequenceFileAppend {
    private static Configuration conf;
    private static FileSystem fs;
    private static Path ROOT_PATH;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        conf.set("fs.file.impl", "org.apache.hadoop.fs.RawLocalFileSystem");
        fs = FileSystem.get((Configuration)conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        fs.close();
    }

    @Test(timeout=30000L)
    public void testAppend() throws Exception {
        SequenceFile.Writer.Option wrongCompressOption2;
        Path file = new Path(ROOT_PATH, "testseqappend.seq");
        fs.delete(file, true);
        Text key1 = new Text("Key1");
        Text value1 = new Text("Value1");
        Text value2 = new Text("Updated");
        SequenceFile.Metadata metadata = new SequenceFile.Metadata();
        metadata.set(key1, value1);
        SequenceFile.Writer.Option metadataOption = SequenceFile.Writer.metadata((SequenceFile.Metadata)metadata);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), metadataOption});
        writer.append((Object)1L, (Object)"one");
        writer.append((Object)2L, (Object)"two");
        writer.close();
        this.verify2Values(file);
        metadata.set(key1, value2);
        writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), metadataOption});
        Assert.assertEquals((Object)value1, (Object)writer.metadata.get(key1));
        writer.append((Object)3L, (Object)"three");
        writer.append((Object)4L, (Object)"four");
        writer.close();
        this.verifyAll4Values(file);
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
        Assert.assertEquals((Object)value1, (Object)reader.getMetadata().get(key1));
        reader.close();
        try {
            wrongCompressOption2 = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD, (CompressionCodec)new GzipCodec());
            writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), wrongCompressOption2});
            writer.close();
            Assert.fail((String)"Expected IllegalArgumentException for compression options");
        }
        catch (IllegalArgumentException wrongCompressOption2) {
            // empty catch block
        }
        try {
            wrongCompressOption2 = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new DefaultCodec());
            writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), wrongCompressOption2});
            writer.close();
            Assert.fail((String)"Expected IllegalArgumentException for compression options");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fs.deleteOnExit(file);
    }

    @Test(timeout=30000L)
    public void testAppendRecordCompression() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Path file = new Path(ROOT_PATH, "testseqappendblockcompr.seq");
        fs.delete(file, true);
        SequenceFile.Writer.Option compressOption = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD, (CompressionCodec)new GzipCodec());
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), compressOption});
        writer.append((Object)1L, (Object)"one");
        writer.append((Object)2L, (Object)"two");
        writer.close();
        this.verify2Values(file);
        writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), compressOption});
        writer.append((Object)3L, (Object)"three");
        writer.append((Object)4L, (Object)"four");
        writer.close();
        this.verifyAll4Values(file);
        fs.deleteOnExit(file);
    }

    @Test(timeout=30000L)
    public void testAppendBlockCompression() throws Exception {
        SequenceFile.Writer.Option wrongCompressOption2;
        GenericTestUtils.assumeInNativeProfile();
        Path file = new Path(ROOT_PATH, "testseqappendblockcompr.seq");
        fs.delete(file, true);
        SequenceFile.Writer.Option compressOption = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new GzipCodec());
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), compressOption});
        writer.append((Object)1L, (Object)"one");
        writer.append((Object)2L, (Object)"two");
        writer.close();
        this.verify2Values(file);
        writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), compressOption});
        writer.append((Object)3L, (Object)"three");
        writer.append((Object)4L, (Object)"four");
        writer.close();
        this.verifyAll4Values(file);
        try {
            writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true)});
            writer.close();
            Assert.fail((String)"Expected IllegalArgumentException for compression options");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            wrongCompressOption2 = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD, (CompressionCodec)new GzipCodec());
            writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), wrongCompressOption2});
            writer.close();
            Assert.fail((String)"Expected IllegalArgumentException for compression options");
        }
        catch (IllegalArgumentException wrongCompressOption2) {
            // empty catch block
        }
        try {
            wrongCompressOption2 = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new DefaultCodec());
            writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), wrongCompressOption2});
            writer.close();
            Assert.fail((String)"Expected IllegalArgumentException for compression options");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fs.deleteOnExit(file);
    }

    @Test(timeout=30000L)
    public void testAppendSort() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Path file = new Path(ROOT_PATH, "testseqappendSort.seq");
        fs.delete(file, true);
        Path sortedFile = new Path(ROOT_PATH, "testseqappendSort.seq.sort");
        fs.delete(sortedFile, true);
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, (RawComparator)new JavaSerializationComparator(), Long.class, String.class, conf);
        SequenceFile.Writer.Option compressOption = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new GzipCodec());
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), compressOption});
        writer.append((Object)2L, (Object)"two");
        writer.append((Object)1L, (Object)"one");
        writer.close();
        writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)file), SequenceFile.Writer.keyClass(Long.class), SequenceFile.Writer.valueClass(String.class), SequenceFile.Writer.appendIfExists((boolean)true), compressOption});
        writer.append((Object)4L, (Object)"four");
        writer.append((Object)3L, (Object)"three");
        writer.close();
        sorter.sort(file, sortedFile);
        this.verifyAll4Values(sortedFile);
        fs.deleteOnExit(file);
        fs.deleteOnExit(sortedFile);
    }

    private void verify2Values(Path file) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
        Assert.assertEquals((Object)1L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"one", (Object)reader.getCurrentValue((Object)null));
        Assert.assertEquals((Object)2L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"two", (Object)reader.getCurrentValue((Object)null));
        Assert.assertNull((Object)reader.next((Object)null));
        reader.close();
    }

    private void verifyAll4Values(Path file) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
        Assert.assertEquals((Object)1L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"one", (Object)reader.getCurrentValue((Object)null));
        Assert.assertEquals((Object)2L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"two", (Object)reader.getCurrentValue((Object)null));
        Assert.assertEquals((Object)3L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"three", (Object)reader.getCurrentValue((Object)null));
        Assert.assertEquals((Object)4L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"four", (Object)reader.getCurrentValue((Object)null));
        Assert.assertNull((Object)reader.next((Object)null));
        reader.close();
    }

    static {
        ROOT_PATH = new Path(System.getProperty("test.build.data", "build/test/data"));
    }
}

