/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MetricsSourceAdapter;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsAnnotations;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricsSourceBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.junit.Assert;
import org.junit.Test;

public class TestMetricsSourceAdapter {
    @Test
    public void testPurgeOldMetrics() throws Exception {
        PurgableSource source = new PurgableSource();
        MetricsSourceBuilder sb = MetricsAnnotations.newSourceBuilder((Object)source);
        MetricsSource s = sb.build();
        ArrayList injectedTags = new ArrayList();
        MetricsSourceAdapter sa = new MetricsSourceAdapter("tst", "tst", "testdesc", s, injectedTags, null, null, 1, false);
        MBeanInfo info = sa.getMBeanInfo();
        boolean sawIt = false;
        for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
            sawIt |= mBeanAttributeInfo.getName().equals(source.lastKeyName);
        }
        Assert.assertTrue((String)"The last generated metric is not exported to jmx", (boolean)sawIt);
        Thread.sleep(1000L);
        info = sa.getMBeanInfo();
        sawIt = false;
        for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
            sawIt |= mBeanAttributeInfo.getName().equals(source.lastKeyName);
        }
        Assert.assertTrue((String)"The last generated metric is not exported to jmx", (boolean)sawIt);
    }

    @Test
    public void testGetMetricsAndJmx() throws Exception {
        TestSource source = new TestSource("test");
        MetricsSourceBuilder sb = MetricsAnnotations.newSourceBuilder((Object)source);
        MetricsSource s = sb.build();
        ArrayList injectedTags = new ArrayList();
        MetricsSourceAdapter sa = new MetricsSourceAdapter("test", "test", "test desc", s, injectedTags, null, null, 1, false);
        MetricsCollectorImpl builder = new MetricsCollectorImpl();
        Iterable metricsRecords = sa.getMetrics(builder, true);
        MetricsRecordImpl metricsRecord = (MetricsRecordImpl)metricsRecords.iterator().next();
        Assert.assertEquals((long)0L, (long)((AbstractMetric)metricsRecord.metrics().iterator().next()).value().longValue());
        Thread.sleep(100L);
        Assert.assertEquals((Object)0L, (Object)((Number)sa.getAttribute("C1")));
        source.incrementCnt();
        builder = new MetricsCollectorImpl();
        metricsRecords = sa.getMetrics(builder, true);
        metricsRecord = (MetricsRecordImpl)metricsRecords.iterator().next();
        Assert.assertTrue((boolean)metricsRecord.metrics().iterator().hasNext());
        Thread.sleep(100L);
        Assert.assertEquals((Object)1L, (Object)((Number)sa.getAttribute("C1")));
    }

    @Metrics(context="test")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }

        public void incrementCnt() {
            this.c1.incr();
        }
    }

    class PurgableSource
    implements MetricsSource {
        int nextKey = 0;
        String lastKeyName = null;

        PurgableSource() {
        }

        public void getMetrics(MetricsCollector collector, boolean all) {
            MetricsRecordBuilder rb = collector.addRecord("purgablesource").setContext("test");
            this.lastKeyName = "key" + this.nextKey++;
            rb.addGauge(Interns.info((String)this.lastKeyName, (String)"desc"), 1);
        }
    }
}

